/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.AccountLogger;
import com.zimbra.common.util.ZimbraLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    private Map<String, Logger> mAccountLoggers = new ConcurrentHashMap<String, Logger>();
    private static final Map<Level, org.apache.log4j.Level> ZIMBRA_TO_LOG4J = new HashMap<Level, org.apache.log4j.Level>();
    private static final Map<org.apache.log4j.Level, Level> LOG4J_TO_ZIMBRA = new HashMap<org.apache.log4j.Level, Level>();
    private Logger mLogger;

    Log(Logger logger) {
        if (logger == null) {
            throw new IllegalStateException("logger cannot be null");
        }
        this.mLogger = logger;
    }

    public void addAccountLogger(String accountName, Level level) {
        if (accountName == null || level == null) {
            return;
        }
        Logger accountLogger = this.mAccountLoggers.get(accountName);
        if (accountLogger == null) {
            String accountCategory = Log.getAccountCategory(this.getCategory(), accountName);
            accountLogger = Logger.getLogger((String)accountCategory);
            this.mAccountLoggers.put(accountName, accountLogger);
        }
        accountLogger.setLevel(ZIMBRA_TO_LOG4J.get((Object)level));
    }

    public int removeAccountLoggers() {
        int count = this.mAccountLoggers.size();
        this.mAccountLoggers.clear();
        return count;
    }

    public boolean removeAccountLogger(String accountName) {
        Logger logger = this.mAccountLoggers.remove(accountName);
        return logger != null;
    }

    private static String getAccountCategory(String category, String accountName) {
        return String.format("%s.%s", accountName, category);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isEnabledFor(Priority.WARN);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isEnabledFor(Priority.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isEnabledFor(Priority.FATAL);
    }

    public void debug(Object o) {
        this.getLogger().debug(o);
    }

    public void debug(Object o, Throwable t) {
        this.getLogger().debug(o, t);
    }

    public void debug(String format, Object ... objects) {
        if (this.isDebugEnabled()) {
            this.getLogger().debug((Object)String.format(format, objects));
        }
    }

    public void debug(String format, Object o, Throwable t) {
        if (this.isDebugEnabled()) {
            this.getLogger().debug((Object)String.format(format, o), t);
        }
    }

    public void debug(String format, Object o1, Object o2, Throwable t) {
        if (this.isDebugEnabled()) {
            this.getLogger().debug((Object)String.format(format, o1, o2), t);
        }
    }

    public void debug(String format, Object o1, Object o2, Object o3, Throwable t) {
        if (this.isDebugEnabled()) {
            this.getLogger().debug((Object)String.format(format, o1, o2, o3), t);
        }
    }

    public void debug(String format, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        if (this.isDebugEnabled()) {
            this.getLogger().debug((Object)String.format(format, o1, o2, o3, o4), t);
        }
    }

    public void debug(String format, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        if (this.isDebugEnabled()) {
            this.getLogger().debug((Object)String.format(format, o1, o2, o3, o4, o5), t);
        }
    }

    public void info(Object o) {
        this.getLogger().info(o);
    }

    public void info(Object o, Throwable t) {
        this.getLogger().info(o, t);
    }

    public void info(String format, Object ... objects) {
        if (this.isInfoEnabled()) {
            this.getLogger().info((Object)String.format(format, objects));
        }
    }

    public void info(String format, Object o, Throwable t) {
        if (this.isInfoEnabled()) {
            this.getLogger().info((Object)String.format(format, o), t);
        }
    }

    public void info(String format, Object o1, Object o2, Throwable t) {
        if (this.isInfoEnabled()) {
            this.getLogger().info((Object)String.format(format, o1, o2), t);
        }
    }

    public void info(String format, Object o1, Object o2, Object o3, Throwable t) {
        if (this.isInfoEnabled()) {
            this.getLogger().info((Object)String.format(format, o1, o2, o3), t);
        }
    }

    public void info(String format, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        if (this.isInfoEnabled()) {
            this.getLogger().info((Object)String.format(format, o1, o2, o3, o4), t);
        }
    }

    public void info(String format, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        if (this.isInfoEnabled()) {
            this.getLogger().info((Object)String.format(format, o1, o2, o3, o4, o5), t);
        }
    }

    public void warn(Object o) {
        this.getLogger().warn(o);
    }

    public void warn(Object o, Throwable t) {
        this.getLogger().warn(o, t);
    }

    public void warn(String format, Object ... objects) {
        if (this.isWarnEnabled()) {
            this.getLogger().warn((Object)String.format(format, objects));
        }
    }

    public void warn(String format, Object o, Throwable t) {
        if (this.isWarnEnabled()) {
            this.getLogger().warn((Object)String.format(format, o), t);
        }
    }

    public void warn(String format, Object o1, Object o2, Throwable t) {
        if (this.isWarnEnabled()) {
            this.getLogger().warn((Object)String.format(format, o1, o2), t);
        }
    }

    public void warn(String format, Object o1, Object o2, Object o3, Throwable t) {
        if (this.isWarnEnabled()) {
            this.getLogger().warn((Object)String.format(format, o1, o2, o3), t);
        }
    }

    public void warn(String format, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        if (this.isWarnEnabled()) {
            this.getLogger().warn((Object)String.format(format, o1, o2, o3, o4), t);
        }
    }

    public void warn(String format, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        if (this.isWarnEnabled()) {
            this.getLogger().warn((Object)String.format(format, o1, o2, o3, o4, o5), t);
        }
    }

    public void error(Object o) {
        this.getLogger().error(o);
    }

    public void error(Object o, Throwable t) {
        this.getLogger().error(o, t);
    }

    public void error(String format, Object ... objects) {
        if (this.isErrorEnabled()) {
            this.getLogger().error((Object)String.format(format, objects));
        }
    }

    public void error(String format, Object o, Throwable t) {
        if (this.isErrorEnabled()) {
            this.getLogger().error((Object)String.format(format, o), t);
        }
    }

    public void error(String format, Object o1, Object o2, Throwable t) {
        if (this.isErrorEnabled()) {
            this.getLogger().error((Object)String.format(format, o1, o2), t);
        }
    }

    public void error(String format, Object o1, Object o2, Object o3, Throwable t) {
        if (this.isErrorEnabled()) {
            this.getLogger().error((Object)String.format(format, o1, o2, o3), t);
        }
    }

    public void error(String format, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        if (this.isErrorEnabled()) {
            this.getLogger().error((Object)String.format(format, o1, o2, o3, o4), t);
        }
    }

    public void error(String format, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        if (this.isErrorEnabled()) {
            this.getLogger().error((Object)String.format(format, o1, o2, o3, o4, o5), t);
        }
    }

    public void fatal(Object o) {
        this.getLogger().fatal(o);
    }

    public void fatal(Object o, Throwable t) {
        this.getLogger().fatal(o, t);
    }

    public void fatal(String format, Object ... objects) {
        if (this.isFatalEnabled()) {
            this.getLogger().fatal((Object)String.format(format, objects));
        }
    }

    public void fatal(String format, Object o, Throwable t) {
        if (this.isFatalEnabled()) {
            this.getLogger().fatal((Object)String.format(format, o), t);
        }
    }

    public void fatal(String format, Object o1, Object o2, Throwable t) {
        if (this.isFatalEnabled()) {
            this.getLogger().fatal((Object)String.format(format, o1, o2), t);
        }
    }

    public void fatal(String format, Object o1, Object o2, Object o3, Throwable t) {
        if (this.isFatalEnabled()) {
            this.getLogger().fatal((Object)String.format(format, o1, o2, o3), t);
        }
    }

    public void fatal(String format, Object o1, Object o2, Object o3, Object o4, Throwable t) {
        if (this.isFatalEnabled()) {
            this.getLogger().fatal((Object)String.format(format, o1, o2, o3, o4), t);
        }
    }

    public void fatal(String format, Object o1, Object o2, Object o3, Object o4, Object o5, Throwable t) {
        if (this.isFatalEnabled()) {
            this.getLogger().fatal((Object)String.format(format, o1, o2, o3, o4, o5), t);
        }
    }

    public void setLevel(Level level) {
        this.mLogger.setLevel(ZIMBRA_TO_LOG4J.get((Object)level));
    }

    public String getCategory() {
        return this.mLogger.getName();
    }

    List<AccountLogger> getAccountLoggers() {
        if (this.mAccountLoggers == null) {
            return null;
        }
        ArrayList<AccountLogger> accountLoggers = new ArrayList<AccountLogger>();
        for (String accountName : this.mAccountLoggers.keySet()) {
            Logger log4jLogger = this.mAccountLoggers.get(accountName);
            AccountLogger al = new AccountLogger(this.mLogger.getName(), accountName, LOG4J_TO_ZIMBRA.get(log4jLogger.getLevel()));
            accountLoggers.add(al);
        }
        return accountLoggers;
    }

    private Logger getLogger() {
        if (this.mAccountLoggers.size() == 0) {
            return this.mLogger;
        }
        for (String accountName : ZimbraLog.getAccountNamesFromContext()) {
            Logger logger = this.mAccountLoggers.get(accountName);
            if (logger == null) continue;
            return logger;
        }
        return this.mLogger;
    }

    static {
        ZIMBRA_TO_LOG4J.put(Level.error, org.apache.log4j.Level.ERROR);
        ZIMBRA_TO_LOG4J.put(Level.warn, org.apache.log4j.Level.WARN);
        ZIMBRA_TO_LOG4J.put(Level.info, org.apache.log4j.Level.INFO);
        ZIMBRA_TO_LOG4J.put(Level.debug, org.apache.log4j.Level.DEBUG);
        LOG4J_TO_ZIMBRA.put(org.apache.log4j.Level.FATAL, Level.error);
        LOG4J_TO_ZIMBRA.put(org.apache.log4j.Level.ERROR, Level.error);
        LOG4J_TO_ZIMBRA.put(org.apache.log4j.Level.WARN, Level.warn);
        LOG4J_TO_ZIMBRA.put(org.apache.log4j.Level.INFO, Level.info);
        LOG4J_TO_ZIMBRA.put(org.apache.log4j.Level.DEBUG, Level.debug);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        error,
        warn,
        info,
        debug;

    }
}

