/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListUtil {
    public static boolean isEmpty(List l) {
        return l == null || l.size() == 0;
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.size() == 0;
    }

    public static <T> boolean listsEqual(List<T> lhs, List<T> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        HashSet<T> set = new HashSet<T>();
        set.addAll(lhs);
        for (T t : rhs) {
            if (set.remove(t)) continue;
            return false;
        }
        return set.size() == 0;
    }

    public static <T extends Comparable<? super T>> void mergeSortedLists(List<T> dest, List<T>[] src, boolean removeDuplicates) {
        int i;
        int i2;
        int numSrc = 0;
        for (i2 = 0; i2 < src.length; ++i2) {
            if (src[i2] == null) continue;
            ++numSrc;
        }
        if (numSrc == 1) {
            for (i2 = 0; i2 < src.length; ++i2) {
                if (src[i2] == null) continue;
                dest.addAll(src[i2]);
                return;
            }
        }
        Iterator[] iter = new Iterator[numSrc];
        int iterOffset = 0;
        for (int i3 = 0; i3 < src.length; ++i3) {
            if (src[i3] == null) continue;
            iter[iterOffset++] = src[i3].iterator();
        }
        int numItersActive = src.length;
        Comparable[] nextValue = new Comparable[src.length];
        Comparable lowestValue = null;
        int lowestValueOffset = -1;
        Object lastAdded = null;
        for (i = 0; i < iter.length; ++i) {
            if (iter[i].hasNext()) {
                nextValue[i] = (Comparable)iter[i].next();
                if (lowestValue != null && lowestValue.compareTo(nextValue[i]) <= 0) continue;
                lowestValue = nextValue[i];
                lowestValueOffset = i;
                continue;
            }
            iter[i] = null;
            --numItersActive;
        }
        while (numItersActive > 0) {
            if (!removeDuplicates || lastAdded == null) {
                dest.add(nextValue[lowestValueOffset]);
                lastAdded = nextValue[lowestValueOffset];
                nextValue[lowestValueOffset] = null;
            } else {
                if (!lastAdded.equals(nextValue[lowestValueOffset])) {
                    dest.add(nextValue[lowestValueOffset]);
                    lastAdded = nextValue[lowestValueOffset];
                }
                nextValue[lowestValueOffset] = null;
            }
            if (iter[lowestValueOffset].hasNext()) {
                nextValue[lowestValueOffset] = (Comparable)iter[lowestValueOffset].next();
            } else {
                iter[lowestValueOffset] = null;
                --numItersActive;
            }
            lowestValue = null;
            lowestValueOffset = -1;
            for (i = 0; i < src.length; ++i) {
                if (lowestValue != null && (nextValue[i] == null || lowestValue.compareTo(nextValue[i]) <= 0)) continue;
                lowestValue = nextValue[i];
                lowestValueOffset = i;
            }
        }
    }

    public static <T> List<T> subtractSortedLists(List<T> a, List<T> b, Comparator<T> comparator) {
        ArrayList<Object> result = new ArrayList<Object>(a.size());
        Iterator<T> aIter = a.iterator();
        Iterator<T> bIter = b.iterator();
        Object aVal = null;
        if (aIter.hasNext()) {
            aVal = aIter.next();
        }
        Object bVal = null;
        if (bIter.hasNext()) {
            bVal = bIter.next();
        }
        while (aVal != null) {
            if (bVal == null) {
                result.add(aVal);
            } else {
                int comp = comparator.compare(aVal, bVal);
                if (comp < 0) {
                    result.add(aVal);
                } else if (comp > 0) {
                    if (bIter.hasNext()) {
                        bVal = bIter.next();
                        continue;
                    }
                    bVal = null;
                    continue;
                }
            }
            if (aIter.hasNext()) {
                aVal = aIter.next();
                continue;
            }
            aVal = null;
        }
        return result;
    }

    public static <E> List<List<E>> split(Collection<E> c, int listSize) {
        if (c == null) {
            return null;
        }
        ArrayList splitLists = new ArrayList();
        if (c.size() == 0) {
            return splitLists;
        }
        ArrayList<E> curList = new ArrayList<E>(listSize);
        int i = 0;
        for (E item : c) {
            if (i == listSize) {
                splitLists.add(curList);
                curList = new ArrayList(listSize);
                i = 0;
            }
            curList.add(item);
            ++i;
        }
        splitLists.add(curList);
        return splitLists;
    }

    public static void main(String[] args) {
        Test.doit();
    }

    private static class Test {
        private Test() {
        }

        private static void doit() {
            List[] in = new List[5];
            int i = 0;
            in[i] = new ArrayList();
            in[i].add(new Integer(1));
            in[i].add(new Integer(3));
            in[i].add(new Integer(5));
            in[i].add(new Integer(7));
            in[i].add(new Integer(9));
            i = 1;
            in[i] = new ArrayList();
            in[i].add(new Integer(1));
            in[i].add(new Integer(7));
            in[i].add(new Integer(12));
            in[i].add(new Integer(13));
            in[i].add(new Integer(13));
            i = 2;
            in[i] = new ArrayList();
            in[i].add(new Integer(1));
            in[i].add(new Integer(2));
            in[i].add(new Integer(3));
            in[i].add(new Integer(4));
            in[i].add(new Integer(5));
            i = 3;
            in[i] = new ArrayList();
            in[i].add(new Integer(5));
            in[i].add(new Integer(6));
            in[i].add(new Integer(7));
            in[i].add(new Integer(8));
            in[i].add(new Integer(9));
            i = 4;
            in[i] = new ArrayList();
            in[i].add(new Integer(100));
            in[i].add(new Integer(101));
            in[i].add(new Integer(102));
            in[i].add(new Integer(103));
            in[i].add(new Integer(104));
            List<Object> test = new ArrayList();
            ListUtil.mergeSortedLists(test, in, false);
            System.out.print("DUPES_NOT_REMOVED: ");
            for (Integer n : test) {
                System.out.print(n + ", ");
            }
            System.out.println();
            test = new ArrayList();
            ListUtil.mergeSortedLists(test, in, true);
            System.out.print("DUPES_REMOVED: ");
            for (Integer n : test) {
                System.out.print(n + ", ");
            }
            System.out.println();
            test = ListUtil.subtractSortedLists(in[2], in[0], new IntegerComparator());
            System.out.print("(1,2,3,4,5) - (1,3,5,7,9): ");
            for (Integer n : test) {
                System.out.print(n + ", ");
            }
            System.out.println();
            test = ListUtil.subtractSortedLists(in[0], in[1], new IntegerComparator());
            System.out.print("(1,3,5,7,9) - (1,7,12,13,13): ");
            for (Integer n : test) {
                System.out.print(n + ", ");
            }
            System.out.println();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class IntegerComparator
        implements Comparator<Integer> {
            private IntegerComparator() {
            }

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        }
    }
}

