/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.SetUtil;
import com.zimbra.common.util.ZimbraLog;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class L10nUtil {
    public static final String MSG_FILE_BASENAME = "ZsMsg";
    public static final String L10N_MSG_FILE_BASENAME = "L10nMsg";
    public static final String P_LOCALE_ID = "loc";
    private static ClassLoader sMsgClassLoader;
    private static Map<String, Locale> sLocaleMap;

    public static ClassLoader getMsgClassLoader() {
        return sMsgClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader getClassLoader(String directory) {
        URLClassLoader classLoader = null;
        try {
            File msgsDir = new File(directory);
            URL[] urls = new URL[]{msgsDir.toURL()};
            classLoader = new URLClassLoader(urls);
        }
        catch (MalformedURLException e) {
            try {
                ZimbraLog.system.fatal((Object)"Unable to initialize localization", e);
            }
            finally {
                Runtime.getRuntime().halt(1);
            }
        }
        return classLoader;
    }

    public static String getMessage(MsgKey key, Object ... args) {
        return L10nUtil.getMessage(key.toString(), (Locale)null, args);
    }

    public static String getMessage(String key, Object ... args) {
        return L10nUtil.getMessage(key, (Locale)null, args);
    }

    public static String getMessage(MsgKey key, HttpServletRequest request, Object ... args) {
        return L10nUtil.getMessage(key.toString(), request, args);
    }

    public static String getMessage(String key, HttpServletRequest request, Object ... args) {
        Locale locale = null;
        if (request != null) {
            locale = L10nUtil.lookupLocale(request.getParameter(P_LOCALE_ID));
        }
        if (locale == null && request != null) {
            locale = request.getLocale();
        }
        return L10nUtil.getMessage(key, locale, args);
    }

    public static String getMessage(MsgKey key, Locale lc, Object ... args) {
        return L10nUtil.getMessage(key.toString(), lc, args);
    }

    public static String getMessage(String key, Locale lc, Object ... args) {
        return L10nUtil.getMessage(MSG_FILE_BASENAME, key, lc, args);
    }

    public static String getMessage(String basename, String key, Locale lc, Object ... args) {
        try {
            ResourceBundle rb;
            String fmt;
            if (lc == null) {
                lc = Locale.getDefault();
            }
            if ((fmt = (rb = ResourceBundle.getBundle(basename, lc, sMsgClassLoader)).getString(key)) != null && args != null && args.length > 0) {
                return MessageFormat.format(fmt, args);
            }
            return fmt;
        }
        catch (MissingResourceException e) {
            ZimbraLog.misc.error((Object)("no resource bundle for base name " + basename + " can be found, " + "(locale=" + key + ")"), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale lookupLocale(String name) {
        Locale lc = null;
        if (name != null) {
            Map<String, Locale> map = sLocaleMap;
            synchronized (map) {
                lc = sLocaleMap.get(name);
                if (lc == null) {
                    String[] parts;
                    String[] stringArray = parts = name.indexOf(95) != -1 ? name.split("_") : name.split("-");
                    if (parts.length == 1) {
                        lc = new Locale(parts[0]);
                    } else if (parts.length == 2) {
                        lc = new Locale(parts[0], parts[1]);
                    } else if (parts.length >= 3) {
                        lc = new Locale(parts[0], parts[1], parts[2]);
                    }
                    if (lc != null) {
                        sLocaleMap.put(name, lc);
                    }
                }
            }
        }
        return lc;
    }

    public static Locale[] getAllLocalesSorted() {
        Locale[] locales = Locale.getAvailableLocales();
        Arrays.sort(locales, new LocaleComparatorByDisplayName(Locale.US));
        return locales;
    }

    public static Locale[] getLocalesSorted(Locale inLocale) {
        return LocalizedClientLocales.getLocales(inLocale);
    }

    public static void flushLocaleCache() {
        if (ZimbraLog.misc.isDebugEnabled()) {
            ZimbraLog.misc.debug("L10nUtil: flushing locale cache");
        }
        LocalizedClientLocales.flushCache();
    }

    static {
        String msgsDir = LC.localized_msgs_directory.value();
        sMsgClassLoader = L10nUtil.getClassLoader(msgsDir);
        Locale[] locales = Locale.getAvailableLocales();
        sLocaleMap = new HashMap<String, Locale>(locales.length);
        for (Locale lc : locales) {
            sLocaleMap.put(lc.toString(), lc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalizedClientLocales {
        static Set<Locale> sLocalizedLocales = null;
        static Map<Locale, Locale[]> sLocalizedLocalesSorted = null;

        private LocalizedClientLocales() {
        }

        private static void loadBundlesByJavaLocal(Set<Locale> locales, String msgsDir) {
            Locale[] allLocales;
            ClassLoader classLoader = L10nUtil.getClassLoader(msgsDir);
            block2: for (Locale locale : allLocales = Locale.getAvailableLocales()) {
                for (ClientResource clientRes : ClientResource.values()) {
                    try {
                        ResourceBundle rb = ResourceBundle.getBundle(clientRes.name(), locale, classLoader);
                        Locale rbLocale = rb.getLocale();
                        if (!rbLocale.equals(locale)) continue;
                        ZimbraLog.misc.info("Adding locale " + locale.toString());
                        locales.add(locale);
                        continue block2;
                    }
                    catch (MissingResourceException e) {
                        // empty catch block
                    }
                }
            }
        }

        private static void loadBundlesByDiskScan(Set<Locale> locales, String msgsDir) {
            File dir = new File(msgsDir);
            if (!dir.exists()) {
                ZimbraLog.misc.info("message directory does not exist:" + msgsDir);
                return;
            }
            if (!dir.isDirectory()) {
                ZimbraLog.misc.info("message directory is not a directory:" + msgsDir);
                return;
            }
            for (File file : dir.listFiles()) {
                String fileName = file.getName();
                ZimbraLog.misc.debug("loadBundlesByDiskScan processing file: " + fileName);
                String[] parts = fileName.split("\\.");
                if (parts.length < 2 || !parts[parts.length - 1].equals("properties")) continue;
                ZimbraLog.misc.debug("    found property file:" + fileName);
                String[] localeParts = parts[0].split("_");
                if (localeParts.length < 2) continue;
                ClientResource resource = null;
                try {
                    resource = ClientResource.valueOf(localeParts[0]);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (resource == null) continue;
                ZimbraLog.misc.debug("        found resource file: " + fileName);
                Locale locale = null;
                if (localeParts.length == 2) {
                    locale = new Locale(localeParts[1]);
                    ZimbraLog.misc.debug("        found locale: " + localeParts[1]);
                } else if (localeParts.length == 3) {
                    locale = new Locale(localeParts[1], localeParts[2]);
                    ZimbraLog.misc.debug("        found locale: " + localeParts[1] + " " + localeParts[2]);
                } else if (localeParts.length == 4) {
                    locale = new Locale(localeParts[1], localeParts[2], localeParts[3]);
                    ZimbraLog.misc.debug("        found locale: " + localeParts[1] + " " + localeParts[2] + " " + localeParts[3]);
                }
                if (locale == null || locales.contains(locale)) continue;
                ZimbraLog.misc.info("Adding locale " + locale.toString());
                locales.add(locale);
            }
        }

        private static void loadBundles() {
            sLocalizedLocales = new HashSet<Locale>();
            String msgsDir = LC.localized_client_msgs_directory.value();
            ZimbraLog.misc.info("Scanning installed locales from " + msgsDir);
            ZimbraLog.misc.info("Adding locale " + Locale.US.toString() + " (always added)");
            sLocalizedLocales.add(Locale.US);
            LocalizedClientLocales.loadBundlesByDiskScan(sLocalizedLocales, msgsDir);
            HashSet<Locale> pseudoLocales = new HashSet<Locale>();
            for (Locale lc : sLocalizedLocales) {
                String language = lc.getLanguage();
                Locale lcLang = new Locale(language);
                if (sLocalizedLocales.contains(lcLang) || pseudoLocales.contains(lcLang)) continue;
                ZimbraLog.misc.info("Adding locale " + lcLang.toString() + " (pseudo)");
                pseudoLocales.add(lcLang);
            }
            if (pseudoLocales.size() > 0) {
                sLocalizedLocales = SetUtil.union(sLocalizedLocales, pseudoLocales);
            }
        }

        public static synchronized Locale[] getLocales(Locale inLocale) {
            if (sLocalizedLocales == null) {
                LocalizedClientLocales.loadBundles();
            }
            Locale[] sortedLocales = null;
            if (sLocalizedLocalesSorted == null) {
                sLocalizedLocalesSorted = new HashMap<Locale, Locale[]>();
            } else {
                sortedLocales = sLocalizedLocalesSorted.get(inLocale);
            }
            if (sortedLocales == null) {
                sortedLocales = sLocalizedLocales.toArray(new Locale[sLocalizedLocales.size()]);
                Arrays.sort(sortedLocales, new LocaleComparatorByDisplayName(inLocale));
                sLocalizedLocalesSorted.put(inLocale, sortedLocales);
            }
            return sortedLocales;
        }

        public static synchronized void flushCache() {
            sLocalizedLocales = null;
            sLocalizedLocalesSorted = null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum ClientResource {
            AjxMsg,
            ZMsg,
            ZaMsg,
            ZhMsg,
            ZmMsg;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleComparatorByDisplayName
    implements Comparator<Locale> {
        private Locale mInLocale;

        LocaleComparatorByDisplayName(Locale inLocale) {
            this.mInLocale = inLocale;
        }

        @Override
        public int compare(Locale a, Locale b) {
            String da = a.getDisplayName(this.mInLocale);
            String db = b.getDisplayName(this.mInLocale);
            return da.compareTo(db);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MsgKey {
        calendarSubjectCancelled,
        calendarSubjectWithheld,
        calendarCancelRemovedFromAttendeeList,
        calendarCancelAppointment,
        calendarCancelAppointmentInstance,
        calendarCancelAppointmentInstanceWhich,
        calendarReplySubjectAccept,
        calendarReplySubjectTentative,
        calendarReplySubjectDecline,
        calendarDefaultReplyAccept,
        calendarDefaultReplyTentativelyAccept,
        calendarDefaultReplyDecline,
        calendarDefaultReplyOther,
        calendarResourceDefaultReplyAccept,
        calendarResourceDefaultReplyPartiallyAccept,
        calendarResourceDefaultReplyPartiallyDecline,
        calendarResourceDefaultReplyTentativelyAccept,
        calendarResourceDefaultReplyDecline,
        calendarResourceDefaultReplyPermissionDenied,
        calendarResourceReplyOriginalInviteSeparatorLabel,
        calendarResourceConflictDateTimeFormat,
        calendarResourceConflictTimeOnlyFormat,
        calendarResourceConflictDateOnlyFormat,
        calendarResourceDeclinedInstances,
        calendarResourceDeclineReasonRecurring,
        calendarResourceDeclineReasonConflict,
        calendarResourceConflictScheduledBy,
        calendarUserReplyPermissionDenied,
        caldavCalendarDescription,
        carddavAddressbookDescription,
        shareNotifSubject,
        shareNotifBodyIntro,
        shareNotifBodyAddedToGroup1,
        shareNotifBodyAddedToGroup2,
        shareNotifBodyGranteeRoleViewer,
        shareNotifBodyGranteeRoleManager,
        shareNotifBodyGranteeRoleAdmin,
        shareNotifBodySharedItem,
        shareNotifBodyFolderDesc,
        shareNotifBodyOwner,
        shareNotifBodyGrantee,
        shareNotifBodyRole,
        shareNotifBodyAllowedActions,
        shareNotifBodyNotes,
        shareNotifBodyActionRead,
        shareNotifBodyActionWrite,
        shareNotifBodyActionInsert,
        shareNotifBodyActionDelete,
        shareNotifBodyActionAction,
        shareNotifBodyActionAdmin,
        shareNotifBodyActionPrivate,
        shareNotifBodyActionFreebusy,
        shareNotifBodyActionSubfolder,
        readReceiptNotification,
        zsApptNew,
        zsApptModified,
        zsApptInstanceModified,
        zsSubject,
        zsOrganizer,
        zsLocation,
        zsTime,
        zsStart,
        zsEnd,
        zsAllDay,
        zsRecurrence,
        zsInvitees,
        zsRecurDailyEveryDay,
        zsRecurDailyEveryWeekday,
        zsRecurDailyEveryNumDays,
        zsRecurWeeklyEveryWeekday,
        zsRecurWeeklyEveryNumWeeksDate,
        zsRecurMonthlyEveryNumMonthsDate,
        zsRecurMonthlyEveryNumMonthsNumDay,
        zsRecurYearlyEveryDate,
        zsRecurYearlyEveryMonthNumDay,
        zsRecurStart,
        zsRecurEndNone,
        zsRecurEndNumber,
        zsRecurEndByDate,
        zsRecurBlurb,
        wikiTOC,
        wikiActions,
        wikiDocName,
        wikiModifiedBy,
        wikiModifiedOn,
        wikiVersion,
        wikiPageHistory,
        wikiBy,
        Notebook,
        errAttachmentDownloadDisabled,
        errInvalidId,
        errInvalidImapId,
        errInvalidPath,
        errInvalidRequest,
        errMailboxNotFound,
        errMessageNotFound,
        errMissingUploadId,
        errMustAuthenticate,
        errNoSuchAccount,
        errNoSuchItem,
        errNoSuchUpload,
        errNotImplemented,
        errPartNotFound,
        errPermissionDenied,
        errUnsupportedFormat;

    }
}

