/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    public static Browser guessBrowser(HttpServletRequest req) {
        String ua = req.getHeader("User-Agent");
        return HttpUtil.guessBrowser(ua);
    }

    public static Browser guessBrowser(String ua) {
        if (ua == null || ua.trim().equals("")) {
            return Browser.UNKNOWN;
        }
        if (ua.indexOf("MSIE") != -1) {
            return Browser.IE;
        }
        if (ua.indexOf("Firefox") != -1) {
            return Browser.FIREFOX;
        }
        if (ua.indexOf("AppleWebKit") != -1) {
            return Browser.SAFARI;
        }
        if (ua.indexOf("Opera") != -1) {
            return Browser.OPERA;
        }
        if (ua.indexOf("iCal") != -1) {
            return Browser.APPLE_ICAL;
        }
        return Browser.UNKNOWN;
    }

    public static String encodeFilename(HttpServletRequest req, String filename) {
        if (StringUtil.isAsciiString(filename) && filename.indexOf(34) == -1) {
            return '\"' + filename.replace('\t', ' ') + '\"';
        }
        return HttpUtil.encodeFilename(HttpUtil.guessBrowser(req), filename);
    }

    public static String encodeFilename(Browser browser, String filename) {
        if (StringUtil.isAsciiString(filename = filename.replace('\t', ' ')) && filename.indexOf(34) == -1) {
            return '\"' + filename + '\"';
        }
        try {
            if (browser == Browser.IE) {
                return URLEncoder.encode(filename, "utf-8");
            }
            if (browser == Browser.FIREFOX) {
                return '\"' + MimeUtility.encodeText((String)filename, (String)"utf-8", (String)"B") + '\"';
            }
            return '\"' + MimeUtility.encodeText((String)filename, (String)"utf-8", (String)"B") + '\"';
        }
        catch (UnsupportedEncodingException uee) {
            return filename;
        }
    }

    public static String sanitizeURL(String url) {
        if (url != null && url.indexOf(64) != -1) {
            try {
                HttpURL httpurl = new HttpURL(url);
                if (httpurl.getPassword() != null) {
                    httpurl.setPassword("");
                    return httpurl.toString();
                }
            }
            catch (URIException uRIException) {
                // empty catch block
            }
        }
        return url;
    }

    public static String getFullRequestURL(HttpServletRequest req) {
        if (req == null) {
            return null;
        }
        String uri = HttpUtil.encodePath(req.getRequestURI());
        String qs = req.getQueryString();
        if (qs != null) {
            uri = uri + '?' + qs;
        }
        return uri;
    }

    public static Map<String, String> getURIParams(HttpServletRequest req) {
        return HttpUtil.getURIParams(req.getQueryString());
    }

    public static Map<String, String> getURIParams(String queryString) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (queryString == null || queryString.trim().equals("")) {
            return params;
        }
        for (String pair : queryString.split("&")) {
            String[] keyVal = pair.split("=");
            try {
                String value = keyVal.length > 1 ? URLDecoder.decode(keyVal[1], "utf-8") : "";
                params.put(URLDecoder.decode(keyVal[0], "utf-8"), value);
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        return params;
    }

    public static String encodePath(String path) {
        String encoded = path;
        try {
            URI uri = new URI(null, null, path, null);
            encoded = uri.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return encoded;
    }

    public static String getVirtualHost(HttpServletRequest req) {
        String virtualHost = req.getHeader("X-Forwarded-Host");
        if (virtualHost != null) {
            return virtualHost;
        }
        return req.getServerName();
    }

    public static void main(String[] args) {
        System.out.println(HttpUtil.getURIParams((String)null));
        System.out.println(HttpUtil.getURIParams("foo=bar"));
        System.out.println(HttpUtil.getURIParams("foo=bar&baz&ben=wak"));
        System.out.println(HttpUtil.getURIParams("foo=bar&%45t%4E=%33%20%6eford"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Browser {
        IE,
        FIREFOX,
        MOZILLA,
        OPERA,
        SAFARI,
        APPLE_ICAL,
        UNKNOWN;

    }
}

