/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.HttpUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestLine {
    private String requestLine;
    private String method;
    private String httpVersion;
    private String uri;
    private Map<String, String> mUriParams = null;

    public HttpRequestLine(String requestLine) throws IOException {
        this.requestLine = requestLine;
        int sp1 = requestLine.indexOf(" ");
        if (sp1 < 0) {
            throw new IOException("unable to parse method in request-line");
        }
        this.method = requestLine.substring(0, sp1).toUpperCase();
        int sp2 = requestLine.indexOf(" ", sp1 + 1);
        if (sp2 < 0) {
            throw new IOException("unable to parse URI in request-line");
        }
        this.uri = requestLine.substring(sp1 + 1, sp2);
        if (sp2 + 1 >= requestLine.length()) {
            throw new IOException("unable to parse version in request-line");
        }
        this.httpVersion = requestLine.substring(sp2 + 1).trim().toUpperCase();
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getURI() {
        return this.uri;
    }

    public String getBaseURI() {
        int idx = this.uri.indexOf(63);
        String baseURI = idx >= 0 ? this.uri.substring(0, idx) : this.uri;
        try {
            return URLDecoder.decode(baseURI, "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            return baseURI;
        }
    }

    public Map<String, String> getUriParams() {
        if (this.mUriParams != null) {
            return this.mUriParams;
        }
        int idx = this.uri.indexOf(63);
        this.mUriParams = idx >= 0 && idx < this.uri.length() ? HttpUtil.getURIParams(this.uri.substring(idx + 1)) : new HashMap<String, String>();
        return this.mUriParams;
    }

    public String getMethod() {
        return this.method;
    }

    public String toString() {
        return this.requestLine;
    }
}

