/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.HttpRequestLine;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class HttpRequest {
    private static final String NL = "\r\n";
    private HttpRequestLine mHttpRequestLine;
    private HashMap mRequestHeaders = new LinkedHashMap();
    private boolean mReadBody = false;
    private byte[] mBody;
    private ByteArrayOutputStream mLineBuff = new ByteArrayOutputStream(128);
    private InputStream mInputStream;

    public HttpRequest(InputStream input) throws IOException, EOFException {
        this.mInputStream = input;
        this.readHttpRequestLine(input);
        this.readHttpHeaders(input);
    }

    public HttpRequestLine getRequestLine() {
        return this.mHttpRequestLine;
    }

    public Map getHeaders() {
        return this.mRequestHeaders;
    }

    public byte[] getContent() throws IOException {
        if (!this.mReadBody) {
            this.readBody();
        }
        return this.mBody;
    }

    public void readBody() throws IOException {
        this.mReadBody = true;
        if ("chunked".equals(this.mRequestHeaders.get("transfer-encoding"))) {
            this.mBody = this.readChunkedContent(this.mInputStream);
            this.readHttpHeaders(this.mInputStream);
        } else {
            String cl = (String)this.mRequestHeaders.get("content-length");
            if (cl == null) {
                this.mBody = this.readUntilEOF(this.mInputStream);
            } else {
                try {
                    int contentLength = Integer.parseInt(cl);
                    this.mBody = this.readFully(this.mInputStream, contentLength);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("can't parse Content-Length: " + cl);
                }
            }
        }
    }

    private byte[] readFully(InputStream input, int len) throws IOException {
        int count;
        byte[] bc = new byte[len];
        for (int n = 0; n < len; n += count) {
            count = input.read(bc, n, len - n);
            if (count >= 0) continue;
            throw new EOFException("can't read content");
        }
        return bc;
    }

    private byte[] readUntilEOF(InputStream input) throws IOException {
        int SIZE = 2048;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        byte[] buffer = new byte[2048];
        int n = 0;
        while ((n = input.read(buffer, 0, 2048)) > 0) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }

    private int readChunkSize(InputStream input) throws IOException {
        String line = this.readHttpLine(input);
        int sep = line.indexOf(59);
        line = sep > 0 ? line.substring(0, sep).trim() : line.trim();
        try {
            return Integer.parseInt(line, 16);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("can't parse chunk size: " + line);
        }
    }

    private byte[] readChunkedContent(InputStream input) throws IOException {
        int chunkSize;
        ByteArrayOutputStream baos = null;
        while ((chunkSize = this.readChunkSize(input)) > 0) {
            if (baos == null) {
                baos = new ByteArrayOutputStream(chunkSize);
            }
            baos.write(this.readFully(input, chunkSize));
            int CR = input.read();
            int LF = input.read();
            if (CR == 13 && LF == 10) continue;
            throw new IOException("can't parse CRLF after chunk");
        }
        return baos.toByteArray();
    }

    private void readHttpHeaders(InputStream input) throws IOException {
        String line;
        String name = null;
        StringBuffer value = new StringBuffer();
        while ((line = this.readHttpLine(input)) != null && line.length() != 0) {
            int i;
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                value.append(' ').append(line.trim());
                continue;
            }
            if (name != null) {
                this.mRequestHeaders.put(name, value.toString());
                value.setLength(0);
            }
            if ((i = line.indexOf(":")) < 0) {
                throw new IOException("unable to parse harder: " + line);
            }
            name = line.substring(0, i).toLowerCase();
            value.append(line.substring(i + 1).trim());
        }
        if (name != null) {
            this.mRequestHeaders.put(name, value.toString());
        }
    }

    private void readHttpRequestLine(InputStream input) throws IOException {
        String request = this.readHttpLine(input);
        if (request == null) {
            throw new EOFException("readHttpRequestLine");
        }
        this.mHttpRequestLine = new HttpRequestLine(request);
    }

    private String readHttpLine(InputStream input) throws IOException {
        int ch = -1;
        int prev_ch = -1;
        this.mLineBuff.reset();
        while ((ch = input.read()) >= 0 && ch != 10) {
            if (prev_ch == 13) {
                this.mLineBuff.write(prev_ch);
            }
            if (ch != 13) {
                this.mLineBuff.write(ch);
            }
            prev_ch = ch;
        }
        if (ch == -1) {
            return null;
        }
        return this.mLineBuff.toString("US-ASCII");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append(this.mHttpRequestLine);
        sb.append(NL);
        for (String name : this.mRequestHeaders.keySet()) {
            String value = (String)this.mRequestHeaders.get(name);
            sb.append(name).append(": ").append(value).append(NL);
        }
        sb.append(NL);
        if (this.mReadBody) {
            sb.append(new String(this.mBody));
        } else {
            sb.append("BODY NOT READ");
        }
        return sb.toString();
    }

    public class Constants {
        public static final String HTTP_HEADER_CHARSET = "US-ASCII";
        public static final String HTTP_VERSION = "HTTP/1.1";
    }
}

