/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.ZimbraLog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final int COPYBUFLEN = Math.max(LC.zimbra_store_copy_buffer_size_kb.intValue(), 1) * 1024;
    private static final long NIO_COPY_CHUNK_SIZE = Math.max(LC.zimbra_nio_file_copy_chunk_size_kb.longValue(), 1L) * 1024L;

    public static void copy(String src, String dest) throws IOException {
        FileUtil.copy(new File(src), new File(dest));
    }

    public static void copy(File from, File to) throws IOException {
        FileUtil.copy(from, to, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(File src, File dest, boolean sync) throws IOException {
        FileInputStream fin = null;
        DeflaterOutputStream fout = null;
        try {
            int byteRead;
            fin = new FileInputStream(src);
            FileOutputStream fos = new FileOutputStream(dest);
            fout = new GZIPOutputStream(fos);
            byte[] buf = new byte[COPYBUFLEN];
            while ((byteRead = fin.read(buf)) != -1) {
                ((GZIPOutputStream)fout).write(buf, 0, byteRead);
            }
            if (sync) {
                fos.getChannel().force(true);
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ioe) {
                    ZimbraLog.misc.warn((Object)("FileUtil.compress(" + src + "," + dest + "): ignoring exception while closing input channel"), ioe);
                }
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ioe) {
                    ZimbraLog.misc.warn((Object)("FileUtil.compress(" + src + "," + dest + "): ignoring exception while closing output channel"), ioe);
                }
            }
        }
    }

    public static void uncompress(File src, File dest, boolean sync) throws IOException {
        FileUtil.uncompress(new GZIPInputStream(new FileInputStream(src)), dest, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompress(InputStream in, File dest, boolean sync) throws IOException {
        FileOutputStream fout = null;
        try {
            int byteRead;
            fout = new FileOutputStream(dest);
            byte[] buf = new byte[COPYBUFLEN];
            while ((byteRead = in.read(buf)) != -1) {
                fout.write(buf, 0, byteRead);
            }
            if (sync) {
                fout.getChannel().force(true);
            }
        }
        finally {
            ByteUtil.closeStream(in);
            ByteUtil.closeStream(fout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGzipped(File file) throws IOException {
        boolean bl;
        BufferedInputStream in = null;
        try {
            FileInputStream fin = new FileInputStream(file);
            in = new BufferedInputStream(fin, 2);
            bl = ByteUtil.isGzipped(in);
        }
        catch (Throwable throwable) {
            ByteUtil.closeStream(in);
            throw throwable;
        }
        ByteUtil.closeStream(in);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to, boolean sync) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            long bytesCopied;
            fin = new FileInputStream(from);
            fout = new FileOutputStream(to);
            FileChannel cin = fin.getChannel();
            FileChannel cout = fout.getChannel();
            long length = cin.size();
            long offset = 0L;
            for (long bytesLeft = length; bytesLeft > 0L; bytesLeft -= bytesCopied) {
                long chunkSize = Math.min(NIO_COPY_CHUNK_SIZE, bytesLeft);
                bytesCopied = cin.transferTo(offset, chunkSize, cout);
                if (bytesCopied != chunkSize) {
                    throw new IOException("FileUtil.copy(" + from + "," + to + "): incomplete transfer; expected=" + chunkSize + " bytes, actual=" + bytesCopied + " bytes");
                }
                offset += bytesCopied;
            }
            if (sync) {
                cout.force(true);
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ioe) {
                    ZimbraLog.misc.warn((Object)("FileUtil.copy(" + from + "," + to + "): ignoring exception while closing input channel"), ioe);
                }
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ioe) {
                    ZimbraLog.misc.warn((Object)("FileUtil.copy(" + from + "," + to + "): ignoring exception while closing output channel"), ioe);
                }
            }
        }
    }

    public static void copyOIO(File src, File dest) throws IOException {
        FileUtil.copyOIO(src, dest, false);
    }

    public static void copyOIO(File src, File dest, boolean sync) throws IOException {
        byte[] buf = new byte[COPYBUFLEN];
        FileUtil.copyOIO(src, dest, buf, sync);
    }

    public static void copyOIO(File src, File dest, byte[] buf) throws IOException {
        FileUtil.copyOIO(src, dest, buf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyOIO(File src, File dest, byte[] buf, boolean sync) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int byteRead;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            while ((byteRead = fis.read(buf)) != -1) {
                fos.write(buf, 0, byteRead);
            }
            if (sync) {
                fos.getChannel().force(true);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, boolean closeIn, File dest) throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(dest);
            byte[] buf = new byte[COPYBUFLEN];
            try {
                int byteRead;
                while ((byteRead = in.read(buf)) != -1) {
                    fos.write(buf, 0, byteRead);
                }
            }
            finally {
                fos.close();
            }
        }
        finally {
            if (closeIn) {
                ByteUtil.closeStream(in);
            }
        }
    }

    public static int copyDirectory(File srcDir, File destDir) throws IOException {
        int filesCopied = 0;
        File[] files = srcDir.listFiles();
        if (files == null) {
            return 0;
        }
        FileUtil.ensureDirExists(destDir);
        for (File file : files) {
            if (!file.isFile()) continue;
            File dest = new File(destDir, file.getName());
            FileUtil.copyOIO(file, dest);
            ++filesCopied;
        }
        for (File file : files) {
            String name;
            if (!file.isDirectory() || (name = file.getName()) == "." || name == "..") continue;
            File subDestDir = new File(destDir, file.getName());
            filesCopied += FileUtil.copyDirectory(file, subDestDir);
        }
        return filesCopied;
    }

    public static List<File> listFilesRecursively(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtil.addFilesRecursively(dir, files);
        return files;
    }

    private static void addFilesRecursively(File dir, List<File> files) {
        File[] myFiles = dir.listFiles();
        if (myFiles == null || myFiles.length == 0) {
            return;
        }
        for (File file : myFiles) {
            if (file.isDirectory()) {
                FileUtil.addFilesRecursively(file, files);
                continue;
            }
            files.add(file);
        }
    }

    public static List<File> listDirsRecursively(File dir) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (dir.exists()) {
            FileUtil.addDirsRecursively(dir, dirs);
        }
        return dirs;
    }

    private static void addDirsRecursively(File dir, List<File> dirs) {
        File[] myFiles = dir.listFiles();
        if (myFiles != null) {
            for (File file : myFiles) {
                if (!file.isDirectory()) continue;
                FileUtil.addDirsRecursively(file, dirs);
            }
        }
        dirs.add(dir);
    }

    public static void ensureDirExists(File dir) throws IOException {
        if (!FileUtil.mkdirs(dir)) {
            throw new IOException("Unable to create directory " + dir.getPath());
        }
    }

    public static void ensureDirExists(String directory) throws IOException {
        File d = new File(directory);
        FileUtil.ensureDirExists(d);
    }

    public static String getTodayDir() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd");
        return fmt.format(new Date());
    }

    public static void sortFilesByModifiedTime(File[] files) {
        FileUtil.sortFilesByModifiedTime(files, false);
    }

    public static void sortFilesByModifiedTime(File[] files, boolean reverse) {
        MTimeComparator comp = new MTimeComparator(reverse);
        Arrays.sort(files, comp);
    }

    public static void deleteDir(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtil.deleteDir(files[i]);
                    continue;
                }
                if (files[i].delete()) continue;
                throw new IOException("Cannot remove " + files[i].getPath());
            }
        }
        if (directory.exists() && !directory.delete()) {
            throw new IOException("Cannot remove " + directory.getPath());
        }
    }

    public static boolean mkdirs(File path) {
        if (path.exists()) {
            return true;
        }
        if (path.mkdir() || path.exists()) {
            return true;
        }
        File canonFile = null;
        try {
            canonFile = path.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        String parent = canonFile.getParent();
        if (parent != null) {
            File pf = new File(parent);
            return FileUtil.mkdirs(pf) && (canonFile.mkdir() || canonFile.exists());
        }
        return false;
    }

    public static String trimFilename(String filename) {
        char[] delimiter = new char[]{'/', '\\', ':'};
        if (filename == null || filename.equals("")) {
            return null;
        }
        for (int i = 0; i < delimiter.length; ++i) {
            int index = filename.lastIndexOf(delimiter[i]);
            if (index == filename.length() - 1) {
                return null;
            }
            if (index == -1) continue;
            filename = filename.substring(index + 1);
        }
        return filename;
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int lastDot = filename.lastIndexOf(".");
        if (lastDot == -1) {
            return filename;
        }
        if (lastDot == filename.length() - 1) {
            return "";
        }
        return filename.substring(lastDot + 1, filename.length());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MTimeComparator
    implements Comparator<File> {
        private boolean mReverse;

        private MTimeComparator(boolean reverse) {
            this.mReverse = reverse;
        }

        @Override
        public int compare(File f1, File f2) {
            long diff;
            long l = diff = this.mReverse ? f2.lastModified() - f1.lastModified() : f1.lastModified() - f2.lastModified();
            if (diff < 0L) {
                return -1;
            }
            if (diff == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

