/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.ByteUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class FileSegmentDataSource
implements DataSource {
    private File mFile;
    private long mOffset;
    private long mLength;
    private String mContentType;

    public FileSegmentDataSource(File file, long offset, long length) {
        this.mFile = file;
        this.mOffset = offset;
        this.mLength = length;
    }

    public String getContentType() {
        if (this.mContentType == null) {
            return "application/octet-stream";
        }
        return this.mContentType;
    }

    public InputStream getInputStream() throws IOException {
        InputStream in = new FileInputStream(this.mFile);
        if (this.mOffset > 0L || this.mLength != this.mFile.length()) {
            in = ByteUtil.SegmentInputStream.create(in, this.mOffset, this.mOffset + this.mLength);
        }
        return in;
    }

    public String getName() {
        return this.mFile.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("not supported");
    }
}

