/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FileBufferedWriter
extends Writer {
    public static final int MAX_BUFFER_SIZE = 0xA00000;
    private static final String CHARSET = "utf-8";
    private Writer mOut;
    private int mBufSizeBytes;
    private char[] mMemBuffer;
    private int mMemBufferOffset;
    private File mTempFile;
    private OutputStreamWriter mWriter;
    private boolean mFinished;

    public FileBufferedWriter(Writer out, int maxMemSize) {
        this.mOut = out;
        this.mBufSizeBytes = Math.max(Math.min(maxMemSize, 0xA00000), 0);
        this.mMemBuffer = new char[this.mBufSizeBytes / 2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.mOut.close();
        }
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        int fileCharsToWrite;
        int remainingMemCapacity = this.mMemBuffer.length - this.mMemBufferOffset;
        int memCharsToWrite = Math.min(len, remainingMemCapacity);
        if (memCharsToWrite > 0) {
            System.arraycopy(cbuf, off, this.mMemBuffer, this.mMemBufferOffset, memCharsToWrite);
            this.mMemBufferOffset += memCharsToWrite;
        }
        if ((fileCharsToWrite = len - memCharsToWrite) > 0) {
            if (this.mWriter == null) {
                this.mTempFile = File.createTempFile("FileBufferedWriter", ".buf");
                boolean success = false;
                try {
                    this.mWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.mTempFile), CHARSET);
                    success = true;
                }
                finally {
                    if (!success) {
                        this.mTempFile.delete();
                        this.mTempFile = null;
                    }
                }
            }
            this.mWriter.write(cbuf, off + memCharsToWrite, fileCharsToWrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        block15: {
            if (!this.mFinished) {
                this.mFinished = true;
                try {
                    boolean hasFile;
                    boolean bl = hasFile = this.mWriter != null;
                    if (hasFile) {
                        try {
                            this.mWriter.close();
                        }
                        finally {
                            this.mWriter = null;
                        }
                    }
                    if (this.mMemBufferOffset > 0) {
                        this.mOut.write(this.mMemBuffer, 0, this.mMemBufferOffset);
                    }
                    if (!hasFile) break block15;
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.mTempFile), CHARSET);
                    try {
                        int charsRead;
                        while ((charsRead = reader.read(this.mMemBuffer, 0, this.mMemBuffer.length)) != -1) {
                            this.mOut.write(this.mMemBuffer, 0, charsRead);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    if (this.mTempFile != null) {
                        this.mTempFile.delete();
                        this.mTempFile = null;
                    }
                    this.mMemBuffer = null;
                }
            }
        }
    }
}

