/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmailUtil {
    private static final String DOMAIN_PATTERN = "[-a-zA-Z0-9\\.]+";
    private static final Pattern DOMAIN_REGEX = Pattern.compile("[-a-zA-Z0-9\\.]+");

    public static String[] getLocalPartAndDomain(String address) {
        if (address == null) {
            return null;
        }
        int at = address.indexOf(64);
        if (at == -1) {
            return null;
        }
        String localPart = address.substring(0, at);
        if (localPart.length() == 0) {
            return null;
        }
        String domain = address.substring(at + 1, address.length());
        if (domain.length() == 0) {
            return null;
        }
        return new String[]{localPart, domain};
    }

    public static String getValidDomainPart(String address) {
        String[] parts = EmailUtil.getLocalPartAndDomain(address);
        if (parts == null) {
            return null;
        }
        String domain = parts[1];
        if (EmailUtil.validDomain(domain)) {
            return domain;
        }
        return null;
    }

    public static boolean validDomain(String domain) {
        int len = domain.length();
        Matcher matcher = DOMAIN_REGEX.matcher(domain);
        return len > 0 && domain.charAt(0) != '.' && domain.charAt(len - 1) != '.' && matcher.matches() && domain.indexOf("..") == -1;
    }

    public static boolean isRfc822Message(InputStream in) throws IOException {
        in.mark(998);
        boolean gotHeaderName = false;
        for (int i = 1; i <= 998; ++i) {
            int c = in.read();
            if (c < 33 || c > 126) {
                in.reset();
                return false;
            }
            if (c == 58) {
                in.reset();
                return gotHeaderName;
            }
            gotHeaderName = true;
        }
        in.reset();
        return false;
    }
}

