/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Log LOG = LogFactory.getLog(EasyX509TrustManager.class);

    public EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance((String)"SunX509");
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public boolean isClientTrusted(X509Certificate[] certificates) {
        return this.standardTrustManager.isClientTrusted(certificates);
    }

    public boolean isServerTrusted(X509Certificate[] certificates) {
        int i;
        if (certificates != null && LOG.isDebugEnabled()) {
            LOG.debug("Server certificate chain:");
            for (i = 0; i < certificates.length; ++i) {
                LOG.debug("X509Certificate[" + i + "]=" + certificates[i]);
            }
        }
        if (certificates != null && certificates.length > 0) {
            try {
                certificates[0].checkValidity();
                LOG.debug("X509Certificate[0] valid");
                for (i = 1; i < certificates.length; ++i) {
                    certificates[i].checkValidity();
                    LOG.debug("X509Certificate[" + i + "] valid");
                    try {
                        certificates[i - 1].verify(certificates[i].getPublicKey());
                        LOG.debug("X509Certificate[" + (i - 1) + "] trusted by X509Certificate[" + i + "]");
                        continue;
                    }
                    catch (NoSuchAlgorithmException x) {
                        throw new CertificateException(x.toString());
                    }
                    catch (NoSuchProviderException x) {
                        throw new CertificateException(x.toString());
                    }
                    catch (InvalidKeyException x) {
                        throw new CertificateException(x.toString());
                    }
                    catch (SignatureException x) {
                        throw new CertificateException(x.toString());
                    }
                }
            }
            catch (CertificateException x) {
                LOG.error(x.toString());
                return false;
            }
            return true;
        }
        return this.standardTrustManager.isServerTrusted(certificates);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

