/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.BufferStream;
import com.zimbra.common.util.ByteUtil;
import java.security.MessageDigest;

public class DigestStream
extends BufferStream {
    private MessageDigest messageDigest;

    public DigestStream() {
        this(0L);
    }

    public DigestStream(long sizeHint) {
        this(sizeHint, Integer.MAX_VALUE);
    }

    public DigestStream(long sizeHint, int maxBuffer) {
        this(sizeHint, maxBuffer, Long.MAX_VALUE);
    }

    public DigestStream(long sizeHint, int maxBuffer, long maxSize) {
        super(sizeHint, maxBuffer, maxSize);
        try {
            this.messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize " + DigestStream.class.getSimpleName(), e);
        }
    }

    public String getDigest() {
        return ByteUtil.encodeFSSafeBase64(this.messageDigest.digest());
    }

    public void write(int data) {
        super.write(data);
        this.messageDigest.update((byte)data);
    }

    public void write(byte[] data, int off, int len) {
        super.write(data, off, len);
        this.messageDigest.update(data, off, len);
    }
}

