/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class DefaultTrustManager
implements X509TrustManager {
    X509TrustManager keyStoreTrustManager;
    private static DefaultTrustManager instance;

    protected DefaultTrustManager() throws GeneralSecurityException {
        TrustManager[] trustManagers;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream kin = null;
        try {
            kin = new FileInputStream(LC.mailboxd_truststore.value());
            try {
                keyStore.load(kin, LC.mailboxd_truststore_password.value().toCharArray());
            }
            catch (IOException x) {
                throw new KeyStoreException(x);
            }
        }
        catch (FileNotFoundException x) {
            throw new KeyStoreException(x);
        }
        finally {
            if (kin != null) {
                try {
                    ((InputStream)kin).close();
                }
                catch (IOException x) {
                    throw new KeyStoreException(x);
                }
            }
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        for (TrustManager tm : trustManagers = factory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this.keyStoreTrustManager = (X509TrustManager)tm;
            return;
        }
        throw new KeyStoreException(TrustManagerFactory.getDefaultAlgorithm() + " trust manager not supported");
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.keyStoreTrustManager.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.keyStoreTrustManager.checkServerTrusted(chain, authType);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.keyStoreTrustManager.getAcceptedIssuers();
    }

    public static synchronized DefaultTrustManager getInstance() throws GeneralSecurityException {
        if (instance == null) {
            instance = new DefaultTrustManager();
        }
        return instance;
    }
}

