/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.CustomSSLSocket;
import com.zimbra.common.util.DefaultTrustManager;
import com.zimbra.common.util.SSLCertInfo;
import com.zimbra.common.util.ZimbraLog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CustomTrustManager
implements X509TrustManager {
    X509TrustManager defaultTrustManager;
    X509TrustManager keyStoreTrustManager;
    KeyStore keyStore;
    Map<String, X509Certificate> pendingCerts = new HashMap<String, X509Certificate>();
    private static CustomTrustManager instance;

    protected CustomTrustManager() {
        try {
            this.defaultTrustManager = DefaultTrustManager.getInstance();
            this.loadKeyStore();
            this.resetKeyStoreTrustManager();
        }
        catch (GeneralSecurityException x) {
            ZimbraLog.security.error((Object)"trust manager init error", x);
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.getDefaultTrustManager().checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (ZimbraLog.security.isDebugEnabled()) {
            ZimbraLog.security.debug("Server certificate chain:");
            for (int i = 0; i < chain.length; ++i) {
                ZimbraLog.security.debug("X509Certificate[" + i + "]=" + chain[i]);
            }
        }
        try {
            this.getDefaultTrustManager().checkServerTrusted(chain, authType);
            return;
        }
        catch (CertificateException x) {
            try {
                if (this.keyStore.size() == 0) {
                    throw new CertificateException("key store empty");
                }
                this.getKeyStoreTrustManager().checkServerTrusted(chain, authType);
            }
            catch (CertificateException x2) {
                String hostname = CustomSSLSocket.getCertificateHostname();
                if (hostname == null) {
                    hostname = SSLCertInfo.getCertificateCN(chain[0]);
                }
                String certInfo = this.handleCertificateCheckFailure(hostname, chain[0], false);
                throw new CertificateException(certInfo);
            }
            catch (KeyStoreException x3) {
                throw new CertificateException(x3);
            }
            return;
        }
    }

    public String handleCertificateCheckFailure(String hostname, X509Certificate cert, boolean isMismatch) {
        hostname = hostname.toLowerCase();
        String alias = hostname + ":" + cert.getSerialNumber().toString(16).toUpperCase();
        if (LC.ssl_allow_accept_untrusted_certs.booleanValue()) {
            this.cachePendingCertificate(alias, cert);
        }
        String certInfo = "";
        try {
            certInfo = new SSLCertInfo(alias, hostname, cert, LC.ssl_allow_accept_untrusted_certs.booleanValue(), isMismatch).serialize();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return certInfo;
    }

    public X509Certificate[] getAcceptedIssuers() {
        try {
            return this.getKeyStoreTrustManager().getAcceptedIssuers();
        }
        catch (GeneralSecurityException x) {
            return new X509Certificate[0];
        }
    }

    private synchronized void cachePendingCertificate(String alias, X509Certificate cert) {
        this.pendingCerts.put(alias, cert);
    }

    public synchronized void acceptCertificates(String alias) throws GeneralSecurityException {
        if (!LC.ssl_allow_accept_untrusted_certs.booleanValue()) {
            throw new SecurityException("accepting untrusted certificates not allowed: " + alias);
        }
        X509Certificate cert = this.pendingCerts.get(alias);
        if (cert != null) {
            try {
                this.keyStore.setCertificateEntry(alias, cert);
                this.saveKeyStore();
                this.resetKeyStoreTrustManager();
                this.pendingCerts.remove(alias);
            }
            catch (KeyStoreException x) {
                ZimbraLog.security.warn("failed to accept certificates of %s", alias);
            }
        } else {
            ZimbraLog.security.warn("Alias %s not found in cache; no certificates accepted.", alias);
        }
    }

    public synchronized boolean isCertificateAcceptedForHostname(String hostname, X509Certificate cert) {
        String prefix = hostname.toLowerCase() + ":";
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate c;
                String alias = aliases.nextElement();
                if (!alias.startsWith(prefix) || (c = (X509Certificate)this.keyStore.getCertificate(alias)) == null || !c.equals(cert)) continue;
                return true;
            }
        }
        catch (KeyStoreException x) {
            ZimbraLog.security.warn(x);
        }
        return false;
    }

    private X509TrustManager getDefaultTrustManager() throws CertificateException {
        if (this.defaultTrustManager == null) {
            throw new CertificateException("no default trust manager");
        }
        return this.defaultTrustManager;
    }

    private synchronized X509TrustManager getKeyStoreTrustManager() throws CertificateException {
        if (this.keyStoreTrustManager == null) {
            throw new CertificateException("no key store trust manager");
        }
        return this.keyStoreTrustManager;
    }

    private synchronized void setKeyStoreTrustManager(X509TrustManager trustManager) {
        this.keyStoreTrustManager = trustManager;
    }

    private synchronized void resetKeyStoreTrustManager() throws GeneralSecurityException {
        TrustManager[] trustManagers;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(this.keyStore);
        for (TrustManager tm : trustManagers = factory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this.setKeyStoreTrustManager((X509TrustManager)tm);
            return;
        }
        throw new KeyStoreException(TrustManagerFactory.getDefaultAlgorithm() + " trust manager not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadKeyStore() throws GeneralSecurityException {
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        boolean isKeyStoreInitialized = false;
        FileInputStream kin = null;
        try {
            kin = new FileInputStream(LC.mailboxd_keystore.value());
            try {
                this.keyStore.load(kin, LC.mailboxd_keystore_password.value().toCharArray());
                isKeyStoreInitialized = true;
            }
            catch (CertificateException x) {
                ZimbraLog.security.warn((Object)"failed to load certificates", x);
            }
            catch (IOException x) {
                ZimbraLog.security.warn((Object)"failed to read keystore file", x);
            }
        }
        catch (FileNotFoundException x) {
            ZimbraLog.security.info("keystore not present");
        }
        finally {
            if (kin != null) {
                try {
                    ((InputStream)kin).close();
                }
                catch (IOException x) {
                    ZimbraLog.security.warn((Object)"keystore file can't be closed after reading", x);
                }
            }
        }
        if (!isKeyStoreInitialized) {
            try {
                kin = new FileInputStream(LC.mailboxd_keystore_base.value());
                try {
                    this.keyStore.load(kin, LC.mailboxd_keystore_base_password.value().toCharArray());
                    isKeyStoreInitialized = true;
                }
                catch (CertificateException x) {
                    ZimbraLog.security.warn((Object)"failed to load backup certificates", x);
                }
                catch (IOException x) {
                    ZimbraLog.security.warn((Object)"failed to read backup keystore file", x);
                }
            }
            catch (FileNotFoundException x) {
                ZimbraLog.security.warn("backup keystore not found");
            }
            finally {
                if (kin != null) {
                    try {
                        ((InputStream)kin).close();
                    }
                    catch (IOException x) {
                        ZimbraLog.security.warn((Object)"backup keystore file can't be closed after reading", x);
                    }
                }
            }
        }
        if (!isKeyStoreInitialized) {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                this.keyStore.load(null, new char[0]);
            }
            catch (IOException x) {
                throw new KeyStoreException(x);
            }
        }
    }

    private synchronized void saveKeyStore() throws GeneralSecurityException {
        FileOutputStream kout = null;
        try {
            kout = new FileOutputStream(LC.mailboxd_keystore.value());
            try {
                this.keyStore.store(kout, LC.mailboxd_keystore_password.value().toCharArray());
            }
            catch (IOException x) {
                throw new KeyStoreException(x);
            }
        }
        catch (FileNotFoundException x) {
            throw new KeyStoreException(x);
        }
        finally {
            if (kout != null) {
                try {
                    ((OutputStream)kout).close();
                }
                catch (IOException x) {
                    throw new KeyStoreException(x);
                }
            }
        }
    }

    public static synchronized CustomTrustManager getInstance() {
        if (instance == null) {
            instance = new CustomTrustManager();
        }
        return instance;
    }
}

