/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.CustomSSLSocket;
import com.zimbra.common.util.CustomTrustManager;
import com.zimbra.common.util.ZimbraLog;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory factory;
    boolean verifyHostname = true;

    public CustomSSLSocketFactory(boolean verifyHostname) throws GeneralSecurityException {
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{CustomTrustManager.getInstance()}, null);
        this.factory = sslcontext.getSocketFactory();
        this.verifyHostname = verifyHostname;
    }

    public CustomSSLSocketFactory() throws GeneralSecurityException {
        this(true);
    }

    public Socket createSocket() throws IOException {
        return new CustomSSLSocket((SSLSocket)this.factory.createSocket(), null, this.verifyHostname);
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return new CustomSSLSocket((SSLSocket)this.factory.createSocket(address, port), address.getHostName(), this.verifyHostname);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return new CustomSSLSocket((SSLSocket)this.factory.createSocket(address, port, localAddress, localPort), address.getHostName(), this.verifyHostname);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return new CustomSSLSocket((SSLSocket)this.factory.createSocket(host, port), host, this.verifyHostname);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return new CustomSSLSocket((SSLSocket)this.factory.createSocket(host, port, localHost, localPort), host, this.verifyHostname);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean flag) throws IOException {
        return new CustomSSLSocket((SSLSocket)this.factory.createSocket(socket, host, port, flag), host, this.verifyHostname);
    }

    public static SocketFactory getDefault() {
        try {
            return new CustomSSLSocketFactory();
        }
        catch (GeneralSecurityException x) {
            ZimbraLog.security.error(x);
            return null;
        }
    }

    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

