/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.CustomTrustManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import sun.security.util.HostnameChecker;

public class CustomSSLSocket
extends SSLSocket {
    private static ThreadLocal<String> threadLocal = new ThreadLocal();
    private SSLSocket socket;
    private String host;
    private boolean verifyHostname;
    private boolean isHandshakeStarted;

    static String getCertificateHostname() {
        return threadLocal.get();
    }

    private static java.security.cert.X509Certificate certJavax2Java(X509Certificate cert) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(cert.getEncoded());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (java.security.cert.X509Certificate)cf.generateCertificate(bis);
        }
        catch (java.security.cert.CertificateEncodingException e) {
        }
        catch (CertificateEncodingException e) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    private static void verifyHostname(String hostname, SSLSession session) throws SSLPeerUnverifiedException, UnknownHostException, IOException {
        if (LC.ssl_allow_mismatched_certs.booleanValue()) {
            return;
        }
        try {
            InetAddress.getByName(hostname);
        }
        catch (UnknownHostException uhe) {
            throw new UnknownHostException("Could not resolve SSL sessions server hostname: " + hostname);
        }
        X509Certificate[] certs = session.getPeerCertificateChain();
        if (certs == null || certs.length == 0) {
            throw new SSLPeerUnverifiedException("No server certificates found: " + hostname);
        }
        java.security.cert.X509Certificate cert = CustomSSLSocket.certJavax2Java(certs[0]);
        if (CustomTrustManager.getInstance().isCertificateAcceptedForHostname(hostname, cert)) {
            return;
        }
        HostnameChecker hc = HostnameChecker.getInstance((byte)1);
        try {
            hc.match(hostname, cert);
        }
        catch (CertificateException x) {
            String certInfo = CustomTrustManager.getInstance().handleCertificateCheckFailure(hostname, cert, true);
            throw new SSLPeerUnverifiedException(certInfo);
        }
    }

    public CustomSSLSocket(SSLSocket socket, String host, boolean verifyHostname) {
        this.socket = socket;
        this.host = host;
        this.verifyHostname = verifyHostname;
    }

    private String getHostname() {
        if (this.host == null) {
            this.host = ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getHostName();
        }
        return this.host;
    }

    public void startHandshake() throws IOException {
        if (this.isHandshakeStarted) {
            return;
        }
        this.isHandshakeStarted = true;
        if (this.socket.getSoTimeout() <= 0) {
            this.socket.setSoTimeout(60000);
        }
        threadLocal.set(this.getHostname());
        try {
            this.socket.startHandshake();
        }
        catch (IOException x) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw x;
        }
        finally {
            threadLocal.remove();
        }
        if (this.verifyHostname) {
            CustomSSLSocket.verifyHostname(this.getHostname(), this.socket.getSession());
        }
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.socket.addHandshakeCompletedListener(listener);
    }

    public boolean getEnableSessionCreation() {
        return this.socket.getEnableSessionCreation();
    }

    public String[] getEnabledCipherSuites() {
        return this.socket.getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.socket.getEnabledProtocols();
    }

    public boolean getNeedClientAuth() {
        return this.socket.getNeedClientAuth();
    }

    public SSLSession getSession() {
        return this.socket.getSession();
    }

    public String[] getSupportedCipherSuites() {
        return this.socket.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.socket.getSupportedProtocols();
    }

    public boolean getUseClientMode() {
        return this.socket.getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.socket.getWantClientAuth();
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.socket.removeHandshakeCompletedListener(listener);
    }

    public void setEnableSessionCreation(boolean flag) {
        this.socket.setEnableSessionCreation(flag);
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.socket.setEnabledCipherSuites(suites);
    }

    public void setEnabledProtocols(String[] protocols2) {
        this.socket.setEnabledProtocols(protocols2);
    }

    public void setNeedClientAuth(boolean need) {
        this.socket.setNeedClientAuth(need);
    }

    public void setUseClientMode(boolean mode) {
        this.socket.setUseClientMode(mode);
    }

    public void setWantClientAuth(boolean want) {
        this.socket.setWantClientAuth(want);
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.socket.bind(bindpoint);
    }

    public synchronized void close() throws IOException {
        this.socket.close();
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.socket.connect(endpoint);
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.socket.connect(endpoint, timeout);
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        InputStream in = this.socket.getInputStream();
        this.startHandshake();
        return in;
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream out = this.socket.getOutputStream();
        this.startHandshake();
        return out;
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public void sendUrgentData(int data) throws IOException {
        this.socket.sendUrgentData(data);
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.socket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public String toString() {
        return this.socket.toString();
    }
}

