/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.CustomSSLSocket;
import com.zimbra.common.util.CustomTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class CustomSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLSocketFactory factory;

    public CustomSSLProtocolSocketFactory() throws GeneralSecurityException {
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{CustomTrustManager.getInstance()}, null);
        this.factory = sslcontext.getSocketFactory();
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return new CustomSSLSocket((SSLSocket)this.factory.createSocket(socket, host, port, autoClose), host, true);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new CustomSSLSocket((SSLSocket)this.factory.createSocket(host, port), host, true);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return new CustomSSLSocket((SSLSocket)this.factory.createSocket(host, port, clientHost, clientPort), host, true);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        return this.createSocket(host, port, localAddress, localPort);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(CustomSSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return CustomSSLProtocolSocketFactory.class.hashCode();
    }
}

