/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class CsvReader {
    private BufferedReader mReader;
    private String[] mColNames;
    private Map<String, String> mCurrent;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\\"?\\s*,\\s*\\\"?");

    public CsvReader(Reader reader) throws IOException {
        this.mReader = new BufferedReader(reader);
        String line = this.mReader.readLine();
        if (line == null) {
            this.mReader.close();
            throw new IOException("CSV reader contains no data");
        }
        this.mColNames = SPLIT_PATTERN.split(line);
    }

    public boolean hasNext() throws IOException {
        String line = this.mReader.readLine();
        if (line == null) {
            this.mReader.close();
            return false;
        }
        String[] values = SPLIT_PATTERN.split(line);
        int length = Math.min(values.length, this.mColNames.length);
        if (this.mCurrent == null) {
            this.mCurrent = new HashMap<String, String>();
        } else {
            this.mCurrent.clear();
        }
        for (int i = 0; i < length; ++i) {
            this.mCurrent.put(this.mColNames[i], values[i]);
        }
        return true;
    }

    public String[] getColNames() {
        return this.mColNames;
    }

    public boolean columnExists(String name) {
        for (String currentName : this.mColNames) {
            if (!currentName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getValue(String colName) {
        if (this.mCurrent == null) {
            throw new IllegalStateException("getValue() called before hasNext()");
        }
        return this.mCurrent.get(colName);
    }

    public void close() throws IOException {
        this.mReader.close();
    }
}

