/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.BufferStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopyOutputStream
extends OutputStream {
    private BufferStream bs;
    private OutputStream os;

    public CopyOutputStream(OutputStream os) {
        this(os, 0L);
    }

    public CopyOutputStream(OutputStream os, long sizeHint) {
        this(os, sizeHint, Integer.MAX_VALUE);
    }

    public CopyOutputStream(OutputStream os, long sizeHint, int maxBuffer) {
        this(os, sizeHint, maxBuffer, Long.MAX_VALUE);
    }

    public CopyOutputStream(OutputStream os, long sizeHint, int maxBuffer, long maxSize) {
        this.bs = new BufferStream(sizeHint, maxBuffer, maxSize);
        this.os = os;
    }

    public CopyOutputStream(OutputStream os, BufferStream bs) {
        this.bs = bs;
        this.os = os;
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public BufferStream getBufferStream() {
        return this.bs;
    }

    public InputStream getInputStream() throws IOException {
        return this.bs.getInputStream();
    }

    public long getSize() {
        return this.bs.getSize();
    }

    public long readFrom(InputStream is) throws IOException {
        return this.readFrom(is, Long.MAX_VALUE);
    }

    public long readFrom(InputStream is, long len) throws IOException {
        int in;
        byte[] tmp = new byte[(int)Math.min(len, 32768L)];
        long out = 0L;
        while (len > 0L && (in = is.read(tmp, 0, (int)Math.min(len, (long)tmp.length))) > 0) {
            this.write(tmp, 0, in);
            len -= (long)in;
            out += (long)in;
        }
        return out;
    }

    public void release() {
        this.bs.close();
    }

    public byte[] toByteArray() {
        return this.bs.toByteArray();
    }

    public void write(int data) throws IOException {
        this.os.write(data);
        this.bs.write(data);
    }

    public void write(byte[] data, int off, int len) throws IOException {
        this.os.write(data, off, len);
        this.bs.write(data, off, len);
    }
}

