/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.BufferStream;
import java.io.IOException;
import java.io.InputStream;

public class CopyInputStream
extends InputStream {
    private BufferStream bs;
    private InputStream is;

    public CopyInputStream(InputStream is) {
        this(is, 0L);
    }

    public CopyInputStream(InputStream is, long sizeHint) {
        this(is, sizeHint, Integer.MAX_VALUE);
    }

    public CopyInputStream(InputStream is, long sizeHint, int maxBuffer) {
        this(is, sizeHint, maxBuffer, Long.MAX_VALUE);
    }

    public CopyInputStream(InputStream is, long sizeHint, int maxBuffer, long maxSize) {
        this.bs = new BufferStream(sizeHint, maxBuffer, maxSize);
        this.is = is;
    }

    public CopyInputStream(InputStream is, BufferStream bs) {
        this.bs = bs;
        this.is = is;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
    }

    public BufferStream getBufferStream() {
        return this.bs;
    }

    public InputStream getInputStream() throws IOException {
        return this.bs.getInputStream();
    }

    public long getSize() {
        return this.bs.getSize();
    }

    public void mark(int limit) {
        this.is.mark(limit);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public int read() throws IOException {
        int in = this.is.read();
        if (in != -1) {
            this.bs.write(in);
        }
        return in;
    }

    public int read(byte[] data, int off, int len) throws IOException {
        int in = this.is.read(data, off, len);
        if (in > 0) {
            this.bs.write(data, off, in);
        }
        return in;
    }

    public long readFrom() throws IOException {
        return this.bs.readFrom(this.is);
    }

    public long readFrom(long len) throws IOException {
        return this.bs.readFrom(this.is, len);
    }

    public void release() {
        this.bs.close();
    }

    public void reset() throws IOException {
        this.is.reset();
    }

    public byte[] toByteArray() {
        return this.bs.toByteArray();
    }
}

