/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.ConsoleReaderInputStream;
import jline.History;

public class ConsoleRunner {
    public static final String property = "jline.history";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String historyFileName = null;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        if (argList.size() == 0) {
            ConsoleRunner.usage();
            return;
        }
        historyFileName = System.getProperty(property, null);
        String mainClass = (String)argList.remove(0);
        ConsoleReader reader = new ConsoleReader();
        File historyFile = null;
        try {
            historyFile = historyFileName != null ? new File(System.getProperty("user.home"), ".jline-" + mainClass + "." + historyFileName + ".history") : new File(System.getProperty("user.home"), ".jline-" + mainClass + ".history");
            reader.setHistory(new History(historyFile));
        }
        catch (IOException e) {
            System.err.format("Unable to write to %s.  Command history will not be saved.\n", historyFile);
        }
        String completors = System.getProperty(ConsoleRunner.class.getName() + ".completors", "");
        ArrayList<Completor> completorList = new ArrayList<Completor>();
        StringTokenizer tok = new StringTokenizer(completors, ",");
        while (tok.hasMoreTokens()) {
            completorList.add((Completor)Class.forName(tok.nextToken()).newInstance());
        }
        if (completorList.size() > 0) {
            reader.addCompletor((Completor)new ArgumentCompletor(completorList));
        }
        ConsoleReaderInputStream.setIn((ConsoleReader)reader);
        try {
            Class.forName(mainClass).getMethod("main", String[].class).invoke(null, new Object[]{argList.toArray(new String[0])});
        }
        finally {
            ConsoleReaderInputStream.restoreIn();
        }
    }

    private static void usage() {
        System.out.println("Usage: \n   java [-Djline.history='name'] " + ConsoleRunner.class.getName() + " <target class name> [args]" + "\n\nThe -Djline.history option will avoid history" + "\nmangling when running ConsoleRunner on the same application." + "\n\nargs will be passed directly to the target class name.");
    }
}

