/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class CompressedDomainTree {
    private TreeMap mRoot = new TreeMap();
    private static final String SEP = "\\.";
    private static final String LEAF = "<>";

    private void addNodes(Map parent, String[] domains, int index) {
        String d = domains[index];
        Object o = parent.get(d);
        if (o == null) {
            if (index > 0) {
                TreeMap child = new TreeMap();
                parent.put(d, child);
                this.addNodes(child, domains, --index);
            } else {
                parent.put(d, d);
            }
        } else if (o instanceof String) {
            if (index > 0) {
                TreeMap<String, String> child = new TreeMap<String, String>();
                this.addNodes(child, domains, --index);
                parent.put(d, child);
                child.put(LEAF, d);
            }
        } else if (o instanceof Map) {
            Map child = (Map)o;
            if (index > 0) {
                this.addNodes(child, domains, --index);
            } else {
                child.put(LEAF, d);
            }
        }
    }

    public void add(String domain) {
        String[] domains = (domain = domain.toLowerCase()).charAt(0) == '[' ? new String[]{domain} : domain.split(SEP);
        if (domains == null || domains.length == 0) {
            return;
        }
        this.addNodes(this.mRoot, domains, domains.length - 1);
    }

    public boolean hasNode(String node) {
        return false;
    }

    public static boolean hasNode(String node, String tree, char seperator) {
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.dump(this.mRoot, "", sb);
        return sb.toString();
    }

    private void dump(Map root, String indent, StringBuffer sb) {
        for (Map.Entry entry : root.entrySet()) {
            String name = (String)entry.getKey();
            Object o = entry.getValue();
            if (o instanceof String) {
                sb.append(indent).append(name).append("\n");
                continue;
            }
            sb.append(indent).append(name).append(": {\n");
            this.dump((Map)o, indent + " ", sb);
            sb.append(indent).append("}\n");
        }
    }

    public String toTree() {
        StringBuffer sb = new StringBuffer();
        this.dumpTree(this.mRoot, sb);
        return sb.toString();
    }

    private void dumpTree(Map root, StringBuffer sb) {
        boolean first = true;
        for (Map.Entry entry : root.entrySet()) {
            String name = (String)entry.getKey();
            Object o = entry.getValue();
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            if (o instanceof String) {
                if (name.equals(LEAF)) continue;
                sb.append(name);
                continue;
            }
            sb.append(name).append('{');
            this.dumpTree((Map)o, sb);
            sb.append('}');
        }
    }

    public static void main(String[] args) throws AddressException {
        CompressedDomainTree dt = new CompressedDomainTree();
        String[] domains = new String[]{"something", "[127.0.0.1]", "stanford.edu", "windlord.stanford.edu", "lists.stanford.edu", "washington.edu", "andrew.cmu.edu", "mit.edu", "alumni.mit.edu", "yahoo.com", "hotmail.com"};
        StringBuffer full = new StringBuffer();
        for (int i = 0; i < domains.length; ++i) {
            if (i > 0) {
                full.append(",");
            }
            full.append(domains[i]);
            dt.add(domains[i]);
        }
        System.out.println(dt.toTree());
        System.out.println(full.toString());
        InternetAddress ia = new InternetAddress("schemers@[12.12.12.12]");
        System.out.println(ia.getAddress());
        System.out.println(ia.getPersonal());
        System.out.println(ia.getType());
    }

    public List getNodes() {
        return null;
    }

    public static List getNodes(String tree, char seperator) {
        return null;
    }
}

