/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.io.CharConversionException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompactEncoder {
    public static Object decode(byte[] data) throws CompactEncoderException {
        Object obj;
        ByteBuffer bb = ByteBuffer.wrap(data);
        try {
            byte order = bb.get();
            if (order == 91) {
                bb.order(ByteOrder.BIG_ENDIAN);
            } else if (order == 93) {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            } else if (order != 92) {
                throw new CompactEncoderException("invalid data format");
            }
            obj = CompactEncoder.decode(bb);
        }
        catch (CompactEncoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompactEncoderException(e);
        }
        if (bb.hasRemaining()) {
            throw new CompactEncoderException("invalid trailing data");
        }
        return obj;
    }

    public static byte[] encode(Object obj) {
        return CompactEncoder.encode(obj, ByteOrder.nativeOrder());
    }

    public static byte[] encode(Object obj, ByteOrder bo) {
        ByteBuffer bb = ByteBuffer.allocate(1024);
        bb.order(bo);
        bb.put(bo == ByteOrder.BIG_ENDIAN ? (byte)91 : 93);
        bb = CompactEncoder.encode(bb, obj);
        byte[] ret = new byte[bb.position()];
        System.arraycopy(bb.array(), 0, ret, 0, bb.position());
        return ret;
    }

    public static byte[] encodeToString(Object obj) {
        ByteBuffer bb = ByteBuffer.allocate(1024);
        bb.put((byte)92);
        bb = CompactEncoder.encodeToString(bb, obj);
        byte[] ret = new byte[bb.position()];
        System.arraycopy(bb.array(), 0, ret, 0, bb.position());
        return ret;
    }

    private static Object decode(ByteBuffer bb) throws Exception {
        byte type = bb.get();
        switch (type) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: {
                byte[] str = new byte[type - 32];
                bb.get(str);
                return new String(str, "UTF-8");
            }
            case 65: {
                byte atype = bb.get();
                int len = (int)CompactEncoder.getStringLong(bb);
                switch (atype) {
                    case 66: {
                        byte[] ret = new byte[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = (byte)CompactEncoder.getStringLong(bb);
                        }
                        return ret;
                    }
                    case 67: {
                        char[] ret = new char[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = (char)CompactEncoder.getStringLong(bb);
                        }
                        return ret;
                    }
                    case 83: {
                        short[] ret = new short[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = (short)CompactEncoder.getStringLong(bb);
                        }
                        return ret;
                    }
                    case 73: {
                        int[] ret = new int[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = (int)CompactEncoder.getStringLong(bb);
                        }
                        return ret;
                    }
                    case 76: {
                        long[] ret = new long[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = CompactEncoder.getStringLong(bb);
                        }
                        return ret;
                    }
                    case 70: {
                        float[] ret = new float[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = Float.parseFloat(CompactEncoder.getString(bb));
                        }
                        return ret;
                    }
                    case 68: {
                        double[] ret = new double[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = Double.parseDouble(CompactEncoder.getString(bb));
                        }
                        return ret;
                    }
                    case 79: {
                        Object[] ret = new Object[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = CompactEncoder.decode(bb);
                        }
                        return ret;
                    }
                }
                throw new CompactEncoderException("invalid data type");
            }
            case 97: {
                byte atype = bb.get();
                int len = bb.getInt();
                switch (atype) {
                    case 98: {
                        byte[] ret = new byte[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = bb.get();
                        }
                        return ret;
                    }
                    case 99: {
                        char[] ret = new char[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = bb.getChar();
                        }
                        return ret;
                    }
                    case 115: {
                        short[] ret = new short[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = bb.getShort();
                        }
                        return ret;
                    }
                    case 105: {
                        int[] ret = new int[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = bb.getInt();
                        }
                        return ret;
                    }
                    case 108: {
                        long[] ret = new long[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = bb.getLong();
                        }
                        return ret;
                    }
                    case 102: {
                        float[] ret = new float[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = bb.getFloat();
                        }
                        return ret;
                    }
                    case 100: {
                        double[] ret = new double[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = bb.getDouble();
                        }
                        return ret;
                    }
                    case 111: {
                        Object[] ret = new Object[len];
                        for (int i = 0; i < len; ++i) {
                            ret[i] = CompactEncoder.decode(bb);
                        }
                        return ret;
                    }
                }
                throw new CompactEncoderException("invalid data type");
            }
            case 66: {
                return new Byte((byte)CompactEncoder.getStringLong(bb));
            }
            case 98: {
                return new Byte(bb.get());
            }
            case 67: {
                return new Character((char)CompactEncoder.getStringLong(bb));
            }
            case 99: {
                return new Character(bb.getChar());
            }
            case 83: {
                return new Short((short)CompactEncoder.getStringLong(bb));
            }
            case 115: {
                return new Short(bb.getShort());
            }
            case 73: {
                return new Integer((int)CompactEncoder.getStringLong(bb));
            }
            case 105: {
                return new Integer(bb.getInt());
            }
            case 76: {
                return new Long(CompactEncoder.getStringLong(bb));
            }
            case 108: {
                return new Long(bb.getLong());
            }
            case 70: {
                return new Float(Float.parseFloat(CompactEncoder.getString(bb)));
            }
            case 102: {
                return new Float(bb.getFloat());
            }
            case 68: {
                return new Double(Double.parseDouble(CompactEncoder.getString(bb)));
            }
            case 100: {
                return new Double(bb.getDouble());
            }
            case 69: {
                return new Integer((int)CompactEncoder.getStringLong(bb));
            }
            case 101: {
                return new Integer(bb.getShort());
            }
            case 110: {
                return null;
            }
            case 77: {
                int cnt = (int)CompactEncoder.getStringLong(bb);
                HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)cnt * 1.5));
                for (int i = 0; i < cnt; ++i) {
                    map.put(CompactEncoder.decode(bb), CompactEncoder.decode(bb));
                }
                return map;
            }
            case 109: {
                int cnt = bb.getInt();
                HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)cnt * 1.5));
                for (int i = 0; i < cnt; ++i) {
                    map.put(CompactEncoder.decode(bb), CompactEncoder.decode(bb));
                }
                return map;
            }
            case 112: {
                byte[] val = new byte[bb.getShort()];
                bb.get(val);
                return new String(val, "UTF-8");
            }
            case 84: {
                byte[] str = new byte[(int)CompactEncoder.getStringLong(bb)];
                bb.get(str);
                return new String(str, "UTF-8");
            }
            case 116: {
                byte[] val = new byte[bb.getInt()];
                bb.get(val);
                return new String(val, "UTF-8");
            }
            case 86: {
                int cnt = (int)CompactEncoder.getStringLong(bb);
                ArrayList<Object> array = new ArrayList<Object>(cnt);
                for (int i = 0; i < cnt; ++i) {
                    array.add(i, CompactEncoder.decode(bb));
                }
                return array;
            }
            case 118: {
                int cnt = bb.getInt();
                ArrayList<Object> array = new ArrayList<Object>(cnt);
                for (int i = 0; i < cnt; ++i) {
                    array.add(i, CompactEncoder.decode(bb));
                }
                return array;
            }
            case 123: {
                return new Boolean(true);
            }
            case 125: {
                return new Boolean(false);
            }
        }
        throw new CompactEncoderException("invalid data type");
    }

    private static ByteBuffer encode(ByteBuffer bb, Object obj) {
        if (!(obj instanceof String)) {
            if (obj instanceof Integer) {
                return CompactEncoder.putRaw(bb, 'i', 32).putInt((Integer)obj);
            }
            if (obj instanceof Boolean) {
                return CompactEncoder.putRaw(bb, (Boolean)obj != false ? (char)'{' : '}', 0);
            }
            if (obj instanceof Byte) {
                return CompactEncoder.putRaw(bb, 'b', 8).put((Byte)obj);
            }
            if (obj instanceof Character) {
                return CompactEncoder.putRaw(bb, 'c', 16).putShort((short)((Character)obj).charValue());
            }
            if (obj instanceof Short) {
                return CompactEncoder.putRaw(bb, 's', 16).putShort((Short)obj);
            }
            if (obj instanceof Long) {
                return CompactEncoder.putRaw(bb, 'l', 64).putLong((Long)obj);
            }
            if (obj instanceof Float) {
                return CompactEncoder.putRaw(bb, 'f', 32).putFloat(((Float)obj).floatValue());
            }
            if (obj instanceof Double) {
                return CompactEncoder.putRaw(bb, 'd', 64).putDouble((Double)obj);
            }
            if (obj instanceof Enum) {
                return CompactEncoder.putRaw(bb, 'e', 16).putShort((short)((Enum)obj).ordinal());
            }
            if (obj == null) {
                return CompactEncoder.putRaw(bb, 'n', 0);
            }
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                bb = CompactEncoder.putRaw(bb, 'a', 0);
                if (obj instanceof int[]) {
                    bb = CompactEncoder.putRaw(bb, 'i', 32 + len * 32).putInt(len);
                    for (int i = 0; i < len; ++i) {
                        bb.putInt(Array.getInt(obj, i));
                    }
                } else if (obj instanceof byte[]) {
                    bb = CompactEncoder.putRaw(bb, 'b', 32 + len * 8).putInt(len);
                    for (int i = 0; i < len; ++i) {
                        bb.put(Array.getByte(obj, i));
                    }
                } else if (obj instanceof char[]) {
                    bb = CompactEncoder.putRaw(bb, 'c', 32 + len * 16).putInt(len);
                    for (int i = 0; i < len; ++i) {
                        bb.putChar(Array.getChar(obj, i));
                    }
                } else if (obj instanceof short[]) {
                    bb = CompactEncoder.putRaw(bb, 's', 32 + len * 16).putInt(len);
                    for (int i = 0; i < len; ++i) {
                        bb.putShort(Array.getShort(obj, i));
                    }
                } else if (obj instanceof long[]) {
                    bb = CompactEncoder.putRaw(bb, 'l', 32 + len * 64).putInt(len);
                    for (int i = 0; i < len; ++i) {
                        bb.putLong(Array.getLong(obj, i));
                    }
                } else if (obj instanceof float[]) {
                    bb = CompactEncoder.putRaw(bb, 'f', 32 + len * 32).putInt(len);
                    for (int i = 0; i < len; ++i) {
                        bb.putFloat(Array.getFloat(obj, i));
                    }
                } else if (obj instanceof Double[]) {
                    bb = CompactEncoder.putRaw(bb, 'd', 32 + len * 64).putInt(len);
                    for (int i = 0; i < len; ++i) {
                        bb.putDouble(Array.getDouble(obj, i));
                    }
                } else {
                    bb = CompactEncoder.putRaw(bb, 'o', 32).putInt(len);
                    for (int i = 0; i < len; ++i) {
                        bb = CompactEncoder.encode(bb, Array.get(obj, i));
                    }
                }
                return bb;
            }
            if (obj instanceof List) {
                List l = (List)obj;
                bb = CompactEncoder.putRaw(bb, 'v', 32).putInt(l.size());
                for (Object val : l) {
                    bb = CompactEncoder.encode(bb, val);
                }
                return bb;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                bb = CompactEncoder.putRaw(bb, 'm', 32).putInt(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    bb = CompactEncoder.encode(bb, entry.getKey());
                    bb = CompactEncoder.encode(bb, entry.getValue());
                }
                return bb;
            }
        }
        byte[] val = null;
        try {
            val = obj.toString().getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val.length < 33) {
            return CompactEncoder.putRaw(bb, (char)(32 + val.length), val.length).put(val);
        }
        if (val.length <= Short.MAX_VALUE) {
            return CompactEncoder.putRaw(bb, 'p', 16 + val.length).putShort((short)val.length).put(val);
        }
        return CompactEncoder.putRaw(bb, 't', 32 + val.length).putInt(val.length).put(val);
    }

    private static ByteBuffer encodeToString(ByteBuffer bb, Object obj) {
        if (!(obj instanceof String)) {
            if (obj instanceof Integer) {
                return CompactEncoder.putString(bb, 'I', obj);
            }
            if (obj instanceof Boolean) {
                return CompactEncoder.putRaw(bb, (Boolean)obj != false ? (char)'{' : '}', 0);
            }
            if (obj instanceof Byte) {
                return CompactEncoder.putString(bb, 'B', obj);
            }
            if (obj instanceof Character) {
                return CompactEncoder.putString(bb, 'C', obj);
            }
            if (obj instanceof Short) {
                return CompactEncoder.putString(bb, 'S', obj);
            }
            if (obj instanceof Long) {
                return CompactEncoder.putString(bb, 'L', obj);
            }
            if (obj instanceof Float) {
                return CompactEncoder.putString(bb, 'F', obj);
            }
            if (obj instanceof Double) {
                return CompactEncoder.putString(bb, 'D', obj);
            }
            if (obj instanceof Enum) {
                return CompactEncoder.putString(bb, 'E', ((Enum)obj).ordinal());
            }
            if (obj == null) {
                return CompactEncoder.putRaw(bb, 'n', 0);
            }
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                bb = CompactEncoder.putRaw(bb, 'A', 0);
                if (obj instanceof int[]) {
                    bb = CompactEncoder.putString(bb, 'I', len);
                    for (int i = 0; i < len; ++i) {
                        bb = CompactEncoder.putStringElem(bb, Array.getInt(obj, i));
                    }
                } else if (obj instanceof byte[]) {
                    bb = CompactEncoder.putString(bb, 'B', len);
                    for (int i = 0; i < len; ++i) {
                        bb = CompactEncoder.putStringElem(bb, Array.getByte(obj, i));
                    }
                } else if (obj instanceof char[]) {
                    bb = CompactEncoder.putString(bb, 'C', len);
                    for (int i = 0; i < len; ++i) {
                        bb = CompactEncoder.putStringElem(bb, (short)Array.getChar(obj, i));
                    }
                } else if (obj instanceof short[]) {
                    bb = CompactEncoder.putString(bb, 'S', len);
                    for (int i = 0; i < len; ++i) {
                        bb = CompactEncoder.putStringElem(bb, Array.getShort(obj, i));
                    }
                } else if (obj instanceof long[]) {
                    bb = CompactEncoder.putString(bb, 'L', len);
                    for (int i = 0; i < len; ++i) {
                        bb = CompactEncoder.putStringElem(bb, Array.getLong(obj, i));
                    }
                } else if (obj instanceof float[]) {
                    bb = CompactEncoder.putString(bb, 'F', len);
                    for (int i = 0; i < len; ++i) {
                        bb = CompactEncoder.putStringElem(bb, Float.valueOf(Array.getFloat(obj, i)));
                    }
                } else if (obj instanceof Double[]) {
                    bb = CompactEncoder.putString(bb, 'D', len);
                    for (int i = 0; i < len; ++i) {
                        bb = CompactEncoder.putStringElem(bb, Array.getDouble(obj, i));
                    }
                } else {
                    bb = CompactEncoder.putString(bb, 'O', len);
                    for (int i = 0; i < len; ++i) {
                        bb = CompactEncoder.encodeToString(bb, Array.get(obj, i));
                    }
                }
                return bb;
            }
            if (obj instanceof List) {
                List l = (List)obj;
                bb = CompactEncoder.putString(bb, 'V', l.size());
                for (Object val : l) {
                    bb = CompactEncoder.encodeToString(bb, val);
                }
                return bb;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                bb = CompactEncoder.putString(bb, 'M', map.size());
                for (Map.Entry entry : map.entrySet()) {
                    bb = CompactEncoder.encodeToString(bb, entry.getKey());
                    bb = CompactEncoder.encodeToString(bb, entry.getValue());
                }
                return bb;
            }
        }
        byte[] val = null;
        try {
            val = obj.toString().getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val.length < 33) {
            return CompactEncoder.putRaw(bb, (char)(32 + val.length), val.length).put(val);
        }
        bb = CompactEncoder.putString(bb, 'T', String.valueOf(val.length));
        return CompactEncoder.ensure(bb, val.length).put(val);
    }

    private static String getString(ByteBuffer bb) throws Exception {
        byte len = (byte)(bb.get() - 32);
        byte[] val = new byte[len];
        bb.get(val);
        return new String(val, "UTF-8");
    }

    private static long getStringLong(ByteBuffer bb) throws CharConversionException {
        long l = 0L;
        byte len = (byte)(bb.get() - 32);
        boolean neg = false;
        while (true) {
            byte by = len;
            len = (byte)(by - 1);
            if (by <= 0) break;
            byte b = bb.get();
            if (b == 45 && l == 0L) {
                neg = true;
                continue;
            }
            if (!Character.isDigit(b)) {
                throw new CharConversionException();
            }
            l = 10L * l + (long)b - 48L;
        }
        return neg ? -1L * l : l;
    }

    private static ByteBuffer ensure(ByteBuffer bb, int cap) {
        if (bb.remaining() < cap) {
            return ByteBuffer.allocate(bb.capacity() < cap ? bb.capacity() * 2 : bb.capacity() + cap + 512).put(bb.array());
        }
        return bb;
    }

    private static ByteBuffer putRaw(ByteBuffer bb, char type, int cap) {
        return CompactEncoder.ensure(bb, cap + 1).put((byte)type);
    }

    private static ByteBuffer putString(ByteBuffer bb, char type, Object obj) {
        byte[] str;
        try {
            str = obj.toString().getBytes("UTF-8");
        }
        catch (Exception e) {
            str = obj.getClass().getName().getBytes();
        }
        return CompactEncoder.ensure(bb, str.length + 2).put((byte)type).put((byte)(32 + str.length)).put(str);
    }

    private static ByteBuffer putStringElem(ByteBuffer bb, Object obj) {
        byte[] str;
        try {
            str = obj.toString().getBytes("UTF-8");
        }
        catch (Exception e) {
            str = obj.getClass().getName().getBytes();
        }
        return CompactEncoder.ensure(bb, str.length + 1).put((byte)(32 + str.length)).put(str);
    }

    public static void main(String[] args) throws CompactEncoderException {
        char[] carray = new char[]{'a', 'r', 'r', 'a', 'y'};
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object[] oarray = new Object[]{new String("arraystring"), new Integer(9)};
        byte[] print = CompactEncoder.encodeToString(oarray);
        byte[] raw = CompactEncoder.encode(oarray);
        Object[] darray = (Object[])CompactEncoder.decode(print);
        darray = (Object[])CompactEncoder.decode(raw);
        list.add(carray);
        list.add(new Integer(8));
        list.add("string");
        list.add(true);
        print = CompactEncoder.encodeToString(list);
        raw = CompactEncoder.encode(list);
        ArrayList dlist = (ArrayList)CompactEncoder.decode(print);
        dlist = (ArrayList)CompactEncoder.decode(raw);
        map.put("array", oarray);
        map.put("byteorder", ByteOrder.nativeOrder());
        map.put("emptystring", "");
        map.put("float", new Float(1.1));
        map.put("hashmap", new HashMap());
        map.put("list", list);
        map.put("long", new Long(3L));
        map.put("mapstring", "test");
        map.put("null", null);
        map.put("text", "1234567890123456789012345678901234567890");
        print = CompactEncoder.encodeToString(map);
        raw = CompactEncoder.encode(map);
        HashMap dmap = (HashMap)CompactEncoder.decode(print);
        dmap = (HashMap)CompactEncoder.decode(raw);
        System.out.println(new String(print));
        darray.toString();
        dlist.toString();
        ((Object)dmap).toString();
    }

    public static class CompactEncoderException
    extends Exception {
        static final long serialVersionUID = -4610917332015428041L;

        CompactEncoderException(Exception e) {
            super(e);
        }

        CompactEncoderException(String s) {
            super(s);
        }
    }
}

