/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.util.EasySSLProtocolSocketFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class CliUtil {
    public static void toolSetup() {
        CliUtil.toolSetup("INFO");
    }

    public static void toolSetup(String defaultLogLevel) {
        CliUtil.toolSetup(defaultLogLevel, null, false);
    }

    public static void toolSetup(String defaultLogLevel, String logFile, boolean showThreads) {
        ZimbraLog.toolSetupLog4j(defaultLogLevel, logFile, showThreads);
        if (LC.ssl_allow_untrusted_certs.booleanValue()) {
            EasySSLProtocolSocketFactory.init();
        }
    }

    public static Option getOption(CommandLine cl, String name) {
        for (Option opt : cl.getOptions()) {
            if (!StringUtil.equal(opt.getOpt(), name) && !StringUtil.equal(opt.getLongOpt(), name)) continue;
            return opt;
        }
        return null;
    }

    public static boolean hasOption(CommandLine cl, String name) {
        return CliUtil.getOption(cl, name) != null;
    }

    public static String getOptionValue(CommandLine cl, String name) {
        Option opt = CliUtil.getOption(cl, name);
        if (opt == null) {
            return null;
        }
        return opt.getValue();
    }
}

