/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.SystemUtil;

public abstract class ClassLogger {
    protected Log mLog;

    protected abstract String getInstanceInfo();

    protected Object formatObject(Object o) {
        if (o instanceof Throwable) {
            return SystemUtil.getStackTrace((Throwable)o);
        }
        return o;
    }

    protected ClassLogger(Log log) {
        this.mLog = log;
    }

    protected Object[] printArgs(Object[] objs) {
        if (objs == null) {
            return null;
        }
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = this.formatObject(objs[i]);
        }
        return objs;
    }

    protected void debug(String format, Object ... objects) {
        if (this.mLog.isDebugEnabled()) {
            this.mLog.debug(this.getInstanceInfo() + " - " + format, this.printArgs(objects));
        }
    }

    protected void info(String format, Object ... objects) {
        if (this.mLog.isInfoEnabled()) {
            this.mLog.info(this.getInstanceInfo() + " - " + format, this.printArgs(objects));
        }
    }

    protected void warn(String format, Object ... objects) {
        if (this.mLog.isWarnEnabled()) {
            this.mLog.warn(this.getInstanceInfo() + " - " + format, this.printArgs(objects));
        }
    }

    protected void error(String format, Object ... objects) {
        if (this.mLog.isErrorEnabled()) {
            this.mLog.error(this.getInstanceInfo() + " - " + format, this.printArgs(objects));
        }
    }

    protected void debug(String str, Throwable t) {
        if (this.mLog.isDebugEnabled()) {
            this.mLog.debug((Object)(this.getInstanceInfo() + " - " + str), t);
        }
    }

    protected void info(String str, Throwable t) {
        if (this.mLog.isInfoEnabled()) {
            this.mLog.info((Object)(this.getInstanceInfo() + " - " + str), t);
        }
    }

    protected void warn(String str, Throwable t) {
        if (this.mLog.isWarnEnabled()) {
            this.mLog.warn((Object)(this.getInstanceInfo() + " - " + str), t);
        }
    }
}

