/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.ByteUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CalculatorStream
extends InputStream {
    private long mSize = 0L;
    private InputStream mIn;
    private MessageDigest mDigestCalculator;

    public CalculatorStream(InputStream in) {
        try {
            this.mDigestCalculator = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialize " + CalculatorStream.class.getSimpleName(), e);
        }
        this.mIn = new DigestInputStream(in, this.mDigestCalculator);
    }

    public String getDigest() {
        return ByteUtil.encodeFSSafeBase64(this.mDigestCalculator.digest());
    }

    public long getSize() {
        return this.mSize;
    }

    public int read() throws IOException {
        int result = this.mIn.read();
        if (result >= 0) {
            ++this.mSize;
        }
        return result;
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int numRead = this.mIn.read(b, off, len);
        if (numRead > 0) {
            this.mSize += (long)numRead;
        }
        return numRead;
    }

    public int read(byte[] b) throws IOException {
        int numRead = this.mIn.read(b);
        if (numRead > 0) {
            this.mSize += (long)numRead;
        }
        return numRead;
    }

    public int available() throws IOException {
        return this.mIn.available();
    }

    public void close() throws IOException {
        this.mIn.close();
    }

    public long skip(long n) throws IOException {
        return this.mIn.skip(n);
    }
}

