/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.util.BufferStream;
import com.zimbra.common.util.ZimbraLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class ByteUtil {
    private static final int SKIP_BUFFER_SIZE = 4096;
    private static byte[] skipBuffer;
    private static final int MAX_STRING_LEN = 0x2000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putContent(String path, byte[] data) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(path));
            fos.write(data);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(File file) throws IOException {
        byte[] buffer = new byte[(int)file.length()];
        FileInputStream is = null;
        try {
            int num_read;
            is = new FileInputStream(file);
            int total_read = 0;
            for (int num_left = buffer.length; num_left > 0 && (num_read = ((InputStream)is).read(buffer, total_read, num_left)) != -1; num_left -= num_read) {
                total_read += num_read;
            }
        }
        catch (Throwable throwable) {
            ByteUtil.closeStream(is);
            throw throwable;
        }
        ByteUtil.closeStream(is);
        return buffer;
    }

    public static int countBytes(InputStream is) throws IOException {
        byte[] buf = new byte[8192];
        int count = 0;
        int num = 0;
        while ((num = is.read(buf)) != -1) {
            count += num;
        }
        return count;
    }

    public static byte[] getContent(InputStream is, int sizeHint) throws IOException {
        return ByteUtil.getContent(is, sizeHint, -1L);
    }

    public static byte[] getContent(InputStream is, int sizeHint, boolean close) throws IOException {
        return ByteUtil.getContent(is, -1, sizeHint, -1L, close);
    }

    public static byte[] getContent(InputStream is, int sizeHint, long sizeLimit) throws IOException {
        return ByteUtil.getContent(is, -1, sizeHint, sizeLimit, true);
    }

    public static byte[] getPartialContent(InputStream is, int length, int sizeHint) throws IOException {
        return ByteUtil.getContent(is, length, sizeHint, -1L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getContent(InputStream is, int length, int sizeHint, long sizeLimit, boolean close) throws IOException {
        if (length == 0) {
            return new byte[0];
        }
        try {
            BufferStream bs = sizeLimit == -1L ? new BufferStream(sizeHint, Integer.MAX_VALUE, Integer.MAX_VALUE) : new BufferStream(sizeHint, (int)sizeLimit, sizeLimit);
            bs.readFrom(is, length == -1 ? Long.MAX_VALUE : (long)length);
            if (sizeLimit > 0L && bs.size() > sizeLimit) {
                throw new IOException("stream too large");
            }
            byte[] byArray = bs.toByteArray();
            return byArray;
        }
        finally {
            if (close) {
                ByteUtil.closeStream(is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(Reader reader, int length, boolean close) throws IOException {
        if (reader == null || length == 0) {
            return "";
        }
        if (length < 0) {
            length = Integer.MAX_VALUE;
        }
        char[] buf = new char[Math.min(1024, length)];
        int totalRead = 0;
        StringBuilder retVal = new StringBuilder(buf.length);
        try {
            int numRead;
            int numToRead;
            while ((numToRead = Math.min(buf.length, length - totalRead)) > 0 && (numRead = reader.read(buf)) >= 0) {
                retVal.append(buf, 0, numRead);
                totalRead += numRead;
            }
            String string = retVal.toString();
            return string;
        }
        finally {
            if (close) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    ZimbraLog.misc.warn((Object)"Unable to close Reader", e);
                }
            }
        }
    }

    public static void closeStream(InputStream is) {
        if (is == null) {
            return;
        }
        if (is instanceof PipedInputStream) {
            try {
                while (is.read() != -1) {
                }
            }
            catch (Exception e) {
                ZimbraLog.misc.debug((Object)"ignoring exception while draining PipedInputStream", e);
            }
        }
        try {
            is.close();
        }
        catch (Exception e) {
            ZimbraLog.misc.debug((Object)"ignoring exception while closing input stream", e);
        }
    }

    public static void closeStream(OutputStream os) {
        if (os == null) {
            return;
        }
        try {
            os.close();
        }
        catch (Exception e) {
            ZimbraLog.misc.debug((Object)"ignoring exception while closing output stream", e);
        }
    }

    public static void closeReader(Reader r) {
        if (r == null) {
            return;
        }
        try {
            r.close();
        }
        catch (IOException e) {
            ZimbraLog.misc.debug((Object)"ignoring exception while closing reader", e);
        }
    }

    public static int indexOf(byte[] source, int offset, byte[] target) {
        int slen = source.length;
        int tlen = target.length;
        int max = offset + (slen - tlen);
        byte first = target[0];
        for (int i = offset; i <= max; ++i) {
            if (source[i] != first) continue;
            boolean match = true;
            for (int j = 1; match && j < tlen; ++j) {
                match = source[i + j] == target[j];
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    public static boolean isASCII(byte[] data) {
        if (data == null) {
            return false;
        }
        for (int i = 0; i < data.length; ++i) {
            byte c = data[i];
            if ((c >= 32 || c == 9 || c == 10 || c == 13) && c < 127) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] data) throws IOException {
        ByteArrayOutputStream baos = null;
        DeflaterOutputStream gos = null;
        try {
            baos = new ByteArrayOutputStream(data.length);
            gos = new GZIPOutputStream(baos);
            gos.write(data);
            ((GZIPOutputStream)gos).finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (gos != null) {
                gos.close();
            } else if (baos != null) {
                baos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uncompress(byte[] data) throws IOException {
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        GZIPInputStream gis = null;
        try {
            int numRead;
            int estimatedResultSize = data.length * 3;
            baos = new ByteArrayOutputStream(estimatedResultSize);
            bais = new ByteArrayInputStream(data);
            byte[] buffer = new byte[8192];
            gis = new GZIPInputStream(bais);
            while ((numRead = gis.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, numRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (gis != null) {
                gis.close();
            } else if (bais != null) {
                bais.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    public static boolean isGzipped(byte[] data) {
        if (data == null || data.length < 2) {
            return false;
        }
        byte byte1 = data[0];
        int byte2 = data[1] & 0xFF;
        return (byte1 | byte2 << 8) == 35615;
    }

    public static boolean isGzipped(InputStream in) throws IOException {
        in.mark(2);
        int header = in.read() | in.read() << 8;
        in.reset();
        return header == 35615;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDataLength(InputStream in) throws IOException {
        byte[] buf = new byte[8192];
        int dataLength = 0;
        int bytesRead = 0;
        try {
            while ((bytesRead = in.read(buf)) >= 0) {
                dataLength += bytesRead;
            }
        }
        finally {
            ByteUtil.closeStream(in);
        }
        return dataLength;
    }

    public static String encodeFSSafeBase64(byte[] data) {
        byte[] encoded = Base64.encodeBase64((byte[])data);
        for (int i = 0; i < encoded.length; ++i) {
            if (encoded[i] != 47) continue;
            encoded[i] = 44;
        }
        return new String(encoded);
    }

    private static byte[] decodeFSSafeBase64(String str) {
        byte[] bytes = str.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 44) continue;
            bytes[i] = 47;
        }
        return Base64.decodeBase64((byte[])bytes);
    }

    public static String getSHA1Digest(byte[] data, boolean base64) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] digest = md.digest(data);
            if (base64) {
                return ByteUtil.encodeFSSafeBase64(digest);
            }
            return new String(Hex.encodeHex((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSHA1Digest(InputStream in, boolean base64) throws IOException {
        try {
            int numBytes;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] buffer = new byte[1024];
            while ((numBytes = in.read(buffer)) >= 0) {
                md.update(buffer, 0, numBytes);
            }
            byte[] digest = md.digest();
            if (base64) {
                String string = ByteUtil.encodeFSSafeBase64(digest);
                return string;
            }
            String string = new String(Hex.encodeHex((byte[])digest));
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        finally {
            ByteUtil.closeStream(in);
        }
    }

    public static String getMD5Digest(byte[] data, boolean base64) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(data);
            if (base64) {
                return ByteUtil.encodeFSSafeBase64(digest);
            }
            return new String(Hex.encodeHex((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDigest(byte[] data) {
        return ByteUtil.getSHA1Digest(data, true);
    }

    public static byte[] getBinaryDigest(String digest) {
        return ByteUtil.decodeFSSafeBase64(digest);
    }

    public static boolean isValidDigest(String digest) {
        byte[] bin;
        if (digest != null && (bin = ByteUtil.decodeFSSafeBase64(digest)) != null) {
            String str = ByteUtil.encodeFSSafeBase64(bin);
            return digest.equals(str);
        }
        return false;
    }

    public static long skip(InputStream is, long n) throws IOException {
        long remaining;
        int nr;
        if (n <= 0L) {
            return 0L;
        }
        if (skipBuffer == null) {
            skipBuffer = new byte[4096];
        }
        byte[] localSkipBuffer = skipBuffer;
        for (remaining = n; remaining > 0L && (nr = is.read(localSkipBuffer, 0, (int)Math.min(4096L, remaining))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    public static long copy(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        return ByteUtil.copy(in, closeIn, out, closeOut, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, boolean closeIn, OutputStream out, boolean closeOut, long maxLength) throws IOException {
        try {
            long transferred = 0L;
            if (maxLength != 0L) {
                int numRead;
                byte[] buffer = new byte[8192];
                do {
                    int readMax = buffer.length;
                    if (maxLength > 0L && maxLength - transferred < (long)readMax) {
                        readMax = (int)(maxLength - transferred);
                    }
                    if ((numRead = in.read(buffer, 0, readMax)) < 0) break;
                    out.write(buffer, 0, numRead);
                } while (maxLength < 0L || (transferred += (long)numRead) < maxLength);
            }
            long l = transferred;
            return l;
        }
        finally {
            if (closeIn) {
                ByteUtil.closeStream(in);
            }
            if (closeOut) {
                ByteUtil.closeStream(out);
            }
        }
    }

    public static byte[] readInput(InputStream in, int sizeHint, int limit) throws IOException {
        int numRead;
        int numToRead;
        int oneMoreByte;
        if (limit <= 0) {
            return new byte[0];
        }
        if (sizeHint > limit) {
            sizeHint = limit;
        }
        byte[] data = null;
        int bytesRead = 0;
        if (sizeHint > 0) {
            int numRead2;
            int numToRead2;
            data = new byte[sizeHint];
            while ((numToRead2 = data.length - bytesRead) > 0 && (numRead2 = in.read(data, bytesRead, numToRead2)) >= 0) {
                bytesRead += numRead2;
            }
            if (bytesRead >= limit) {
                return data;
            }
            if (bytesRead < data.length) {
                byte[] truncated = new byte[bytesRead];
                System.arraycopy(data, 0, truncated, 0, bytesRead);
                return truncated;
            }
        }
        if ((oneMoreByte = in.read()) < 0) {
            if (data == null) {
                return new byte[0];
            }
            return data;
        }
        ++bytesRead;
        ByteArrayOutputStream buf = null;
        if (data != null) {
            buf = new ByteArrayOutputStream(data.length * 2);
            buf.write(data);
        } else {
            buf = new ByteArrayOutputStream(1024);
        }
        buf.write((byte)oneMoreByte);
        byte[] chunk = new byte[1024];
        while ((numToRead = Math.min(limit - bytesRead, chunk.length)) > 0 && (numRead = in.read(chunk, 0, numToRead)) >= 0) {
            buf.write(chunk, 0, numRead);
            bytesRead += numRead;
        }
        return buf.toByteArray();
    }

    public static void writeUTF8(DataOutput out, String str) throws IOException {
        if (str == null) {
            out.writeInt(-1);
            return;
        }
        int len = str.length();
        if (len > 0x2000000) {
            throw new IOException("String length " + len + " is too long in ByteUtil.writeUTF8(); max=" + 0x2000000);
        }
        if (len > 0) {
            byte[] buf = str.getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        } else {
            out.writeInt(0);
        }
    }

    public static String readUTF8(DataInput in) throws IOException {
        int len = in.readInt();
        if (len > 0x2000000) {
            throw new IOException("String length " + len + " is too long in ByteUtil.writeUTF8(); max=" + 0x2000000);
        }
        if (len > 0) {
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
            return new String(buf, "UTF-8");
        }
        if (len == 0) {
            return "";
        }
        if (len == -1) {
            return null;
        }
        throw new IOException("Invalid length " + len + " in ByteUtil.readUTF8()");
    }

    public static class SegmentInputStream
    extends PositionInputStream {
        private final long mLimit;

        public static SegmentInputStream create(InputStream is, long start, long end) throws IOException {
            long numSkipped;
            if (start > 0L && (numSkipped = is.skip(start)) != start) {
                throw new IOException("Attempted to skip " + start + " bytes, actually skipped " + numSkipped);
            }
            return new SegmentInputStream(is, Math.max(0L, end - start));
        }

        public SegmentInputStream(InputStream is, long limit) {
            super(is);
            this.mLimit = limit;
        }

        private long actualAvailable() {
            return this.mLimit - this.getPosition();
        }

        public int available() {
            return (int)Math.min(this.actualAvailable(), Integer.MAX_VALUE);
        }

        public int read() throws IOException {
            return this.available() <= 0 ? -1 : super.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.available() <= 0 ? -1 : super.read(b, off, Math.min(len, this.available()));
        }

        public long skip(long n) throws IOException {
            return super.skip(Math.max(Math.min(n, this.actualAvailable()), 0L));
        }
    }

    public static class PositionInputStream
    extends FilterInputStream {
        private long position = 0L;
        private long mark = 0L;

        public PositionInputStream(InputStream is) {
            super(is);
        }

        public int read() throws IOException {
            int c = super.read();
            if (c != -1) {
                ++this.position;
            }
            return c;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int count = super.read(b, off, len);
            this.position += (long)count;
            return count;
        }

        public synchronized void mark(int readlimit) {
            super.mark(readlimit);
            this.mark = this.position;
        }

        public synchronized void reset() throws IOException {
            super.reset();
            this.position = this.mark;
        }

        public long skip(long n) throws IOException {
            long delta = super.skip(n);
            this.position += delta;
            return delta;
        }

        public long getPosition() {
            return this.position;
        }
    }

    public static class TeeOutputStream
    extends OutputStream {
        private OutputStream stream1;
        private OutputStream stream2;

        public TeeOutputStream(OutputStream one, OutputStream two) {
            if (one == two) {
                two = null;
            }
            this.stream1 = one;
            this.stream2 = two;
        }

        public void write(int b) throws IOException {
            if (this.stream1 != null) {
                this.stream1.write(b);
            }
            if (this.stream2 != null) {
                this.stream2.write(b);
            }
        }

        public void flush() throws IOException {
            if (this.stream1 != null) {
                this.stream1.flush();
            }
            if (this.stream2 != null) {
                this.stream2.flush();
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.stream1 != null) {
                this.stream1.write(b, off, len);
            }
            if (this.stream2 != null) {
                this.stream2.write(b, off, len);
            }
        }
    }
}

