/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import com.zimbra.common.localconfig.LC;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class BufferStream
extends OutputStream {
    private byte[] buf = null;
    private File file = null;
    private FileOutputStream fos = null;
    private int maxMem;
    private long maxSize;
    private boolean sequenced = true;
    private long size = 0L;

    public BufferStream() {
        this(0L);
    }

    public BufferStream(long sizeHint) {
        this(sizeHint, Integer.MAX_VALUE);
    }

    public BufferStream(long sizeHint, int maxMem) {
        this(sizeHint, maxMem, Long.MAX_VALUE);
    }

    public BufferStream(long sizeHint, int maxMem, long maxSize) {
        if ((long)maxMem > maxSize) {
            maxMem = (int)maxSize;
        }
        this.maxMem = maxMem;
        this.maxSize = maxSize;
        if (sizeHint > 0L) {
            this.buf = new byte[(int)Math.min(sizeHint, (long)maxMem)];
        }
    }

    private int buffer(int len) {
        if (this.buf == null) {
            if (this.maxMem == 0) {
                return 0;
            }
            this.buf = new byte[Math.min(this.maxMem, Math.max(len, 2048))];
            return this.buf.length;
        }
        if ((long)len <= (long)this.buf.length - this.size) {
            return (int)((long)this.buf.length - this.size);
        }
        if (this.buf.length < this.maxMem) {
            long tot = this.size + (long)len;
            if (tot < (long)(this.buf.length << 1)) {
                tot = Math.min(this.buf.length << 1, this.maxMem);
            }
            byte[] newBuf = new byte[(int)tot];
            System.arraycopy(this.buf, 0, newBuf, 0, (int)this.size);
            this.buf = newBuf;
            return (int)((long)this.buf.length - this.size);
        }
        return 0;
    }

    public void close() {
        this.release();
        this.buf = null;
        this.maxMem = 0;
        this.maxSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(OutputStream os) throws IOException {
        if (this.buf != null) {
            os.write(this.buf, 0, this.size <= (long)this.buf.length ? (int)this.size : this.buf.length);
        }
        if (this.file != null) {
            byte[] tmp = new byte[32768];
            FileInputStream fis = new FileInputStream(this.file);
            try {
                int in;
                while ((in = fis.read(tmp)) != -1) {
                    os.write(tmp, 0, in);
                }
            }
            finally {
                fis.close();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public byte[] getBuffer() {
        try {
            this.sync();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.buf != null && (long)this.buf.length > this.size) {
            byte[] newBuf = new byte[(int)this.size];
            System.arraycopy(this.buf, 0, newBuf, 0, (int)this.size);
            this.buf = newBuf;
        }
        return this.buf;
    }

    public File getFile() throws IOException {
        this.sync();
        return this.file;
    }

    public InputStream getInputStream() throws IOException {
        this.sync();
        if (this.size > this.maxSize) {
            throw new EOFException("data exceeds copy capacity");
        }
        if (this.buf == null) {
            return this.file == null ? new ByteArrayInputStream(new byte[0]) : new FileInputStream(this.file);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.buf, 0, (int)Math.min((long)this.buf.length, this.size));
        return this.file == null ? in : new SequenceInputStream(in, new FileInputStream(this.file));
    }

    public int getMaxMem() {
        return this.maxMem;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public byte[] getRawBuffer() {
        try {
            this.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buf;
    }

    public long getSize() {
        try {
            this.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.size;
    }

    public boolean isPartial() {
        return this.size > (long)this.maxMem && this.file == null;
    }

    public boolean isSequenced() {
        return this.sequenced;
    }

    public boolean isSpooled() {
        return this.file != null;
    }

    public static BufferStream newFixedBufferStream(int len) {
        return new BufferStream(len, len, len);
    }

    public long readFrom(InputStream is) throws IOException {
        return this.readFrom(is, Long.MAX_VALUE);
    }

    public long readFrom(InputStream is, long len) throws IOException {
        int in;
        int left = this.buffer(len == Long.MAX_VALUE ? 0 : (int)Math.min(Integer.MAX_VALUE, len));
        long out = 0L;
        while (len > 0L && left > 0) {
            in = is.read(this.buf, (int)this.size, left);
            if (in == -1) {
                return out;
            }
            left -= in;
            len -= (long)in;
            out += (long)in;
            this.size += (long)in;
        }
        if (len == 0L) {
            return out;
        }
        if (is.available() == 0) {
            in = is.read();
            if (in == -1) {
                return out;
            }
            this.write(in);
            --len;
        }
        while (len > 0L && (left = this.buffer((int)Math.min(len, 8192L))) > 0) {
            in = is.read(this.buf, (int)this.size, (int)Math.min(len, (long)left));
            if (in == -1) {
                return out;
            }
            out += (long)in;
            this.size += (long)in;
            len -= (long)in;
        }
        if (len == 0L) {
            return out;
        }
        byte[] tmp = new byte[(int)Math.min(len, 32768L)];
        while (len > 0L) {
            in = is.read(tmp, 0, (int)Math.min(len, (long)tmp.length));
            if (in == -1) {
                return out;
            }
            this.write(tmp, 0, in);
            out += (long)in;
            len -= (long)in;
        }
        return out;
    }

    public void release() {
        if (this.file != null) {
            try {
                this.fos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fos = null;
            if (!this.file.delete()) {
                this.file.deleteOnExit();
            }
            this.file = null;
            this.maxSize = this.maxMem;
        }
    }

    public void reset() {
        try {
            this.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.release();
        this.size = 0L;
    }

    public void setSequenced(boolean sequenced) {
        this.sequenced = sequenced;
    }

    public long size() {
        return this.getSize();
    }

    protected boolean spool(int len) {
        if (this.size + (long)len > this.maxSize) {
            this.release();
            return false;
        }
        if (this.file == null) {
            try {
                this.file = File.createTempFile("cstrm", null, new File(LC.zimbra_tmp_directory.value()));
                this.fos = new FileOutputStream(this.file);
                if (!this.sequenced) {
                    this.fos.write(this.buf);
                    this.buf = null;
                    this.maxMem = 0;
                }
            }
            catch (IOException e) {
                this.file = null;
                this.maxSize = this.maxMem;
                return false;
            }
        }
        return true;
    }

    public void sync() throws IOException {
        if (this.file != null) {
            try {
                this.fos.flush();
            }
            catch (IOException e) {
                this.release();
                throw e;
            }
        }
    }

    public byte[] toByteArray() {
        try {
            this.sync();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.size <= (long)this.maxMem) {
            byte[] tmp = this.getBuffer();
            return tmp == null ? new byte[]{} : tmp;
        }
        if (this.file == null || this.size > Integer.MAX_VALUE) {
            throw new RuntimeException("BufferStream overflow");
        }
        byte[] newBuf = new byte[(int)this.size];
        FileInputStream fis = null;
        System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
        try {
            int in;
            fis = new FileInputStream(this.file);
            for (int left = (int)(this.size - (long)this.buf.length); left > 0; left -= in) {
                in = fis.read(newBuf, this.buf.length, left);
                if (in != -1) continue;
                throw new RuntimeException("BufferStream truncated");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("BufferStream lost");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return newBuf;
    }

    public ByteBuffer toByteBuffer() {
        try {
            this.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.size == 0L) {
            return ByteBuffer.allocate(0);
        }
        if (this.size <= (long)this.maxMem) {
            return ByteBuffer.wrap(this.buf, 0, (int)this.size);
        }
        return ByteBuffer.wrap(this.toByteArray());
    }

    public String toString() {
        try {
            return this.toString(Charset.defaultCharset().toString());
        }
        catch (Exception e) {
            return new String(this.buf);
        }
    }

    public String toString(String cset) throws IOException, UnsupportedEncodingException {
        this.sync();
        if (this.buf == null) {
            return new String();
        }
        if (this.file == null) {
            return new String(this.buf, 0, (int)this.size, cset);
        }
        throw new IOException("BufferStream data too large");
    }

    public void truncate(long len) throws IOException {
        this.sync();
        if (len > this.size) {
            throw new IOException("BufferStream expansion");
        }
        if (this.file != null) {
            if (len > (long)this.maxMem) {
                this.fos.getChannel().truncate(len - (long)this.maxMem);
            } else {
                this.release();
            }
        }
        this.size = len;
    }

    public void write(int data) {
        if (this.buffer(1) > 0) {
            this.buf[(int)this.size] = (byte)data;
        } else if (this.spool(1)) {
            try {
                this.fos.write(data);
            }
            catch (Exception e) {
                this.maxSize = this.size;
                this.release();
            }
        }
        ++this.size;
    }

    public void write(byte[] data, int off, int len) {
        int left = this.buffer(len);
        if (left > 0) {
            if (left > len) {
                left = len;
            }
            System.arraycopy(data, off, this.buf, (int)this.size, left);
            len -= left;
            this.size += (long)left;
        }
        if (len > 0) {
            if (this.spool(len)) {
                try {
                    this.fos.write(data, off, len);
                }
                catch (IOException e) {
                    this.maxSize = this.size;
                    this.release();
                }
            }
            this.size += (long)len;
        }
    }

    public long writeTo(OutputStream os) throws IOException {
        return this.writeTo(os, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(OutputStream os, long len) throws IOException {
        int in;
        long out = 0L;
        this.sync();
        if (len == Long.MAX_VALUE) {
            len = this.size;
        } else if (len > this.size) {
            throw new IOException("BufferStream underflow");
        }
        if (this.buf != null) {
            in = (int)Math.min(Math.min(this.size, len), (long)this.buf.length);
            os.write(this.buf, 0, in);
            len -= (long)in;
            out = in;
        }
        if (len == 0L) {
            return out;
        }
        FileInputStream fis = null;
        byte[] tmp = new byte[(int)Math.min(len, 32768L)];
        try {
            fis = new FileInputStream(this.file);
            while (len > 0L && (in = fis.read(tmp, 0, (int)Math.min(len, (long)tmp.length))) != -1) {
                os.write(tmp, 0, in);
                len -= (long)in;
                out += (long)in;
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return out;
    }
}

