/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BigByteBuffer
extends OutputStream {
    private static final int DEFAULT_MAX_MEM_BUF_SIZE = 0x100000;
    private static final int STREAM_CHUNK_SIZE = 8192;
    private final int maxMemBufSize;
    private ByteArrayOutputStream bao;
    private int bufSize;
    private File bufFile;
    private OutputStream bufFileOut;
    private boolean isWritingDone;
    private boolean isDestroyed;

    public BigByteBuffer() {
        this(0x100000);
    }

    public BigByteBuffer(int maxMemBufSize) {
        this.maxMemBufSize = maxMemBufSize;
        this.bao = new ByteArrayOutputStream();
    }

    public void doneWriting() throws IOException {
        if (!this.isWritingDone) {
            if (this.bufFileOut != null) {
                this.bufFileOut.close();
                this.bufFileOut = null;
            }
            this.isWritingDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        try {
            this.doneWriting();
        }
        finally {
            this.isDestroyed = true;
            if (this.bufFile != null) {
                this.bufFile.delete();
                this.bufFile = null;
            }
        }
    }

    public int length() {
        return this.bufSize;
    }

    public void write(int b) throws IOException {
        if (this.isWritingDone) {
            throw new IllegalStateException("no more writing");
        }
        if (this.bufSize < this.maxMemBufSize) {
            this.bao.write(b);
        } else {
            try {
                if (this.bufFileOut == null) {
                    this.bufFile = File.createTempFile("BigByteBuffer", null);
                    this.bufFileOut = new BufferedOutputStream(new FileOutputStream(this.bufFile), 8192);
                }
                this.bufFileOut.write(b);
            }
            catch (IOException x) {
                this.destroy();
            }
        }
        ++this.bufSize;
    }

    public void close() throws IOException {
        this.doneWriting();
        super.close();
    }

    public void flush() throws IOException {
        if (this.isWritingDone) {
            throw new IllegalStateException("no more writing");
        }
        if (this.bufFileOut != null) {
            this.bufFileOut.flush();
        }
        super.flush();
    }

    public InputStream getInputStream() throws IOException {
        return new InputStream(){
            byte[] memBuf;
            private int offset;
            private InputStream bufFileIn;
            private boolean isClosed;
            {
                this.memBuf = BigByteBuffer.this.bao.toByteArray();
            }

            public int read() throws IOException {
                if (!BigByteBuffer.this.isWritingDone) {
                    throw new IllegalStateException("must finish writing before reading");
                }
                if (BigByteBuffer.this.isDestroyed) {
                    throw new IllegalStateException("already destroyed");
                }
                if (this.isClosed) {
                    throw new IllegalStateException("already closed");
                }
                if (this.offset >= BigByteBuffer.this.bufSize) {
                    return -1;
                }
                int b = 0;
                if (this.offset < this.memBuf.length) {
                    b = this.memBuf[this.offset] & 0xFF;
                } else {
                    try {
                        if (this.bufFileIn == null) {
                            assert (BigByteBuffer.this.bufFile != null);
                            this.bufFileIn = new BufferedInputStream(new FileInputStream(BigByteBuffer.this.bufFile), 8192);
                        }
                        b = this.bufFileIn.read();
                    }
                    catch (IOException x) {
                        this.close();
                    }
                }
                ++this.offset;
                return b;
            }

            public int available() throws IOException {
                return BigByteBuffer.this.bufSize - this.offset;
            }

            public void close() throws IOException {
                this.isClosed = true;
                if (this.bufFileIn != null) {
                    this.bufFileIn.close();
                    this.bufFileIn = null;
                }
                super.close();
            }
        };
    }

    public static void main(String[] args) throws IOException {
        BigByteBuffer.test(new BigByteBuffer(4));
        BigByteBuffer.test(new BigByteBuffer(8));
        BigByteBuffer.test(new BigByteBuffer(16));
        BigByteBuffer.testBig();
    }

    private static void test(BigByteBuffer bbb) throws IOException {
        bbb.write(new byte[]{1, 2}, 0, 2);
        assert (bbb.length() == 2);
        bbb.write(new byte[]{3, 4, 5, 6, 7, 8}, 0, 6);
        assert (bbb.length() == 8);
        try {
            bbb.getInputStream().read();
            assert (false);
        }
        catch (IllegalStateException x) {
            System.out.println("pass write");
        }
        bbb.doneWriting();
        InputStream in = bbb.getInputStream();
        assert (in.read() == 1);
        assert (in.read() == 2);
        assert (in.read() == 3);
        assert (in.read() == 4);
        assert (in.read() == 5);
        assert (in.read() == 6);
        assert (in.read() == 7);
        assert (in.read() == 8);
        assert (in.read() == -1);
        in.close();
        try {
            in.read();
            assert (false);
        }
        catch (IllegalStateException x) {
            System.out.println("pass read");
        }
        bbb.destroy();
    }

    private static void testBig() throws IOException {
        BigByteBuffer bbb = new BigByteBuffer();
        for (int i = 0; i < 0x200000; ++i) {
            bbb.write((byte)(i & 0xFF));
        }
        bbb.doneWriting();
        assert (bbb.length() == 0x200000);
        InputStream in = bbb.getInputStream();
        for (int i = 0; i < 0x200000; ++i) {
            assert ((byte)in.read() == (byte)(i & 0xFF));
        }
        assert (in.read() == -1);
        bbb.destroy();
        System.out.println("big pass");
    }
}

