/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class BEncoding {
    public static String encode(Map object) {
        return BEncoding.encode(new StringBuffer(), object).toString();
    }

    public static String encode(List object) {
        return BEncoding.encode(new StringBuffer(), object).toString();
    }

    public static Object decode(String data) throws BEncodingException {
        if (data == null) {
            return null;
        }
        try {
            Offset offset = new Offset();
            Object result = BEncoding.decode(data.toCharArray(), offset);
            if (offset.offset != data.length()) {
                throw new BEncodingException("extra characters at end of encoded string");
            }
            return result;
        }
        catch (BEncodingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BEncodingException(e);
        }
    }

    private static StringBuffer encode(StringBuffer sb, Object object) {
        if (object instanceof Map) {
            SortedMap tree = object instanceof SortedMap ? (SortedMap)object : new TreeMap((Map)object);
            sb.append('d');
            if (!tree.isEmpty()) {
                for (Map.Entry entry : tree.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    BEncoding.encode(sb, entry.getKey().toString());
                    BEncoding.encode(sb, entry.getValue());
                }
            }
            sb.append('e');
        } else if (object instanceof List) {
            sb.append('l');
            for (Object value : (List)object) {
                if (value == null) continue;
                BEncoding.encode(sb, value);
            }
            sb.append('e');
        } else if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            sb.append('i').append(object).append('e');
        } else if (object != null) {
            String value = object.toString();
            sb.append(value.length()).append(':').append(value);
        }
        return sb;
    }

    private static Object decode(char[] buffer, Offset offset) throws BEncodingException {
        char c = buffer[offset.offset++];
        switch (c) {
            case 'd': {
                Object key;
                HashMap<String, Object> map = new HashMap<String, Object>();
                while ((key = BEncoding.decode(buffer, offset)) != null) {
                    Object value = BEncoding.decode(buffer, offset);
                    if (value == null) {
                        throw new BEncodingException("missing dictionary value for key " + key.toString());
                    }
                    map.put(key.toString(), value);
                }
                return map;
            }
            case 'l': {
                Object key;
                ArrayList<Object> list = new ArrayList<Object>();
                while ((key = BEncoding.decode(buffer, offset)) != null) {
                    list.add(key);
                }
                return list;
            }
            case 'e': {
                return null;
            }
            case 'i': {
                return new Long(BEncoding.readLong(buffer, offset, 'e'));
            }
        }
        --offset.offset;
        long length = BEncoding.readLong(buffer, offset, ':');
        int start = offset.offset;
        offset.offset = (int)((long)offset.offset + length);
        return new String(buffer, start, (int)length);
    }

    private static long readLong(char[] buffer, Offset offset, char terminator) {
        int start = offset.offset;
        while (buffer[offset.offset++] != terminator) {
        }
        return Long.parseLong(new String(buffer, start, offset.offset - start - 1));
    }

    public static void main(String[] args) throws BEncodingException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(654));
        list.add("hwhergk");
        list.add(new StringBuffer("74x"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testing", new Long(5L));
        map.put("foo2", "bar");
        map.put("herp", list);
        map.put("Foo", new Float(6.7));
        map.put("yy", new TreeMap());
        String encoded = BEncoding.encode(map);
        System.out.println(encoded);
        System.out.println(BEncoding.decode(encoded));
    }

    private static final class Offset {
        int offset;

        private Offset() {
        }
    }

    public static final class BEncodingException
    extends Exception {
        BEncodingException(String msg) {
            super(msg);
        }

        BEncodingException(Exception e) {
            super(e);
        }
    }
}

