/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.util;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    public static <A> A[] reverse(A[] array) {
        if (array != null && array.length > 1) {
            int length = array.length;
            for (int i = 0; i < length / 2; ++i) {
                A temp = array[i];
                array[i] = array[length - i - 1];
                array[length - i - 1] = temp;
            }
        }
        return array;
    }

    public static int[] reverse(int[] array) {
        if (array != null && array.length > 1) {
            int length = array.length;
            for (int i = 0; i < length / 2; ++i) {
                int temp = array[i];
                array[i] = array[length - i - 1];
                array[length - i - 1] = temp;
            }
        }
        return array;
    }

    public static byte[] reverse(byte[] array) {
        if (array != null && array.length > 1) {
            int length = array.length;
            for (int i = 0; i < length / 2; ++i) {
                byte temp = array[i];
                array[i] = array[length - i - 1];
                array[length - i - 1] = temp;
            }
        }
        return array;
    }

    public static char[] reverse(char[] array) {
        if (array != null && array.length > 1) {
            int length = array.length;
            for (int i = 0; i < length / 2; ++i) {
                char temp = array[i];
                array[i] = array[length - i - 1];
                array[length - i - 1] = temp;
            }
        }
        return array;
    }

    public static byte[] toByteArray(Collection<Byte> c) {
        int pos = 0;
        byte[] byteArray = new byte[c.size()];
        for (Byte id : c) {
            byteArray[pos++] = id;
        }
        return byteArray;
    }

    public static int[] toIntArray(Collection<Integer> c) {
        int[] intArray = new int[c.size()];
        int pos = 0;
        for (Integer id : c) {
            intArray[pos++] = id;
        }
        return intArray;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public boolean byteArrayContains(byte[] array, byte val) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != val) continue;
            return true;
        }
        return false;
    }

    public byte[] combineByteArraysNoDups(byte[] a1, byte[] a2) {
        byte[] tmp = new byte[a2.length];
        int tmpOff = 0;
        for (int i = a2.length - 1; i >= 0; --i) {
            if (this.byteArrayContains(a1, a2[i])) continue;
            tmp[tmpOff++] = a2[i];
        }
        byte[] toRet = new byte[tmpOff + a1.length];
        System.arraycopy(tmp, 0, toRet, 0, tmpOff);
        System.arraycopy(a1, 0, toRet, tmpOff, a1.length);
        return toRet;
    }

    public byte[] addToByteArrayNoDup(byte[] array, byte val) {
        if (!this.byteArrayContains(array, val)) {
            byte[] toRet = new byte[array.length + 1];
            System.arraycopy(array, 0, toRet, 0, array.length);
            toRet[toRet.length - 1] = val;
            return toRet;
        }
        return array;
    }

    public byte[] intersectByteArrays(byte[] a1, byte[] a2) {
        int i;
        byte[] tmp = new byte[a1.length + a2.length];
        int tmpOff = 0;
        for (int i2 = a1.length - 1; i2 >= 0; --i2) {
            if (!this.byteArrayContains(a2, a1[i2])) continue;
            tmp[tmpOff++] = a1[i2];
        }
        byte[] toRet = new byte[tmpOff];
        for (i = 0; i < tmpOff; ++i) {
            toRet[i] = tmp[i];
        }
        for (i = toRet.length - 1; i >= 0; --i) {
            assert (this.byteArrayContains(a1, toRet[i]) && this.byteArrayContains(a2, toRet[i]));
        }
        return toRet;
    }
}

