/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.stats;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.stats.StatUtil;
import com.zimbra.common.stats.StatsDumperDataSource;
import com.zimbra.common.util.FileUtil;
import com.zimbra.common.util.ZimbraLog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsDumper
implements Callable<Void> {
    public static final int SYSLOG_ELIDING_THRESHOLD = 800;
    private static final File STATS_DIR = new File(LC.zmstat_log_directory.value());
    private static final ThreadGroup statsGroup = new ThreadGroup("ZimbraPerf Stats");
    private StatsDumperDataSource mDataSource;
    private Calendar mLastRollover = Calendar.getInstance();

    private StatsDumper(StatsDumperDataSource dataSource) {
        this.mDataSource = dataSource;
    }

    private File getFile() throws IOException {
        FileUtil.ensureDirExists(STATS_DIR);
        return new File(STATS_DIR, this.mDataSource.getFilename());
    }

    private File getArchiveDir() throws IOException {
        String dirName = String.format("%1$tY-%1$tm-%1$td", this.mLastRollover);
        File dir = new File(STATS_DIR, dirName);
        FileUtil.ensureDirExists(dir);
        return dir;
    }

    public static void schedule(final StatsDumperDataSource dataSource, final long intervalMillis) {
        final StatsDumper dumper = new StatsDumper(dataSource);
        Runnable r = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(intervalMillis);
                        try {
                            dumper.call();
                        }
                        catch (Exception e) {
                            ZimbraLog.perf.warn("Exception in stats thread: %s", (Object)dataSource.getFilename(), e);
                        }
                    }
                    catch (InterruptedException e) {
                        ZimbraLog.perf.info("Stats thread interrupted: %s", (Object)dataSource.getFilename(), e);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    ZimbraLog.perf.info("Stats thread was interrupted: %s", dataSource.getFilename());
                }
            }
        };
        new Thread(statsGroup, r, dataSource.getFilename()).start();
    }

    private void rollover() throws IOException {
        File sourceFile = this.getFile();
        File archiveDir = this.getArchiveDir();
        File archiveFile = new File(archiveDir, this.mDataSource.getFilename() + ".gz");
        FileUtil.compress(sourceFile, archiveFile, true);
        sourceFile.delete();
    }

    @Override
    public Void call() throws Exception {
        Collection<String> lines = this.mDataSource.getDataLines();
        if (lines == null || lines.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String timestamp = StatUtil.getTimestampString();
        for (String line : lines) {
            if (this.mDataSource.hasTimestampColumn()) {
                buf.append(timestamp).append(",");
            }
            buf.append(line).append("\n");
        }
        File file = this.getFile();
        Calendar now = Calendar.getInstance();
        if (file.exists() && now.get(6) != this.mLastRollover.get(6)) {
            this.rollover();
            this.mLastRollover = now;
        }
        boolean writeHeader = false;
        if (!file.exists()) {
            writeHeader = true;
        }
        FileWriter writer = new FileWriter(file, true);
        String header = this.mDataSource.getHeader();
        if (writeHeader) {
            if (this.mDataSource.hasTimestampColumn()) {
                writer.write("timestamp,");
            }
            writer.write(header);
            writer.write("\n");
        }
        writer.write(buf.toString());
        writer.close();
        for (String line : lines) {
            String logLine = this.mDataSource.getFilename() + ": " + (this.mDataSource.hasTimestampColumn() ? "timestamp," : "") + header + ":: " + timestamp + "," + line;
            if (logLine.length() <= 800) {
                ZimbraLog.slogger.info(logLine);
                continue;
            }
            StringBuilder b = new StringBuilder(logLine);
            String lastUuid = null;
            do {
                String sub = b.substring(0, 800);
                b.delete(0, 800);
                if (lastUuid != null) {
                    sub = ":::" + lastUuid + ":::" + sub;
                }
                lastUuid = UUID.randomUUID().toString();
                ZimbraLog.slogger.info(sub + ":::" + lastUuid + ":::");
            } while (b.length() > 800);
            ZimbraLog.slogger.info(":::" + lastUuid + ":::" + b.toString());
        }
        return null;
    }
}

