/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.stats;

import com.zimbra.common.stats.Accumulator;
import com.zimbra.common.stats.RealtimeStatsCallback;
import com.zimbra.common.util.ArrayUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealtimeStats
implements Accumulator {
    private List<String> mNames;
    private List<RealtimeStatsCallback> mCallbacks = new ArrayList<RealtimeStatsCallback>();

    public RealtimeStats(String[] names) {
        if (ArrayUtil.isEmpty(names)) {
            throw new IllegalArgumentException("names cannot be null or empty");
        }
        this.mNames = new ArrayList<String>();
        for (String name : names) {
            this.mNames.add(name);
        }
    }

    public void addName(String name) {
        this.mNames.add(name);
    }

    public void addCallback(RealtimeStatsCallback callback) {
        this.mCallbacks.add(callback);
    }

    @Override
    public List<String> getNames() {
        return this.mNames;
    }

    @Override
    public List<Object> getData() {
        ArrayList<Object> data = new ArrayList<Object>();
        HashMap<String, Object> callbackResults = new HashMap<String, Object>();
        for (RealtimeStatsCallback callback : this.mCallbacks) {
            Map<String, Object> callbackData = callback.getStatData();
            if (callbackData == null) continue;
            callbackResults.putAll(callbackData);
        }
        for (String name : this.mNames) {
            data.add(callbackResults.remove(name));
        }
        if (callbackResults.size() > 0) {
            ZimbraLog.perf.warn("Detected unexpected realtime stats: " + StringUtil.join(", ", callbackResults.keySet()));
        }
        return data;
    }

    @Override
    public void reset() {
    }
}

