/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.stats;

import com.zimbra.common.stats.Accumulator;
import com.zimbra.common.stats.Counter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaCalculator
implements Accumulator {
    private Counter mCounter;
    private long mLastCount = 0L;
    private long mSecondToLastCount = 0L;
    private long mLastTotal = 0L;
    private long mSecondToLastTotal = 0L;
    private String mCountName;
    private String mTotalName;
    private String mAverageName;
    private String mRealtimeAverageName;
    private List<String> mNames;

    public DeltaCalculator(Counter counter) {
        this.mCounter = counter;
    }

    public DeltaCalculator setCountName(String name) {
        this.mCountName = name;
        this.updateNames();
        return this;
    }

    public DeltaCalculator setTotalName(String name) {
        this.mTotalName = name;
        this.updateNames();
        return this;
    }

    public DeltaCalculator setAverageName(String name) {
        this.mAverageName = name;
        this.updateNames();
        return this;
    }

    public DeltaCalculator setRealtimeAverageName(String name) {
        this.mRealtimeAverageName = name;
        this.updateNames();
        return this;
    }

    private void updateNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.mCountName != null) {
            names.add(this.mCountName);
        }
        if (this.mTotalName != null) {
            names.add(this.mTotalName);
        }
        if (this.mAverageName != null) {
            names.add(this.mAverageName);
        }
        if (this.mRealtimeAverageName != null) {
            names.add(this.mRealtimeAverageName);
        }
        this.mNames = Collections.unmodifiableList(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Counter counter = this.mCounter;
        synchronized (counter) {
            this.mSecondToLastCount = this.mLastCount;
            this.mSecondToLastTotal = this.mLastTotal;
            this.mLastCount = this.mCounter.getCount();
            this.mLastTotal = this.mCounter.getTotal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotal() {
        Counter counter = this.mCounter;
        synchronized (counter) {
            return this.mCounter.getTotal() - this.mLastTotal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        Counter counter = this.mCounter;
        synchronized (counter) {
            return this.mCounter.getCount() - this.mLastCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverage() {
        long count = 0L;
        long total = 0L;
        Counter counter = this.mCounter;
        synchronized (counter) {
            count = this.mCounter.getCount() - this.mLastCount;
            if (count == 0L) {
                return 0.0;
            }
            total = this.mCounter.getTotal() - this.mLastTotal;
        }
        return (double)total / (double)count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRealtimeAverage() {
        long count = 0L;
        long total = 0L;
        Counter counter = this.mCounter;
        synchronized (counter) {
            count = this.mCounter.getCount() - this.mSecondToLastCount;
            if (count == 0L) {
                return 0.0;
            }
            total = this.mCounter.getTotal() - this.mSecondToLastTotal;
        }
        return (double)total / (double)count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getData() {
        if (this.mNames == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> data = new ArrayList<Object>(this.mNames.size());
        Counter counter = this.mCounter;
        synchronized (counter) {
            if (this.mCountName != null) {
                data.add(this.getCount());
            }
            if (this.mTotalName != null) {
                data.add(this.getTotal());
            }
            if (this.mAverageName != null) {
                data.add(this.getAverage());
            }
        }
        return data;
    }

    @Override
    public List<String> getNames() {
        return this.mNames;
    }
}

