/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.stats;

public class Counter {
    private volatile long mCount = 0L;
    private volatile long mTotal = 0L;

    public long getCount() {
        return this.mCount;
    }

    public long getTotal() {
        return this.mTotal;
    }

    public synchronized double getAverage() {
        if (this.mCount == 0L) {
            return 0.0;
        }
        return (double)this.mTotal / (double)this.mCount;
    }

    public synchronized void increment(long value) {
        ++this.mCount;
        this.mTotal += value;
    }

    public synchronized void increment() {
        this.increment(1L);
    }

    public synchronized void reset() {
        this.mCount = 0L;
        this.mTotal = 0L;
    }
}

