/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.HeaderConstants;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.StringUtil;
import java.util.Arrays;

public class SoapUtil {
    public static Element toCtxt(SoapProtocol protocol, ZAuthToken authToken) {
        Element ctxt = protocol.getFactory().createElement(HeaderConstants.CONTEXT);
        if (authToken != null) {
            authToken.encodeSoapCtxt(ctxt);
        }
        return ctxt;
    }

    public static Element toCtxt(SoapProtocol protocol, ZAuthToken authToken, String sessionId, int sequence) {
        Element ctxt = SoapUtil.toCtxt(protocol, authToken);
        return SoapUtil.addSessionToCtxt(ctxt, authToken == null ? null : sessionId, sequence);
    }

    public static Element disableNotificationOnCtxt(Element ctxt) {
        if (ctxt == null) {
            return ctxt;
        }
        if (!ctxt.getName().equals("context")) {
            throw new IllegalArgumentException("Invalid element: " + ctxt.getName());
        }
        ctxt.addUniqueElement("nosession");
        return ctxt;
    }

    public static Element addSessionToCtxt(Element ctxt, String sessionId, long sequence) {
        if (ctxt == null) {
            return ctxt;
        }
        if (!ctxt.getName().equals("context")) {
            throw new IllegalArgumentException("Invalid element: " + ctxt.getName());
        }
        Element eSession = ctxt.addUniqueElement("session");
        if (sessionId != null && !sessionId.trim().equals("")) {
            for (Element elt : Arrays.asList(eSession, ctxt.addUniqueElement("sessionId"))) {
                elt.addAttribute("id", sessionId);
                if (sequence <= 0L) continue;
                elt.addAttribute("seq", sequence);
            }
        }
        return ctxt;
    }

    public static Element addTargetAccountToCtxt(Element ctxt, String targetAccountId, String targetAccountName) {
        String target;
        if (ctxt == null) {
            return ctxt;
        }
        if (!ctxt.getName().equals("context")) {
            throw new IllegalArgumentException("Invalid element: " + ctxt.getName());
        }
        String by = targetAccountId != null ? "id" : "name";
        String string = target = targetAccountId != null ? targetAccountId : targetAccountName;
        if (target != null && !target.trim().equals("")) {
            ctxt.addUniqueElement("account").addAttribute("by", by).setText(target);
        }
        return ctxt;
    }

    public static Element addUserAgentToCtxt(Element ctxt, String name, String version) {
        if (ctxt == null || StringUtil.isNullOrEmpty(name)) {
            return ctxt;
        }
        if (!ctxt.getName().equals("context")) {
            throw new IllegalArgumentException("Invalid element: " + ctxt.getName());
        }
        Element eUserAgent = ctxt.addUniqueElement("userAgent");
        eUserAgent.addAttribute("name", name);
        if (!StringUtil.isNullOrEmpty(version)) {
            eUserAgent.addAttribute("version", version);
        }
        return ctxt;
    }

    public static Element addChangeTokenToCtxt(Element ctxt, String token, String type) {
        if (ctxt == null || StringUtil.isNullOrEmpty(token)) {
            return ctxt;
        }
        if (!ctxt.getName().equalsIgnoreCase("context")) {
            throw new IllegalArgumentException("Invalid element: " + ctxt.getName());
        }
        Element eChange = ctxt.addUniqueElement("change");
        eChange.addAttribute("token", token);
        if (!StringUtil.isNullOrEmpty(type)) {
            eChange.addAttribute("type", type);
        }
        return ctxt;
    }

    public static Element addResponseProtocolToCtxt(Element ctxt, SoapProtocol proto) {
        if (ctxt == null) {
            return ctxt;
        }
        if (!ctxt.getName().equals("context")) {
            throw new IllegalArgumentException("Invalid element: " + ctxt.getName());
        }
        if (proto != null) {
            ctxt.addElement("format").addAttribute("type", proto == SoapProtocol.SoapJS ? "js" : "xml");
        }
        return ctxt;
    }
}

