/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.HeaderConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapParseException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.SoapUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.ElementHandler;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SoapTransport {
    private SoapProtocol mRequestProto = SoapProtocol.Soap12;
    private SoapProtocol mResponseProto;
    private boolean mPrettyPrint = false;
    private ZAuthToken mAuthToken;
    private String mTargetAcctId = null;
    private String mTargetAcctName = null;
    private String mSessionId = null;
    private String mClientIp = null;
    private long mMaxNotifySeq = -1L;
    private Element mContext = null;
    private String mUserAgentName;
    private String mUserAgentVersion;
    private DebugListener mDebugListener;
    private static String sDefaultUserAgentName = "ZCS";
    private static String sDefaultUserAgentVersion;

    protected SoapTransport() {
    }

    public void setDebugListener(DebugListener listener) {
        this.mDebugListener = listener;
    }

    public DebugListener getDebugListener() {
        return this.mDebugListener;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.mPrettyPrint = prettyPrint;
    }

    public boolean getPrettyPrint() {
        return this.mPrettyPrint;
    }

    public void setAuthToken(String authToken) {
        this.mAuthToken = new ZAuthToken(null, authToken, null);
    }

    public void setAuthToken(ZAuthToken authToken) {
        this.mAuthToken = authToken;
    }

    public ZAuthToken getAuthToken() {
        return this.mAuthToken;
    }

    public void setTargetAcctId(String acctId) {
        this.mTargetAcctId = acctId;
    }

    public String getTargetAcctId() {
        return this.mTargetAcctId;
    }

    public void setTargetAcctName(String acctName) {
        this.mTargetAcctName = acctName;
    }

    public Element getZimbraContext() {
        return this.mContext;
    }

    public void clearZimbraContext() {
        this.mContext = null;
    }

    public void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    public void setClientIp(String clientIp) {
        this.mClientIp = clientIp;
    }

    public String getClientIp() {
        return this.mClientIp;
    }

    public void setMaxNotifySeq(long seq) {
        this.mMaxNotifySeq = seq;
    }

    public long getMaxNotifySeq() {
        return this.mMaxNotifySeq;
    }

    public void setUserAgent(String name, String version) {
        this.mUserAgentName = name;
        this.mUserAgentVersion = version;
    }

    public static void setDefaultUserAgent(String defaultName, String defaultVersion) {
        sDefaultUserAgentName = defaultName;
        sDefaultUserAgentVersion = "unknown".equals(defaultVersion) ? null : defaultVersion;
    }

    public String getUserAgentName() {
        if (this.mUserAgentName != null) {
            return this.mUserAgentName;
        }
        return sDefaultUserAgentName;
    }

    public String getUserAgentVersion() {
        if (this.mUserAgentVersion != null) {
            return this.mUserAgentVersion;
        }
        return sDefaultUserAgentVersion;
    }

    public void setRequestProtocol(SoapProtocol proto) {
        if (proto != null) {
            this.mRequestProto = proto;
        }
    }

    public SoapProtocol getRequestProtocol() {
        return this.mRequestProto;
    }

    public void setResponseProtocol(SoapProtocol proto) {
        if (proto != null) {
            this.mResponseProto = proto;
        }
    }

    public SoapProtocol getResponseProtocol() {
        return this.mResponseProto == null ? this.mRequestProto : this.mResponseProto;
    }

    protected Element generateSoapMessage(Element document, boolean raw, boolean noSession, String requestedAccountId, String changeToken, String tokenType) {
        if (raw) {
            if (this.mDebugListener != null) {
                this.mDebugListener.sendSoapMessage(document);
            }
            return document;
        }
        SoapProtocol proto = this.mRequestProto;
        if (proto == SoapProtocol.SoapJS) {
            if (document instanceof Element.XMLElement) {
                proto = SoapProtocol.Soap12;
            }
        } else if (document instanceof Element.JSONElement) {
            proto = SoapProtocol.SoapJS;
        }
        SoapProtocol responseProto = this.mResponseProto == null ? proto : this.mResponseProto;
        String targetId = requestedAccountId != null ? requestedAccountId : this.mTargetAcctId;
        String targetName = targetId == null ? this.mTargetAcctName : null;
        Element context = SoapUtil.toCtxt(proto, this.mAuthToken);
        if (noSession) {
            SoapUtil.disableNotificationOnCtxt(context);
        } else {
            SoapUtil.addSessionToCtxt(context, this.mAuthToken == null ? null : this.mSessionId, this.mMaxNotifySeq);
        }
        SoapUtil.addTargetAccountToCtxt(context, targetId, targetName);
        SoapUtil.addChangeTokenToCtxt(context, changeToken, tokenType);
        if (this.mUserAgentName != null) {
            SoapUtil.addUserAgentToCtxt(context, this.mUserAgentName, this.mUserAgentVersion);
        }
        if (responseProto != proto) {
            SoapUtil.addResponseProtocolToCtxt(context, responseProto);
        }
        Element envelope = proto.soapEnvelope(document, context);
        if (this.mDebugListener != null) {
            this.mDebugListener.sendSoapMessage(envelope);
        }
        return envelope;
    }

    Element parseSoapResponse(String envelopeStr, boolean raw) throws SoapParseException, SoapFaultException {
        Element env;
        try {
            env = envelopeStr.trim().startsWith("<") ? Element.parseXML(envelopeStr) : Element.parseJSON(envelopeStr);
        }
        catch (DocumentException de) {
            throw new SoapParseException("unable to parse response", envelopeStr);
        }
        if (this.mDebugListener != null) {
            this.mDebugListener.receiveSoapMessage(env);
        }
        return raw ? env : this.extractBodyElement(env);
    }

    void parseLargeSoapResponse(Reader inputReader, Map<String, ElementHandler> handlers) throws SoapFaultException {
        SAXReader saxReader = Element.getSAXReader();
        for (Map.Entry<String, ElementHandler> entry : handlers.entrySet()) {
            saxReader.addHandler(entry.getKey(), entry.getValue());
        }
        try {
            saxReader.read(inputReader);
        }
        catch (DocumentException e) {
            throw new SoapFaultException(e.getMessage(), "soap.SAX_PARSE_ERROR", false, e.getCause());
        }
    }

    public Element extractBodyElement(Element env) throws SoapParseException, SoapFaultException {
        SoapProtocol proto = SoapProtocol.determineProtocol(env);
        if (proto == null) {
            throw new SoapParseException("cannot determine soap protocol in reply", env.toString());
        }
        Element e = proto.getBodyElement(env);
        if (e == null) {
            throw new SoapParseException("malformed soap structure in reply", env.toString());
        }
        this.mContext = proto.getHeader(env, HeaderConstants.CONTEXT);
        if (this.mContext != null) {
            String sid = this.mContext.getAttribute("session", null);
            if (sid == null) {
                this.mContext.getAttribute("sessionId", null);
            }
            if (sid != null) {
                this.mSessionId = sid;
            }
        }
        if (proto.isFault(e)) {
            if (this.mTargetAcctId != null) {
                proto.updateArgumentsForRemoteFault(e, this.mTargetAcctId);
            }
            throw proto.soapFault(e);
        }
        return e;
    }

    public final Element invoke(Element document) throws IOException, ServiceException {
        return this.invoke(document, false, false, null);
    }

    public final Element invokeRaw(Element envelope) throws IOException, ServiceException {
        return this.invoke(envelope, true, false, null);
    }

    public final Element invokeWithoutSession(Element document) throws IOException, ServiceException {
        return this.invoke(document, false, true, null);
    }

    public final Element invoke(Element document, boolean raw, boolean noSession, String requestedAccountId) throws IOException, ServiceException {
        return this.invoke(document, raw, noSession, requestedAccountId, null, null);
    }

    public abstract Element invoke(Element var1, boolean var2, boolean var3, String var4, String var5, String var6) throws ServiceException, IOException;

    public void setTimeout(int newTimeout) {
    }

    public static interface DebugListener {
        public void sendSoapMessage(Element var1);

        public void receiveSoapMessage(Element var1);
    }
}

