/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.auth.ZAuthToken;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.soap.SoapUtil;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dom4j.DocumentException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapTestHarness {
    public static final String NAMESPACE_STR = "urn:zimbraTestHarness";
    public static final Namespace NAMESPACE = Namespace.get("test", "urn:zimbraTestHarness");
    public static final QName E_TESTS = QName.get("tests", NAMESPACE);
    public static final QName E_TEST = QName.get("test", NAMESPACE);
    public static final QName E_REQUEST = QName.get("request", NAMESPACE);
    public static final QName E_RESPONSE = QName.get("response", NAMESPACE);
    public static final QName E_PROPERTY = QName.get("property", NAMESPACE);
    public static final QName E_NAMESPACE = QName.get("namespace", NAMESPACE);
    public static final QName E_SELECT = QName.get("select", NAMESPACE);
    public static final QName E_ECHO = QName.get("echo", NAMESPACE);
    public static final String A_ATTR = "attr";
    public static final String A_NAME = "name";
    public static final String A_PREFIX = "prefix";
    public static final String A_URI = "uri";
    public static final String A_PATH = "path";
    public static final String A_VALUE = "value";
    public static final String A_SET = "set";
    public static final String A_REQUIRED = "required";
    public static final String A_DUMP = "dump";
    public static final String A_MATCH = "match";
    private static Pattern mPropPattern = Pattern.compile("(\\$\\{([^}]+)\\})");
    private SoapProtocol mSoapProto;
    private SoapProtocol mResponseProto;
    private SoapHttpTransport mTransport;
    private String mTargetUser;
    private String mAuthToken;
    private String mSessionId;
    private long mCounter = 0L;
    private HashMap<String, String> mProps = new HashMap();
    private boolean mDebug;
    private String mUri;
    private int mTestNum;
    private Test mCurrent;
    private List<Test> mTests;
    private static Map<String, String> mURIs = null;
    private static Map<String, String> mJSURIs = null;

    public static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(SoapTestHarness.class.getName(), options);
        System.exit(1);
    }

    public static void main(String[] args) throws HarnessException, IOException, DocumentException, ServiceException {
        SoapTestHarness harness = new SoapTestHarness();
        harness.runTests(args);
    }

    public SoapTestHarness() {
        this.mSoapProto = SoapProtocol.Soap12;
        this.mResponseProto = SoapProtocol.Soap12;
        this.mTests = new ArrayList<Test>();
    }

    public void runTests(String[] args) throws HarnessException, IOException, DocumentException, ServiceException {
        CliUtil.toolSetup();
        SoapTransport.setDefaultUserAgent("SoapTestHarness", null);
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption("h", "help", false, "print usage");
        options.addOption("d", "debug", false, "debug");
        options.addOption("s", "expandsystemprops", false, "exoand system properties");
        Option fileOpt = new Option("f", "file", true, "input document");
        fileOpt.setArgName("request-document");
        fileOpt.setRequired(true);
        options.addOption(fileOpt);
        CommandLine cl = null;
        boolean err = false;
        try {
            cl = parser.parse(options, args);
        }
        catch (ParseException pe) {
            System.err.println("error: " + pe.getMessage());
            err = true;
        }
        if (err || cl.hasOption("help")) {
            SoapTestHarness.usage(options);
        }
        this.mDebug = cl.hasOption("d");
        String file = cl.getOptionValue("f");
        if (cl.hasOption("s")) {
            this.expandSystemProperties();
        }
        String docStr = new String(ByteUtil.getContent(new File(file)), "utf-8");
        this.doTests(Element.parseXML(docStr));
        if (this.mTransport != null) {
            this.mTransport.shutdown();
        }
    }

    private void setProperty(String name, String value) throws HarnessException {
        this.mProps.put(name, value);
        if (name.equals(A_URI)) {
            if (value == null) {
                throw new HarnessException("need value for uri");
            }
            this.mUri = value;
            this.mTransport = new SoapHttpTransport(this.mUri);
        } else if (name.equals("authToken")) {
            if (value == null) {
                throw new HarnessException("need value for authToken");
            }
            this.mAuthToken = value;
        } else if (name.equals("sessionId")) {
            if (value != null) {
                this.mSessionId = value;
            }
        } else if (name.equals("target")) {
            this.mTargetUser = value == null || value.equals("") ? null : value;
        } else if (name.equals("protocol")) {
            this.mResponseProto = "js".equalsIgnoreCase(value) ? SoapProtocol.SoapJS : SoapProtocol.Soap12;
        }
    }

    private void doEcho(Element e) {
        System.out.println(e.getTextTrim());
    }

    private void checkGlobals(Element e) throws HarnessException {
        if (e.getQName().equals(E_ECHO)) {
            this.doEcho(e);
        } else if (e.getQName().equals(E_PROPERTY)) {
            this.doProperty(e);
        } else if (e.getQName().equals(E_NAMESPACE)) {
            this.doNamespace(e);
        }
    }

    private void doProperty(Element property) throws HarnessException {
        String name = property.getAttribute(A_NAME, null);
        String value = property.getAttribute(A_VALUE, null);
        if (name == null) {
            throw new HarnessException("<property> tag missing name");
        }
        if (value == null) {
            throw new HarnessException("<property> tag missing value");
        }
        this.setProperty(name, value);
    }

    private void doNamespace(Element property) throws HarnessException {
        String prefix = property.getAttribute(A_PREFIX, null);
        String uri = property.getAttribute(A_URI, null);
        if (prefix == null) {
            throw new HarnessException("<namespace> tag missing prefix");
        }
        if (uri == null) {
            throw new HarnessException("<namespace> tag missing uri");
        }
        SoapTestHarness.getURIs(SoapProtocol.Soap12).put(prefix, uri);
        SoapTestHarness.getURIs(SoapProtocol.SoapJS).put(prefix, uri);
    }

    protected void doTests(Element root) throws HarnessException, IOException, ServiceException {
        if (!root.getQName().equals(E_TESTS)) {
            throw new HarnessException("root document node must be " + E_TESTS.getQualifiedName());
        }
        for (Element e : root.listElements()) {
            if ((e = this.expandProps(e)).getQName().equals(E_TEST)) {
                if (this.doTest(e)) continue;
                break;
            }
            this.checkGlobals(e);
        }
        for (Test t : this.mTests) {
            System.out.println(t.getStatus());
        }
    }

    private boolean doTest(Element test) throws IOException, HarnessException, ServiceException {
        this.mCurrent = new Test();
        this.mTests.add(this.mCurrent);
        this.mCurrent.mTestNum = ++this.mTestNum;
        this.mCurrent.mTest = test;
        for (Element e : test.listElements()) {
            if (e.getQName().equals(E_REQUEST)) {
                this.doRequest(e);
                continue;
            }
            if (e.getQName().equals(E_RESPONSE)) {
                this.doResponse(e);
                continue;
            }
            this.checkGlobals(e);
        }
        if (this.mDebug || this.mCurrent.testFailed() || this.mCurrent.dumpTest()) {
            System.out.println("----");
            System.out.println(this.mCurrent.mSoapRequest.prettyPrint());
            System.out.println("----");
            System.out.println(this.mCurrent.mSoapResponse.prettyPrint());
            System.out.println("----");
        }
        if (!this.mCurrent.isRequired()) {
            return true;
        }
        return !this.mCurrent.testFailed();
    }

    private String expandAllProps(String text) throws HarnessException {
        Matcher matcher = mPropPattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String name = matcher.group(2);
            String replace = this.mProps.get(name);
            if (replace == null) {
                if (name.equals("TIME")) {
                    replace = System.currentTimeMillis() + "";
                } else if (name.equals("COUNTER")) {
                    replace = ++this.mCounter + "";
                }
            }
            if (replace != null) {
                matcher.appendReplacement(sb, replace);
                continue;
            }
            throw new HarnessException("unknown property: " + matcher.group(1));
        }
        matcher.appendTail(sb);
        text = sb.toString();
        return text;
    }

    private Element expandProps(Element doc) throws HarnessException {
        for (Element e : doc.listElements()) {
            this.expandProps(e);
        }
        for (Element.Attribute attr : doc.listAttributes()) {
            String text = attr.getValue();
            if (text.indexOf("${") == -1) continue;
            attr.setValue(this.expandAllProps(text));
        }
        String text = doc.getText();
        if (text.indexOf("${") != -1) {
            doc.setText(this.expandAllProps(text));
        }
        return doc;
    }

    static String lpad(String s, int width) {
        return SoapTestHarness.pad(s, width, false, true);
    }

    static String rpad(String s, int width) {
        return SoapTestHarness.pad(s, width, false, false);
    }

    static String lpadz(String s, int width) {
        return SoapTestHarness.pad(s, width, true, true);
    }

    static String rpadz(String s, int width) {
        return SoapTestHarness.pad(s, width, true, false);
    }

    private static String pad(String s, int width, boolean withZero, boolean left) {
        int needed = width - s.length();
        if (needed <= 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(width);
        if (left) {
            while (needed-- > 0) {
                sb.append(withZero ? (char)'0' : ' ');
            }
            sb.append(s);
        } else {
            sb.append(s);
            while (needed-- > 0) {
                sb.append(withZero ? (char)'0' : ' ');
            }
        }
        return sb.toString();
    }

    private void doRequest(Element request) throws IOException, ServiceException {
        this.mCurrent.mDocRequest = request.elementIterator().next();
        this.mCurrent.mDocRequest.detach();
        ZAuthToken zat = this.mAuthToken == null ? null : new ZAuthToken(null, this.mAuthToken, null);
        Element ctxt = SoapUtil.toCtxt(this.mSoapProto, zat, this.mSessionId, -1);
        if (this.mTargetUser != null) {
            SoapUtil.addTargetAccountToCtxt(ctxt, null, this.mTargetUser);
        }
        if (this.mResponseProto == SoapProtocol.SoapJS) {
            SoapUtil.addResponseProtocolToCtxt(ctxt, this.mResponseProto);
        }
        this.mCurrent.mSoapRequest = this.mSoapProto.soapEnvelope(this.mCurrent.mDocRequest, ctxt);
        long start = System.currentTimeMillis();
        this.mCurrent.mSoapResponse = this.mTransport.invokeRaw(this.mCurrent.mSoapRequest);
        long finish = System.currentTimeMillis();
        this.mCurrent.mTime = finish - start;
        this.mCurrent.mDocResponse = this.mResponseProto.getBodyElement(this.mCurrent.mSoapResponse);
    }

    private static Map<String, String> getURIs(SoapProtocol proto) {
        if (mURIs == null) {
            mURIs = new HashMap<String, String>();
            mURIs.put("zimbra", "urn:zimbra");
            mURIs.put("acct", "urn:zimbraAccount");
            mURIs.put("mail", "urn:zimbraMail");
            mURIs.put("admin", "urn:zimbraAdmin");
            mURIs.put("soap", "http://www.w3.org/2003/05/soap-envelope");
            mURIs.put("soap12", "http://www.w3.org/2003/05/soap-envelope");
            mURIs.put("soap11", "http://schemas.xmlsoap.org/soap/envelope/");
            mJSURIs = new HashMap<String, String>();
            mJSURIs.put("zimbra", "urn:zimbra");
            mJSURIs.put("acct", "urn:zimbraAccount");
            mJSURIs.put("mail", "urn:zimbraMail");
            mJSURIs.put("admin", "urn:zimbraAdmin");
            mJSURIs.put("soap", "urn:zimbraSoap");
            mJSURIs.put("soapJS", "urn:zimbraSoap");
        }
        return proto == SoapProtocol.SoapJS ? mJSURIs : mURIs;
    }

    private void doSelect(Element context, Element parent) throws SoapFaultException, IOException, HarnessException {
        String property;
        Element se;
        String path = parent.getAttribute(A_PATH, null);
        String attr = parent.getAttribute(A_ATTR, null);
        String match = parent.getAttribute(A_MATCH, null);
        if (path != null) {
            org.dom4j.Element d4context = context.toXML();
            XPath xpath = d4context.createXPath(path);
            xpath.setNamespaceURIs(SoapTestHarness.getURIs(this.mResponseProto));
            Node node = xpath.selectSingleNode(d4context);
            if (!(node instanceof org.dom4j.Element)) {
                this.mCurrent.check(false, "select failed: " + path);
                return;
            }
            se = Element.convertDOM((org.dom4j.Element)node);
            this.mCurrent.check(true, "select ok: " + path);
        } else {
            se = context;
        }
        String value = attr != null ? se.getAttribute(attr, null) : se.getText();
        if (match != null) {
            boolean ok = Pattern.matches(match, value);
            this.mCurrent.check(ok, "match " + (ok ? "ok" : "failed") + " (" + match + ")" + " (" + value + ")");
        }
        if ((property = parent.getAttribute(A_SET, null)) != null) {
            this.setProperty(property, value);
        }
        for (Element e : parent.listElements()) {
            if (e.getQName().equals(E_SELECT)) {
                this.doSelect(se, e);
                continue;
            }
            this.checkGlobals(e);
        }
    }

    private void doResponse(Element test) throws SoapFaultException, IOException, HarnessException {
        for (Element e : test.listElements()) {
            if (e.getQName().equals(E_SELECT)) {
                this.doSelect(this.mCurrent.mDocResponse, e);
                continue;
            }
            this.checkGlobals(e);
        }
    }

    private void expandSystemProperties() throws HarnessException {
        Properties props = System.getProperties();
        if (props != null) {
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                String value = props.getProperty(key).toString();
                if (value != null) {
                    this.setProperty(key, value);
                    continue;
                }
                throw new HarnessException("Invalid Global Property file");
            }
        }
    }

    public static class HarnessException
    extends Exception {
        public HarnessException(String message) {
            super(message);
        }

        public HarnessException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Test {
        public Element mTest;
        public Element mDocRequest;
        public Element mDocResponse;
        public Element mSoapRequest;
        public Element mSoapResponse;
        public int mTestNum;
        public int mNumChecks;
        public int mNumCheckFails;
        public long mTime;

        public void check(boolean ok, String message) {
            ++this.mNumChecks;
            if (!ok) {
                ++this.mNumCheckFails;
            }
        }

        public boolean isRequired() {
            return "true".equals(this.mTest.getAttribute(SoapTestHarness.A_REQUIRED, null));
        }

        public boolean testFailed() {
            return this.mNumCheckFails > 0;
        }

        public String getDocReqName() {
            return this.mDocRequest.getName();
        }

        public String getDocRespName() {
            return this.mDocResponse.getName();
        }

        public String getStatus() {
            StringBuilder status = new StringBuilder();
            if (this.testFailed()) {
                status.append("FAIL ");
            } else {
                status.append("PASS ");
            }
            status.append(SoapTestHarness.lpadz(this.mTestNum + "", 4));
            status.append(" ");
            int pass = this.mNumChecks - this.mNumCheckFails;
            status.append(SoapTestHarness.lpad(pass + "/" + this.mNumChecks, 8));
            status.append(" ");
            status.append(SoapTestHarness.lpad(this.mTime + "ms", 7));
            status.append("    ");
            status.append(SoapTestHarness.rpad(this.getDocReqName(), 40));
            return status.toString();
        }

        public boolean dumpTest() {
            return "true".equals(this.mTest.getAttribute(SoapTestHarness.A_DUMP, null));
        }
    }
}

