/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.Soap11Protocol;
import com.zimbra.common.soap.Soap12Protocol;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapJSProtocol;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Namespace;
import org.dom4j.QName;

public abstract class SoapProtocol {
    protected static final String NS_PREFIX = "soap";
    public static final SoapProtocol Soap12 = new Soap12Protocol();
    public static final SoapProtocol Soap11 = new Soap11Protocol();
    public static final SoapProtocol SoapJS = new SoapJSProtocol();
    protected QName mFaultQName = new QName("Fault", this.getNamespace());
    protected QName mEnvelopeQName = new QName("Envelope", this.getNamespace());
    protected QName mBodyQName = new QName("Body", this.getNamespace());
    protected QName mHeaderQName = new QName("Header", this.getNamespace());
    protected Element.ElementFactory mFactory = this.getFactory();
    private static final String[] ZIMBRA_ERROR_ELEMENT = new String[]{"Detail", "Error", "a"};

    SoapProtocol() {
    }

    public Element soapEnvelope(Element document) {
        Element env = this.mFactory.createElement(this.mEnvelopeQName);
        Element body = env.addUniqueElement(this.mBodyQName);
        body.addUniqueElement(document);
        return env;
    }

    public Element soapEnvelope(Element document, Element header) {
        Element env = this.mFactory.createElement(this.mEnvelopeQName);
        if (header != null) {
            Element soapHeader = env.addUniqueElement(this.mHeaderQName);
            soapHeader.addUniqueElement(header);
        }
        Element body = env.addUniqueElement(this.mBodyQName);
        body.addUniqueElement(document);
        return env;
    }

    public abstract Element soapFault(ServiceException var1);

    public abstract SoapFaultException soapFault(Element var1);

    public abstract String getContentType();

    public abstract Element.ElementFactory getFactory();

    public abstract Namespace getNamespace();

    public QName getFaultQName() {
        return this.mFaultQName;
    }

    public QName getBodyQName() {
        return this.mBodyQName;
    }

    public QName getEnvelopeQName() {
        return this.mEnvelopeQName;
    }

    public QName getHeaderQName() {
        return this.mHeaderQName;
    }

    public static String getCharset() {
        return "UTF-8";
    }

    public static byte[] toBytes(String message) throws UnsupportedEncodingException {
        return message.getBytes(SoapProtocol.getCharset());
    }

    public static String toString(byte[] message) throws UnsupportedEncodingException {
        if (message == null || message.length == 0) {
            return "";
        }
        if (message[message.length - 1] == 0) {
            return new String(message, 0, message.length - 1, SoapProtocol.getCharset());
        }
        return new String(message, SoapProtocol.getCharset());
    }

    public static String toString(Element env, boolean prettyPrint) {
        return prettyPrint ? env.prettyPrint() : env.toString();
    }

    public Element getBodyElement(Element soapEnvelope) {
        if (soapEnvelope == null || !this.isEnvelope(soapEnvelope)) {
            return null;
        }
        Element body = soapEnvelope.getOptionalElement(this.getBodyQName());
        if (body == null) {
            return null;
        }
        Iterator<Element> it = body.elementIterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public Element getHeader(Element soapEnvelope) {
        if (!this.isEnvelope(soapEnvelope)) {
            return null;
        }
        return soapEnvelope.getOptionalElement(this.getHeaderQName());
    }

    public Element getHeader(Element soapEnvelope, QName headerQName) {
        if (!this.isEnvelope(soapEnvelope)) {
            return null;
        }
        Element soapHeader = this.getHeader(soapEnvelope);
        Element header = soapHeader != null ? soapHeader.getOptionalElement(headerQName) : null;
        return header;
    }

    public boolean isEnvelope(Element element) {
        return this.mEnvelopeQName.equals(element.getQName());
    }

    public boolean isFault(Element element) {
        return this.mFaultQName.equals(element.getQName());
    }

    public boolean hasFault(Element soapEnvelope) {
        Element body = this.getBodyElement(soapEnvelope);
        return body != null && this.isFault(body);
    }

    public void updateArgumentsForRemoteFault(Element element, String remoteAccountId) {
        if (!this.isFault(element)) {
            return;
        }
        List<Element> argList = element.getPathElementList(ZIMBRA_ERROR_ELEMENT);
        if (argList != null) {
            for (Element arg : argList) {
                String value;
                String type = arg.getAttribute("t", "UNKNOWN");
                if (!type.equals(ServiceException.Argument.Type.IID.toString()) || (value = arg.getTextTrim()).indexOf(":") >= 0) continue;
                arg.setText(remoteAccountId + ":" + value);
            }
        }
    }

    public static SoapProtocol determineProtocol(Element env) {
        if (Soap12.isEnvelope(env)) {
            return Soap12;
        }
        if (Soap11.isEnvelope(env)) {
            return Soap11;
        }
        if (env instanceof Element.JSONElement) {
            return SoapJS;
        }
        return null;
    }

    public abstract boolean hasSOAPActionHeader();

    public abstract String getVersion();

    public String toString() {
        return "SOAP " + this.getVersion();
    }
}

