/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.ZimbraNamespace;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class SoapJSProtocol
extends SoapProtocol {
    private static final String NS_STR = "urn:zimbraSoap";
    private static final Namespace NS = Namespace.get("soap", "urn:zimbraSoap");
    private static final QName CODE = QName.get("Code", NS);
    private static final QName REASON = QName.get("Reason", NS);
    private static final String TEXT = "Text";
    private static final QName DETAIL = QName.get("Detail", NS);
    private static final String VALUE = "Value";
    private static final QName SENDER_CODE = QName.get("Sender", NS);
    private static final QName RECEIVER_CODE = QName.get("Receiver", NS);

    SoapJSProtocol() {
    }

    public Element.ElementFactory getFactory() {
        return Element.JSONElement.mFactory;
    }

    public Namespace getNamespace() {
        return NS;
    }

    public SoapFaultException soapFault(Element fault) {
        if (!this.isFault(fault)) {
            return new SoapFaultException("not a soap fault ", fault);
        }
        Element reason = fault.getOptionalElement(REASON);
        String reasonText = reason == null ? null : reason.getAttribute(TEXT, null);
        reasonText = reasonText != null ? reasonText.trim() : "unknown reason";
        Element detail = fault.getOptionalElement(DETAIL);
        Element code = fault.getOptionalElement(CODE);
        String whoseFault = code == null ? null : code.getAttribute(VALUE, null);
        boolean isReceiversFault = RECEIVER_CODE.getQualifiedName().equals(whoseFault);
        return new SoapFaultException(reasonText, detail, isReceiversFault, fault);
    }

    public Element soapFault(ServiceException e) {
        String reason = e.getMessage();
        if (reason == null) {
            reason = e.toString();
        }
        QName code = e.isReceiversFault() ? RECEIVER_CODE : SENDER_CODE;
        Element eFault = this.mFactory.createElement(this.mFaultQName);
        eFault.addUniqueElement(CODE).addAttribute(VALUE, code.getQualifiedName());
        eFault.addUniqueElement(REASON).addAttribute(TEXT, reason);
        Element eError = eFault.addUniqueElement(DETAIL).addUniqueElement(ZimbraNamespace.E_ERROR);
        eError.addAttribute(ZimbraNamespace.E_CODE.getName(), e.getCode());
        eError.addAttribute(ZimbraNamespace.E_TRACE.getName(), e.getId());
        if (e.getArgs() != null) {
            for (ServiceException.Argument arg : e.getArgs()) {
                if (!arg.externalVisible()) continue;
                Element val = eError.addElement(ZimbraNamespace.E_ARGUMENT);
                val.addAttribute("n", arg.mName);
                val.addAttribute("t", arg.mType.toString());
                val.setText(arg.mValue);
            }
        }
        return eFault;
    }

    public String getContentType() {
        return "text/javascript; charset=utf-8";
    }

    public boolean hasSOAPActionHeader() {
        return false;
    }

    public String getVersion() {
        return "0.1.";
    }
}

