/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.RemoteIP;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.dom4j.ElementHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapHttpTransport
extends SoapTransport {
    private HttpClient mClient = ZimbraHttpConnectionManager.getInternalHttpConnMgr().getDefaultHttpClient();
    private Map<String, String> mCustomHeaders;
    private HostConfiguration mHostConfig = null;
    private HttpDebugListener mHttpDebugListener;
    private boolean mKeepAlive = defaultKeepAlive;
    private int mRetryCount = defaultRetryCount;
    private int mTimeout = defaultTimeout;
    private String mUri;
    private URI mURI;
    private static boolean defaultKeepAlive = ZimbraHttpConnectionManager.getInternalHttpConnMgr().getKeepAlive();
    private static int defaultRetryCount = LC.httpclient_soaphttptransport_retry_count.intValue();
    private static int defaultTimeout = LC.httpclient_soaphttptransport_so_timeout.intValue();

    public String toString() {
        return "SoapHTTPTransport(uri=" + this.mUri + ")";
    }

    public SoapHttpTransport(String uri) {
        this(uri, null, 0);
    }

    public SoapHttpTransport(String uri, String proxyHost, int proxyPort) {
        this(uri, proxyHost, proxyPort, null, null);
    }

    public SoapHttpTransport(String uri, String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
        this.mUri = uri;
        try {
            this.mURI = new URI(uri, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            this.mHostConfig = new HostConfiguration();
            this.mHostConfig.setHost(this.mURI);
            this.mHostConfig.setProxy(proxyHost, proxyPort);
            if (proxyUser != null && proxyUser.length() > 0 && proxyPass != null && proxyPass.length() > 0) {
                this.mClient = ZimbraHttpConnectionManager.getInternalHttpConnMgr().newHttpClient();
                this.mClient.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort), new UsernamePasswordCredentials(proxyUser, proxyPass));
            }
        }
    }

    public void setHttpDebugListener(HttpDebugListener listener) {
        this.mHttpDebugListener = listener;
    }

    public HttpDebugListener getHttpDebugListener() {
        return this.mHttpDebugListener;
    }

    public void shutdown() {
        if (this.mClient != null && this.mClient != ZimbraHttpConnectionManager.getInternalHttpConnMgr().getDefaultHttpClient()) {
            this.mClient.getHttpConnectionManager().closeIdleConnections(0L);
            this.mClient = null;
            this.mHostConfig = null;
        }
    }

    public Map<String, String> getCustomHeaders() {
        if (this.mCustomHeaders == null) {
            this.mCustomHeaders = new HashMap<String, String>();
        }
        return this.mCustomHeaders;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.mKeepAlive = keepAlive;
    }

    public void setRetryCount(int newRetryCount) {
        this.mRetryCount = newRetryCount < 0 ? defaultRetryCount : newRetryCount;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    @Override
    public void setTimeout(int newTimeout) {
        this.mTimeout = newTimeout < 0 ? defaultTimeout : newTimeout;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public String getURI() {
        return this.mUri;
    }

    @Override
    public Element invoke(Element document, boolean raw, boolean noSession, String requestedAccountId, String changeToken, String tokenType) throws IOException, HttpException, ServiceException {
        return this.invoke(document, raw, noSession, requestedAccountId, changeToken, tokenType, null);
    }

    public Element invoke(Element document, boolean raw, boolean noSession, String requestedAccountId, String changeToken, String tokenType, Map<String, ElementHandler> saxHandlers) throws IOException, HttpException, ServiceException {
        Map<String, String> cookieMap = this.getAuthToken() == null ? null : this.getAuthToken().cookieMap(false);
        HttpState state = null;
        HttpMethodBase method = null;
        try {
            String responseStr;
            InputStreamReader reader;
            block24: {
                String query;
                String uri;
                int i = this.mUri.indexOf(63);
                if (i >= 0) {
                    uri = this.mUri.substring(0, i);
                    query = this.mUri.substring(i);
                } else {
                    uri = this.mUri;
                    query = "";
                }
                if (!uri.endsWith("/")) {
                    uri = uri + '/';
                }
                uri = uri + this.getDocumentName(document);
                method = new PostMethod(uri + query);
                String agentName = this.getUserAgentName();
                if (agentName != null) {
                    String agentVersion = this.getUserAgentVersion();
                    if (agentVersion != null) {
                        agentName = agentName + " " + agentVersion;
                    }
                    method.setRequestHeader(new Header("User-Agent", agentName));
                }
                method.setRequestHeader("Content-Type", this.getRequestProtocol().getContentType());
                if (this.getClientIp() != null) {
                    method.setRequestHeader(RemoteIP.X_ORIGINATING_IP_HEADER, this.getClientIp());
                }
                Element soapReq = this.generateSoapMessage(document, raw, noSession, requestedAccountId, changeToken, tokenType);
                String soapMessage = SoapProtocol.toString(soapReq, this.getPrettyPrint());
                HttpMethodParams params = method.getParams();
                ((EntityEnclosingMethod)method).setRequestEntity(new StringRequestEntity(soapMessage, null, "UTF-8"));
                if (this.getRequestProtocol().hasSOAPActionHeader()) {
                    method.setRequestHeader("SOAPAction", this.mUri);
                }
                if (this.mCustomHeaders != null) {
                    for (Map.Entry<String, String> entry : this.mCustomHeaders.entrySet()) {
                        method.setRequestHeader(entry.getKey(), entry.getValue());
                    }
                }
                if (cookieMap != null) {
                    for (Map.Entry<String, String> ck : cookieMap.entrySet()) {
                        if (state == null) {
                            state = new HttpState();
                        }
                        state.addCookie(new Cookie(method.getURI().getHost(), ck.getKey(), ck.getValue(), "/", null, false));
                    }
                }
                if (this.mHttpDebugListener != null) {
                    this.mHttpDebugListener.sendSoapMessage((PostMethod)method, soapReq);
                }
                params.setCookiePolicy(state == null ? "ignoreCookies" : "compatibility");
                params.setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(this.mRetryCount - 1, true));
                params.setSoTimeout(this.mTimeout);
                params.setVersion(HttpVersion.HTTP_1_1);
                method.setRequestHeader("Connection", this.mKeepAlive ? "Keep-alive" : "Close");
                int responseCode = this.mClient.executeMethod(this.mHostConfig, method, state);
                if (responseCode != 200 && responseCode != 500) {
                    throw ServiceException.PROXY_ERROR(method.getStatusLine().toString(), uri);
                }
                reader = new InputStreamReader(method.getResponseBodyAsStream(), SoapProtocol.getCharset());
                responseStr = "";
                try {
                    if (saxHandlers == null) break block24;
                    this.parseLargeSoapResponse(reader, saxHandlers);
                    Element element = null;
                    return element;
                }
                catch (SoapFaultException x) {
                    x.setFaultRequest(soapMessage);
                    x.setFaultResponse(responseStr.substring(0, Math.min(10240, responseStr.length())));
                    throw x;
                }
            }
            responseStr = ByteUtil.getContent(reader, (int)method.getResponseContentLength(), false);
            Element soapResp = this.parseSoapResponse(responseStr, raw);
            if (this.mHttpDebugListener != null) {
                this.mHttpDebugListener.receiveSoapMessage((PostMethod)method, soapResp);
            }
            Element element = soapResp;
            return element;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
            if (!this.mKeepAlive) {
                this.mClient.getHttpConnectionManager().closeIdleConnections(0L);
            }
        }
    }

    private String getDocumentName(Element document) {
        List<Element> children;
        Element body;
        if (document == null || document.getName() == null) {
            return null;
        }
        String name = document.getName();
        if (name.equals("Envelope") && (body = document.getOptionalElement("Body")) != null && (children = body.listElements()).size() > 0) {
            name = children.get(0).getName();
        }
        return name;
    }

    public static interface HttpDebugListener {
        public void sendSoapMessage(PostMethod var1, Element var2);

        public void receiveSoapMessage(PostMethod var1, Element var2);
    }
}

