/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.ZimbraNamespace;
import com.zimbra.common.util.StringUtil;
import java.util.List;

public class SoapFaultException
extends ServiceException {
    private static final long serialVersionUID = 2021293100288028461L;
    public static final String UNKNOWN = "soap.UNKNOWN";
    public static final String SAX_PARSE_ERROR = "soap.SAX_PARSE_ERROR";
    private boolean mIsReceiversFault;
    private Element mDetail;
    private Element mFault;
    private boolean mIsLocal;
    private String mRequest;
    private String mResponse;
    private static final String[] FAULT_CODE_PATH = new String[]{ZimbraNamespace.E_DETAIL.getName(), ZimbraNamespace.E_ERROR.getName(), ZimbraNamespace.E_CODE.getName()};
    private static final String[] FAULT_ARGUMENT_PATH = new String[]{ZimbraNamespace.E_DETAIL.getName(), ZimbraNamespace.E_ERROR.getName(), ZimbraNamespace.E_ARGUMENT.getName()};
    private static final String[] FAULT_REASON_PATH = new String[]{ZimbraNamespace.E_REASON.getName(), ZimbraNamespace.E_TEXT.getName()};

    public SoapFaultException(String message, String code, boolean isReceiversFault, Throwable cause) {
        super(message, code, isReceiversFault, new ServiceException.Argument[0]);
    }

    public SoapFaultException(String message, Element detail, boolean isReceiversFault) {
        super(message, SoapFaultException.getCode(detail), isReceiversFault, new ServiceException.Argument[0]);
        this.mIsReceiversFault = isReceiversFault;
        this.mDetail = detail;
        this.mFault = null;
    }

    SoapFaultException(String message, Element detail, boolean isReceiversFault, Element fault) {
        super(message, SoapFaultException.getCode(detail), isReceiversFault, new ServiceException.Argument[0]);
        String traceId;
        Element error;
        this.mIsReceiversFault = isReceiversFault;
        this.mDetail = detail;
        this.mFault = fault;
        if (detail != null && (error = detail.getOptionalElement(ZimbraNamespace.E_ERROR)) != null && (traceId = error.getAttribute(ZimbraNamespace.E_TRACE.getName(), null)) != null) {
            this.setId(traceId);
        }
    }

    public SoapFaultException(String message, Element fault) {
        super(message, UNKNOWN, false, new ServiceException.Argument[0]);
        this.mFault = fault;
    }

    public SoapFaultException(String message, boolean isLocal, Element fault) {
        this(message, fault);
        this.mIsLocal = isLocal;
    }

    private static String getCode(Element detail) {
        Element error;
        if (detail != null && (error = detail.getOptionalElement(ZimbraNamespace.E_ERROR)) != null) {
            return error.getAttribute(ZimbraNamespace.E_CODE.getName(), UNKNOWN);
        }
        return UNKNOWN;
    }

    public String getCode() {
        return this.mFault == null ? null : this.mFault.getPathAttribute(FAULT_CODE_PATH);
    }

    public String getArgumentValue(String argumentName) {
        if (this.mFault == null) {
            return null;
        }
        List<Element> arguments = this.mFault.getPathElementList(FAULT_ARGUMENT_PATH);
        if (arguments == null) {
            return null;
        }
        for (Element argument : arguments) {
            String name = argument.getAttribute("n", null);
            if (!StringUtil.equal(name, argumentName)) continue;
            return argument.getText();
        }
        return null;
    }

    public String getReason() {
        return this.mFault == null ? null : this.mFault.getPathAttribute(FAULT_REASON_PATH);
    }

    public Element getDetail() {
        return this.mDetail;
    }

    protected void initDetail(Element detail) throws IllegalStateException {
        if (this.mDetail != null) {
            throw new IllegalStateException("mDetail is not null");
        }
        this.mDetail = detail;
    }

    public boolean isReceiversFault() {
        return this.mIsReceiversFault;
    }

    public Element getFault() {
        return this.mFault;
    }

    public boolean isSourceLocal() {
        return this.mIsLocal;
    }

    public void setFaultRequest(String request) {
        this.mRequest = request;
    }

    public void setFaultResponse(String response) {
        this.mResponse = response;
    }

    public String getFaultRequest() {
        return this.mRequest;
    }

    public String getFaultResponse() {
        return this.mResponse;
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        sb.append("class=").append(this.getClass().getName()).append("\n");
        sb.append("message=").append(this.getMessage()).append("\n");
        sb.append("mIsReceiversFault=").append(this.mIsReceiversFault).append("\n");
        sb.append("mIsLocal=").append(this.mIsLocal).append("\n");
        sb.append("mDetail=").append(this.mDetail).append("\n");
        sb.append("mFault=").append(this.mFault).append("\n");
        return sb.toString();
    }
}

