/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.AccountConstants;
import com.zimbra.common.soap.AdminConstants;
import com.zimbra.common.soap.DomUtil;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapHttpTransport;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.StringUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dom4j.DocumentException;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class SoapCommandUtil
implements SoapTransport.DebugListener {
    private static final Map<String, Namespace> sTypeToNamespace = new HashMap<String, Namespace>();
    private static final String DEFAULT_ADMIN_URL = String.format("https://%s:%d/service/admin/soap", LC.zimbra_zmprov_default_soap_server.value(), LC.zimbra_admin_service_port.intValue());
    private static final String DEFAULT_URL = "http://" + LC.zimbra_zmprov_default_soap_server.value() + "/service/soap";
    private static final String LO_HELP = "help";
    private static final String LO_MAILBOX = "mailbox";
    private static final String LO_TARGET = "target";
    private static final String LO_ADMIN = "admin";
    private static final String LO_PASSWORD = "password";
    private static final String LO_PASSFILE = "passfile";
    private static final String LO_URL = "url";
    private static final String LO_ZADMIN = "zadmin";
    private static final String LO_VERBOSE = "verbose";
    private static final String LO_NO_OP = "no-op";
    private static final String LO_SELECT = "select";
    private static final String LO_JSON = "json";
    private static final String LO_FILE = "file";
    private static final String LO_TYPE = "type";
    private static final String TYPE_MAIL = "mail";
    private static final String TYPE_ADMIN = "admin";
    private static final String TYPE_ACCOUNT = "account";
    private static final String TYPE_IM = "im";
    private static final String TYPE_MOBILE = "mobile";
    private static final String TYPE_OFFLINE = "offline";
    private Options mOptions = new Options();
    private String mUrl;
    private String mType;
    private Namespace mNamespace;
    private String mMailboxName;
    private String mAdminAccountName;
    private String mTargetAccountName;
    private String mPassword;
    private String[] mPaths;
    private String mAuthToken;
    private int mVerbose = 0;
    private boolean mUseSession = false;
    private boolean mNoOp = false;
    private String mSelect;
    private boolean mUseJson = false;
    private String mFilePath;
    private Element.ElementFactory mFactory;
    private PrintStream mOut;

    SoapCommandUtil() {
        this.mOptions.addOption(new Option("h", LO_HELP, false, "Display this help message."));
        Option opt = new Option("m", LO_MAILBOX, true, "Send mail and account requests to this account.  Also used for authentication if -a and -z are not specified.");
        opt.setArgName("account-name");
        this.mOptions.addOption(opt);
        opt = new Option(null, LO_TARGET, true, "Target account name to which requests will be sent.  Only used for non-admin sessions.");
        opt.setArgName("account-name");
        this.mOptions.addOption(opt);
        opt = new Option("a", "admin", true, "Admin account name to authenticate as.");
        opt.setArgName("account-name");
        this.mOptions.addOption(opt);
        opt = new Option("p", LO_PASSWORD, true, "Password.");
        opt.setArgName(LO_PASSWORD);
        this.mOptions.addOption(opt);
        opt = new Option("P", LO_PASSFILE, true, "Read password from file.");
        opt.setArgName("path");
        this.mOptions.addOption(opt);
        opt = new Option("u", LO_URL, true, "SOAP service URL, usually http[s]://host:port/service/soap or https://host:port/service/admin/soap.");
        opt.setArgName(LO_URL);
        this.mOptions.addOption(new Option("z", LO_ZADMIN, false, "Authenticate with zimbra admin name/password from localconfig."));
        this.mOptions.addOption(new Option("v", LO_VERBOSE, false, "Print the SOAP request and other status information. Specify twice for fully verbose output."));
        this.mOptions.addOption(new Option("n", LO_NO_OP, false, "Print the SOAP request only.  Don't send it."));
        opt = new Option(null, LO_SELECT, true, "Select an element or attribute from the response.");
        opt.setArgName("xpath");
        this.mOptions.addOption(opt);
        this.mOptions.addOption(new Option(null, LO_JSON, false, "Use JSON instead of XML."));
        opt = new Option("f", LO_FILE, true, "Read request from file.");
        opt.setArgName("path");
        this.mOptions.addOption(opt);
        opt = new Option("t", LO_TYPE, true, "SOAP request type (mail, account, admin, im, mobile).  Default is admin, or mail if mailbox is specified.");
        opt.setArgName(LO_TYPE);
        this.mOptions.addOption(opt);
        try {
            this.mOut = new PrintStream((OutputStream)System.out, true, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void usage(String errorMsg) {
        int exitStatus = 0;
        if (errorMsg != null) {
            System.err.println(errorMsg);
            exitStatus = 1;
        }
        HelpFormatter format = new HelpFormatter();
        format.printHelp(new PrintWriter(System.err, true), 80, "zmsoap [options] xpath1 [xpath2 xpath3 ...]", null, this.mOptions, 2, 2, "Element paths roughly follow XPath syntax.  The path of each subsequent element is relative to the previous one.  To navigate up the element tree, use \"../\" in the path.  To specify attributes on the current element, use one or more @attr=val arguments.  To specify element text, use \"path/to/element=text\".\nExample: zmsoap -z GetAccountInfoRequest/account=user1 @by=name");
        System.exit(exitStatus);
    }

    private void parseCommandLine(String[] args) throws ParseException {
        String val;
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(this.mOptions, args);
        if (CliUtil.hasOption(cl, LO_HELP)) {
            this.usage(null);
        }
        if ((val = CliUtil.getOptionValue(cl, LO_PASSFILE)) != null) {
            String path = CliUtil.getOptionValue(cl, LO_PASSFILE);
            try {
                this.mPassword = StringUtil.readSingleLineFromFile(path);
            }
            catch (IOException e) {
                this.usage("Cannot read password from file: " + e.getMessage());
            }
        }
        if (CliUtil.hasOption(cl, LO_PASSWORD)) {
            this.mPassword = CliUtil.getOptionValue(cl, LO_PASSWORD);
        }
        this.mAdminAccountName = CliUtil.getOptionValue(cl, "admin");
        if (!CliUtil.hasOption(cl, "admin") && CliUtil.hasOption(cl, LO_ZADMIN)) {
            this.mAdminAccountName = LC.zimbra_ldap_user.value();
            if (!CliUtil.hasOption(cl, LO_PASSWORD)) {
                this.mPassword = LC.zimbra_ldap_password.value();
            }
        }
        this.mMailboxName = CliUtil.getOptionValue(cl, LO_MAILBOX);
        if (this.mMailboxName == null && this.mAdminAccountName == null) {
            this.usage("Authentication account not specified.");
        }
        if (CliUtil.hasOption(cl, LO_TYPE)) {
            this.mType = CliUtil.getOptionValue(cl, LO_TYPE);
            if (!sTypeToNamespace.containsKey(this.mType)) {
                this.usage("Invalid type: " + this.mType);
            }
            if ((this.mType.equals(TYPE_MAIL) || this.mType.equals(TYPE_ACCOUNT) || this.mType.equals(TYPE_IM)) && this.mMailboxName == null) {
                this.usage("Mailbox must be specified for mail, account, and im requests.");
            }
        } else {
            this.mType = this.mMailboxName != null ? TYPE_MAIL : "admin";
        }
        this.mNamespace = sTypeToNamespace.get(this.mType);
        this.mUrl = CliUtil.getOptionValue(cl, LO_URL);
        if (this.mUrl == null) {
            this.mUrl = this.mAdminAccountName != null ? DEFAULT_ADMIN_URL : DEFAULT_URL;
        }
        if (CliUtil.hasOption(cl, LO_TARGET)) {
            if (this.mAdminAccountName != null) {
                this.usage("--target option cannot be used with admin authentication.");
            }
            this.mTargetAccountName = CliUtil.getOptionValue(cl, LO_TARGET);
        }
        this.mVerbose = 0;
        for (Option opt : cl.getOptions()) {
            if (!StringUtil.equal(opt.getLongOpt(), LO_VERBOSE)) continue;
            ++this.mVerbose;
        }
        this.mPaths = cl.getArgs();
        this.mNoOp = CliUtil.hasOption(cl, LO_NO_OP);
        this.mSelect = CliUtil.getOptionValue(cl, LO_SELECT);
        this.mUseJson = CliUtil.hasOption(cl, LO_JSON);
        this.mFilePath = CliUtil.getOptionValue(cl, LO_FILE);
        this.mFactory = this.mUseJson ? Element.JSONElement.mFactory : Element.XMLElement.mFactory;
    }

    public void sendSoapMessage(Element envelope) {
        if (this.mVerbose > 1) {
            this.mOut.println(DomUtil.toString(envelope.toXML(), true));
        }
    }

    public void receiveSoapMessage(Element envelope) {
        if (this.mVerbose > 1) {
            this.mOut.println(DomUtil.toString(envelope.toXML(), true));
        }
    }

    private void adminAuth() throws ServiceException, IOException {
        SoapHttpTransport transport = new SoapHttpTransport(this.mUrl);
        transport.setDebugListener(this);
        Element auth = this.mFactory.createElement(AdminConstants.AUTH_REQUEST);
        auth.addElement("name").setText(this.mAdminAccountName);
        auth.addElement(LO_PASSWORD).setText(this.mPassword);
        Element response = null;
        if (this.mVerbose > 0) {
            this.mOut.println("Sending admin auth request to " + this.mUrl);
        }
        response = transport.invoke(auth, false, !this.mUseSession, null);
        this.mAuthToken = response.getAttribute("authToken");
        transport.setAuthToken(this.mAuthToken);
        if (this.mType.equals(TYPE_MAIL) || this.mType.equals(TYPE_ACCOUNT) || this.mType.equals(TYPE_IM)) {
            Element getInfo = this.mFactory.createElement(AdminConstants.GET_ACCOUNT_INFO_REQUEST);
            Element account = getInfo.addElement(TYPE_ACCOUNT).setText(this.mMailboxName);
            account.addAttribute("by", "name");
            response = transport.invoke(getInfo, false, !this.mUseSession, null);
            if (this.mVerbose > 0) {
                this.mOut.println(response.prettyPrint());
            }
            this.mUrl = response.getElement("soapURL").getText();
            Element delegateAuth = this.mFactory.createElement(AdminConstants.DELEGATE_AUTH_REQUEST);
            account = delegateAuth.addElement(TYPE_ACCOUNT).setText(this.mMailboxName);
            account.addAttribute("by", "name");
            response = transport.invoke(delegateAuth, false, !this.mUseSession, null);
            this.mAuthToken = response.getElement("authToken").getText();
        }
    }

    private void mailboxAuth() throws ServiceException, IOException {
        if (this.mVerbose > 0) {
            this.mOut.println("Sending auth request to " + this.mUrl);
        }
        SoapHttpTransport transport = new SoapHttpTransport(this.mUrl);
        transport.setDebugListener(this);
        Element auth = this.mFactory.createElement(AccountConstants.AUTH_REQUEST);
        Element account = auth.addElement(TYPE_ACCOUNT).setText(this.mMailboxName);
        account.addAttribute("by", "name");
        auth.addElement(LO_PASSWORD).setText(this.mPassword);
        Element response = null;
        response = transport.invoke(auth, false, !this.mUseSession, null);
        if (this.mVerbose > 0) {
            this.mOut.println(response.prettyPrint());
        }
        this.mAuthToken = response.getAttribute("authToken");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws ServiceException, IOException, DocumentException {
        Element request;
        Element element = null;
        InputStream in = null;
        String location = null;
        if (this.mFilePath != null) {
            in = new FileInputStream(this.mFilePath);
            location = this.mFilePath;
        } else if (this.mPaths.length > 0) {
            for (String path : this.mPaths) {
                element = this.processPath(element, path);
            }
        } else if (System.in.available() > 0) {
            in = System.in;
            location = "stdin";
        }
        if (in != null) {
            try {
                element = this.mUseJson ? Element.parseJSON(in) : Element.parseXML(in);
            }
            catch (IOException e) {
                System.err.format("Unable to read request from %s: %s.\n", location, e.getMessage());
                System.exit(1);
            }
            finally {
                ByteUtil.closeStream(in);
            }
        }
        if ((request = element) == null) {
            this.usage("No request element specified.");
        }
        while (request.getParent() != null) {
            request = request.getParent();
        }
        if (this.mVerbose == 1 || this.mNoOp) {
            this.mOut.println(request.prettyPrint());
        }
        if (this.mNoOp) {
            return;
        }
        if (this.mAdminAccountName != null) {
            this.adminAuth();
        } else {
            this.mailboxAuth();
        }
        SoapHttpTransport transport = new SoapHttpTransport(this.mUrl);
        transport.setDebugListener(this);
        transport.setTimeout(0);
        transport.setAuthToken(this.mAuthToken);
        if (!this.mType.equals("admin") && this.mTargetAccountName != null) {
            transport.setTargetAcctName(this.mTargetAccountName);
        }
        Element response = null;
        response = transport.invoke(request, false, !this.mUseSession, null);
        List<Element> results = null;
        String resultString = null;
        if (this.mSelect != null) {
            Element root = response.getFactory().createElement("root");
            response.detach();
            root.addElement(response);
            String[] parts = this.mSelect.split("/");
            if (parts.length > 0) {
                String lastPart = parts[parts.length - 1];
                if (lastPart.startsWith("@")) {
                    parts[parts.length - 1] = lastPart.substring(1);
                    resultString = root.getPathAttribute(parts);
                } else {
                    results = root.getPathElementList(parts);
                }
            }
        } else {
            results = new ArrayList<Element>();
            results.add(response);
        }
        if (this.mVerbose <= 1) {
            if (resultString == null && results != null) {
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (Element e : results) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append('\n');
                    }
                    buf.append(e.prettyPrint());
                }
                resultString = buf.toString();
            }
            if (resultString == null) {
                resultString = "";
            }
            this.mOut.println(resultString);
        }
    }

    private Element processPath(Element start, String path) {
        String value = null;
        if (path.contains("=")) {
            String[] parts = path.split("=");
            path = parts[0];
            value = parts[1];
        }
        Element element = start;
        String[] parts = path.split("/");
        String part = null;
        for (int i = 0; i < parts.length; ++i) {
            part = parts[i];
            if (element == null) {
                QName name = QName.get(part, this.mNamespace);
                element = this.mFactory.createElement(name);
                continue;
            }
            if (part.equals("..")) {
                element = element.getParent();
                continue;
            }
            if (part.startsWith("@")) continue;
            element = element.addElement(part);
        }
        if (value != null && part != null) {
            if (part.startsWith("@")) {
                String attrName = part.substring(1);
                element.addAttribute(attrName, value);
            } else {
                element.setText(value);
            }
        }
        return element;
    }

    private static String formatServiceException(ServiceException e) {
        Throwable cause = e.getCause();
        return "ERROR: " + e.getCode() + " (" + e.getMessage() + ")" + (cause == null ? "" : " (cause: " + cause.getClass().getName() + " " + cause.getMessage() + ")");
    }

    public static void main(String[] args) {
        CliUtil.toolSetup();
        SoapTransport.setDefaultUserAgent("zmsoap", null);
        SoapCommandUtil app = new SoapCommandUtil();
        try {
            app.parseCommandLine(args);
        }
        catch (ParseException e) {
            app.usage(e.getMessage());
        }
        try {
            app.run();
        }
        catch (ServiceException e) {
            System.err.println(SoapCommandUtil.formatServiceException(e));
            if (app.mVerbose > 0) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
        catch (Exception e) {
            if (app.mVerbose > 0) {
                e.printStackTrace(System.err);
            }
            System.err.println(e);
        }
    }

    static {
        sTypeToNamespace.put(TYPE_MAIL, Namespace.get("urn:zimbraMail"));
        sTypeToNamespace.put("admin", Namespace.get("urn:zimbraAdmin"));
        sTypeToNamespace.put(TYPE_ACCOUNT, Namespace.get("urn:zimbraAccount"));
        sTypeToNamespace.put(TYPE_IM, Namespace.get("urn:zimbraIM"));
        sTypeToNamespace.put(TYPE_MOBILE, Namespace.get("urn:zimbraSync"));
        sTypeToNamespace.put(TYPE_OFFLINE, Namespace.get("urn:zimbraOffline"));
    }
}

