/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.ZimbraNamespace;
import org.dom4j.Namespace;
import org.dom4j.QName;

class Soap12Protocol
extends SoapProtocol {
    private static final String NS_STR = "http://www.w3.org/2003/05/soap-envelope";
    private static final Namespace NS = Namespace.get("soap", "http://www.w3.org/2003/05/soap-envelope");
    private static final QName CODE = QName.get("Code", NS);
    private static final QName REASON = QName.get("Reason", NS);
    private static final QName TEXT = QName.get("Text", NS);
    private static final QName DETAIL = QName.get("Detail", NS);
    private static final QName VALUE = QName.get("Value", NS);
    private static final QName SENDER_CODE = QName.get("Sender", NS);
    private static final QName RECEIVER_CODE = QName.get("Receiver", NS);

    Soap12Protocol() {
    }

    public Element.ElementFactory getFactory() {
        return Element.XMLElement.mFactory;
    }

    public Namespace getNamespace() {
        return NS;
    }

    public SoapFaultException soapFault(Element fault) {
        Element reason;
        if (!this.isFault(fault)) {
            return new SoapFaultException("not a soap fault ", fault);
        }
        boolean isReceiversFault = false;
        Element code = fault.getOptionalElement(CODE);
        if (code != null) {
            Element value = code.getOptionalElement(VALUE);
            isReceiversFault = RECEIVER_CODE.getQualifiedName().equals(value == null ? null : value.getTextTrim());
        }
        Element reasonText = (reason = fault.getOptionalElement(REASON)) == null ? null : reason.getOptionalElement(TEXT);
        String reasonValue = reasonText != null ? reasonText.getTextTrim() : "unknown reason";
        Element detail = fault.getOptionalElement(DETAIL);
        return new SoapFaultException(reasonValue, detail, isReceiversFault, fault);
    }

    public Element soapFault(ServiceException e) {
        String reason = e.getMessage();
        if (reason == null) {
            reason = e.toString();
        }
        QName code = e.isReceiversFault() ? RECEIVER_CODE : SENDER_CODE;
        Element eFault = this.mFactory.createElement(this.mFaultQName);
        Element eCode = eFault.addUniqueElement(CODE);
        eCode.addUniqueElement(VALUE).setText(code.getQualifiedName());
        Element eReason = eFault.addUniqueElement(REASON);
        eReason.addUniqueElement(TEXT).setText(reason);
        Element eDetail = eFault.addUniqueElement(DETAIL);
        Element error = eDetail.addUniqueElement(ZimbraNamespace.E_ERROR);
        error.addUniqueElement(ZimbraNamespace.E_CODE).setText(e.getCode());
        error.addUniqueElement(ZimbraNamespace.E_TRACE).setText(e.getId());
        if (e.getArgs() != null) {
            for (ServiceException.Argument arg : e.getArgs()) {
                if (!arg.externalVisible()) continue;
                Element val = error.addElement(ZimbraNamespace.E_ARGUMENT);
                val.addAttribute("n", arg.mName);
                val.addAttribute("t", arg.mType.toString());
                val.setText(arg.mValue);
            }
        }
        return eFault;
    }

    public String getContentType() {
        return "text/xml; charset=utf-8";
    }

    public boolean hasSOAPActionHeader() {
        return false;
    }

    public String getVersion() {
        return "1.2.";
    }
}

