/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.soap.ZimbraNamespace;
import org.dom4j.Namespace;
import org.dom4j.QName;

class Soap11Protocol
extends SoapProtocol {
    private static final String NS_STR = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final Namespace NS = Namespace.get("soap", "http://schemas.xmlsoap.org/soap/envelope/");
    private static final QName FAULTCODE = new QName("faultcode", NS);
    private static final QName FAULTSTRING = new QName("faultstring", NS);
    private static final QName DETAIL = new QName("detail", NS);
    private static final QName SENDER_CODE = new QName("Client", NS);
    private static final QName RECEIVER_CODE = new QName("Server", NS);

    Soap11Protocol() {
    }

    public Element.ElementFactory getFactory() {
        return Element.XMLElement.mFactory;
    }

    public Namespace getNamespace() {
        return NS;
    }

    public SoapFaultException soapFault(Element fault) {
        if (!this.isFault(fault)) {
            return new SoapFaultException("not a soap fault ", fault);
        }
        Element code = fault.getOptionalElement(FAULTCODE);
        boolean isReceiversFault = RECEIVER_CODE.equals(code == null ? null : code.getQName());
        Element faultString = fault.getOptionalElement(FAULTSTRING);
        String reasonValue = faultString != null ? faultString.getTextTrim() : "unknown reason";
        Element detail = fault.getOptionalElement(DETAIL);
        return new SoapFaultException(reasonValue, detail, isReceiversFault, fault);
    }

    public Element soapFault(ServiceException e) {
        String reason = e.getMessage();
        if (reason == null) {
            reason = e.toString();
        }
        QName code = e.isReceiversFault() ? RECEIVER_CODE : SENDER_CODE;
        Element eFault = this.mFactory.createElement(this.mFaultQName);
        eFault.addUniqueElement(FAULTCODE).setText(code.getQualifiedName());
        eFault.addUniqueElement(FAULTSTRING).setText(reason);
        Element eDetail = eFault.addUniqueElement(DETAIL);
        Element error = eDetail.addUniqueElement(ZimbraNamespace.E_ERROR);
        error.addUniqueElement(ZimbraNamespace.E_CODE).setText(e.getCode());
        error.addUniqueElement(ZimbraNamespace.E_TRACE).setText(e.getId());
        if (e.getArgs() != null) {
            for (ServiceException.Argument arg : e.getArgs()) {
                if (!arg.externalVisible()) continue;
                Element val = error.addElement(ZimbraNamespace.E_ARGUMENT);
                val.addAttribute("n", arg.mName);
                val.addAttribute("t", arg.mType.toString());
                val.setText(arg.mValue);
            }
        }
        return eFault;
    }

    public String getContentType() {
        return "text/xml; charset=utf-8";
    }

    public boolean hasSOAPActionHeader() {
        return true;
    }

    public String getVersion() {
        return "1.1.";
    }
}

