/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.soap;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapParseException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultDocument;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element
implements Cloneable {
    protected String mName;
    protected String mPrefix = "";
    protected Element mParent;
    protected Map<String, Object> mAttributes;
    protected Map<String, String> mNamespaces;
    private static ThreadLocal<DocumentFactory> mDocumentFactory = new ThreadLocal<DocumentFactory>(){

        @Override
        protected synchronized DocumentFactory initialValue() {
            return new DocumentFactory();
        }
    };
    private static final String FORTY_SPACES = "                                        ";
    private static final String XHTML_NS_URI = "http://www.w3.org/1999/xhtml";

    public static Element create(SoapProtocol proto, String name) throws ServiceException {
        if (proto == SoapProtocol.SoapJS) {
            return new JSONElement(name);
        }
        if (proto == SoapProtocol.Soap11 || proto == SoapProtocol.Soap12) {
            return new XMLElement(name);
        }
        throw ServiceException.INVALID_REQUEST("Unknown SoapProtocol: " + proto, null);
    }

    public static Element create(SoapProtocol proto, QName qname) throws ServiceException {
        if (proto == SoapProtocol.SoapJS) {
            return new JSONElement(qname);
        }
        if (proto == SoapProtocol.Soap11 || proto == SoapProtocol.Soap12) {
            return new XMLElement(qname);
        }
        throw ServiceException.INVALID_REQUEST("Unknown SoapProtocol: " + proto, null);
    }

    public abstract ElementFactory getFactory();

    public abstract Element addElement(String var1) throws ContainerException;

    public abstract Element addElement(QName var1) throws ContainerException;

    public abstract Element addElement(Element var1) throws ContainerException;

    public Element addUniqueElement(String name) throws ContainerException {
        return this.addElement(name);
    }

    public Element addUniqueElement(QName qname) throws ContainerException {
        return this.addElement(qname);
    }

    public Element addUniqueElement(Element elt) throws ContainerException {
        return this.addElement(elt);
    }

    protected Element setNamespace(String prefix, String uri) {
        if (prefix != null && uri != null && !uri.equals("")) {
            if (this.mNamespaces == null) {
                this.mNamespaces = new HashMap<String, String>();
            }
            this.mNamespaces.put(prefix, uri);
        }
        return this;
    }

    public abstract Element setText(String var1) throws ContainerException;

    public Element addText(String content) throws ContainerException {
        return this.setText(this.getText() + content);
    }

    public Element addAttribute(String key, String value) throws ContainerException {
        return this.addAttribute(key, value, Disposition.ATTRIBUTE);
    }

    public Element addAttribute(String key, long value) throws ContainerException {
        return this.addAttribute(key, value, Disposition.ATTRIBUTE);
    }

    public Element addAttribute(String key, double value) throws ContainerException {
        return this.addAttribute(key, value, Disposition.ATTRIBUTE);
    }

    public Element addAttribute(String key, boolean value) throws ContainerException {
        return this.addAttribute(key, value, Disposition.ATTRIBUTE);
    }

    public abstract Element addAttribute(String var1, String var2, Disposition var3) throws ContainerException;

    public Element addAttribute(String key, long value, Disposition disp) throws ContainerException {
        return this.addAttribute(key, Long.toString(value), disp);
    }

    public Element addAttribute(String key, double value, Disposition disp) throws ContainerException {
        return this.addAttribute(key, Double.toString(value), disp);
    }

    public Element addAttribute(String key, boolean value, Disposition disp) throws ContainerException {
        return this.addAttribute(key, value ? "1" : "0", disp);
    }

    public KeyValuePair addKeyValuePair(String key, String value) throws ContainerException {
        return this.addKeyValuePair(key, value, null, null);
    }

    public abstract KeyValuePair addKeyValuePair(String var1, String var2, String var3, String var4) throws ContainerException;

    protected void detach(Element child) throws ContainerException {
        if (child == null) {
            return;
        }
        if (child.mParent != this) {
            throw new ContainerException("wrong parent");
        }
        child.mParent = null;
    }

    public Element detach() throws ContainerException {
        this.setNamespace(this.mPrefix, this.getNamespaceURI(this.mPrefix));
        if (this.mParent != null) {
            this.mParent.detach(this);
        }
        return this;
    }

    public abstract Element clone();

    public String getName() {
        return this.mName;
    }

    public String getQualifiedName() {
        return this.mPrefix != null && !this.mPrefix.equals("") ? this.mPrefix + ':' + this.mName : this.mName;
    }

    public QName getQName() {
        String uri = this.getNamespaceURI(this.mPrefix);
        return uri == null ? QName.get(this.mName) : QName.get(this.getQualifiedName(), uri);
    }

    public static QName getQName(String qualifiedName) {
        String[] parts = qualifiedName.split("\\.");
        return new QName(parts[parts.length - 1]);
    }

    public Element getParent() {
        return this.mParent;
    }

    public Element getElement(String name) throws ServiceException {
        return this.checkNull(name, this.getOptionalElement(name));
    }

    public Element getElement(QName qname) throws ServiceException {
        return this.checkNull(qname.getName(), this.getOptionalElement(qname));
    }

    public abstract Element getOptionalElement(String var1);

    public Element getOptionalElement(QName qname) {
        return this.getOptionalElement(qname.getName());
    }

    public abstract Set<Attribute> listAttributes();

    public List<Element> listElements() {
        return this.listElements(null);
    }

    public abstract List<Element> listElements(String var1);

    public List<KeyValuePair> listKeyValuePairs() {
        return this.listKeyValuePairs(null, null);
    }

    public abstract List<KeyValuePair> listKeyValuePairs(String var1, String var2);

    public Iterator<Attribute> attributeIterator() {
        return this.listAttributes().iterator();
    }

    public Iterator<Element> elementIterator() {
        return this.listElements().iterator();
    }

    public Iterator<Element> elementIterator(String name) {
        return this.listElements(name).iterator();
    }

    public abstract String getText();

    abstract String getRawText();

    public String getTextTrim() {
        return this.getText().trim().replaceAll("\\s+", " ");
    }

    public String getAttribute(String key) throws ServiceException {
        return Element.checkNull(key, this.getAttribute(key, null));
    }

    public long getAttributeLong(String key) throws ServiceException {
        return Element.parseLong(key, Element.checkNull(key, this.getAttribute(key, null)));
    }

    public double getAttributeDouble(String key) throws ServiceException {
        return Element.parseDouble(key, Element.checkNull(key, this.getAttribute(key, null)));
    }

    public boolean getAttributeBool(String key) throws ServiceException {
        return Element.parseBool(key, Element.checkNull(key, this.getAttribute(key, null)));
    }

    public abstract String getAttribute(String var1, String var2);

    public long getAttributeLong(String key, long defaultValue) throws ServiceException {
        String raw = this.getAttribute(key, null);
        return raw == null ? defaultValue : Element.parseLong(key, raw);
    }

    public double getAttributeDouble(String key, double defaultValue) throws ServiceException {
        String raw = this.getAttribute(key, null);
        return raw == null ? defaultValue : Element.parseDouble(key, raw);
    }

    public boolean getAttributeBool(String key, boolean defaultValue) throws ServiceException {
        String raw = this.getAttribute(key, null);
        return raw == null ? defaultValue : Element.parseBool(key, raw);
    }

    protected String getNamespaceURI(String prefix) {
        String uri;
        if (this.mNamespaces != null && (uri = this.mNamespaces.get(prefix)) != null && !uri.trim().equals("")) {
            return uri;
        }
        return this.mParent == null ? null : this.mParent.getNamespaceURI(prefix);
    }

    protected Element collapseNamespace() {
        String localURI;
        if (this.mNamespaces != null && this.mParent != null && this.mParent.mPrefix.equals(this.mPrefix) && (localURI = this.mNamespaces.get(this.mPrefix)) != null && localURI.equals(this.mParent.getNamespaceURI(this.mPrefix))) {
            this.mNamespaces.remove(this.mPrefix);
            if (this.mNamespaces.isEmpty()) {
                this.mNamespaces = null;
            }
        }
        return this;
    }

    public static String checkNull(String key, String value) throws ServiceException {
        if (value == null) {
            throw ServiceException.INVALID_REQUEST("missing required attribute: " + key, null);
        }
        return value;
    }

    private Element checkNull(String key, Element value) throws ServiceException {
        if (value == null) {
            throw ServiceException.INVALID_REQUEST("missing required element: " + key, null);
        }
        return value;
    }

    public static long parseLong(String key, String value) throws ServiceException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw ServiceException.INVALID_REQUEST("invalid long value '" + value + "' for attribute: " + key, nfe);
        }
    }

    public static double parseDouble(String key, String value) throws ServiceException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw ServiceException.INVALID_REQUEST("invalid double value '" + value + "' for attribute: " + key, nfe);
        }
    }

    public static boolean parseBool(String key, String value) throws ServiceException {
        if (value.equals("1") || value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equals("0") || value.equalsIgnoreCase("false")) {
            return false;
        }
        throw ServiceException.INVALID_REQUEST("invalid boolean value '" + value + "' for attribute: " + key, null);
    }

    protected boolean namespaceDeclarationNeeded(String prefix, String uri) {
        if (this.mParent == null || this.getClass() != this.mParent.getClass()) {
            return true;
        }
        String thatURI = this.mParent.getNamespaceURI(prefix);
        return thatURI == null || !thatURI.equals(uri);
    }

    public byte[] toUTF8() {
        try {
            return this.toString().getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public void output(Appendable out) throws IOException {
        this.toString(out);
    }

    public abstract String prettyPrint();

    public abstract void toString(Appendable var1) throws IOException;

    protected void indent(Appendable sb, int indent, boolean newline) throws IOException {
        if (indent < 0) {
            return;
        }
        if (newline) {
            sb.append('\n');
        }
        while (indent > 40) {
            sb.append(FORTY_SPACES);
            indent -= 40;
        }
        if (indent > 0) {
            sb.append(FORTY_SPACES.substring(40 - indent));
        }
    }

    public org.dom4j.Element toXML() {
        DefaultDocument doc = new DefaultDocument();
        doc.setRootElement(this.toXML(null));
        return doc.getRootElement();
    }

    private org.dom4j.Element toXML(org.dom4j.Element d4parent) {
        org.dom4j.Element d4elt = d4parent == null ? DocumentHelper.createElement(this.getQName()) : d4parent.addElement(this.getQName());
        for (Attribute attr : this.listAttributes()) {
            d4elt.addAttribute(attr.getKey(), attr.getValue());
        }
        for (Element elt : this.listElements()) {
            elt.toXML(d4elt);
        }
        d4elt.setText(this.getText());
        return d4elt;
    }

    public String getPathAttribute(String[] xpath) {
        Element cur;
        int depth = 0;
        for (cur = this; depth < xpath.length - 1 && cur != null; cur = cur.getOptionalElement(xpath[depth++])) {
        }
        return cur == null ? null : cur.getAttribute(xpath[depth], null);
    }

    public Element getPathElement(String[] xpath) {
        Element cur;
        int depth = 0;
        for (cur = this; depth < xpath.length && cur != null; cur = cur.getOptionalElement(xpath[depth++])) {
        }
        return cur;
    }

    public List<Element> getPathElementList(String[] xpath) {
        Element cur;
        int depth = 0;
        for (cur = this; depth < xpath.length - 1 && cur != null; cur = cur.getOptionalElement(xpath[depth++])) {
        }
        if (cur == null) {
            return null;
        }
        return cur.listElements(xpath[xpath.length - 1]);
    }

    public void setPathAttribute(String[] xpath, String value) throws ServiceException {
        Element cur;
        if (xpath == null || xpath.length == 0) {
            return;
        }
        int depth = 0;
        for (cur = this; depth < xpath.length - 1 && cur != null; cur = cur.getOptionalElement(xpath[depth++])) {
        }
        if (cur == null) {
            throw ServiceException.INVALID_REQUEST("could not find path", null);
        }
        cur.addAttribute(xpath[depth], value);
    }

    public static Element parseJSON(InputStream is) throws SoapParseException {
        return Element.parseJSON(is, JSONElement.mFactory);
    }

    public static Element parseJSON(InputStream is, ElementFactory factory) throws SoapParseException {
        try {
            return Element.parseJSON(new String(ByteUtil.getContent(is, -1), "utf-8"), factory);
        }
        catch (SoapParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SoapParseException("could not transcode request from utf-8", null);
        }
    }

    public static Element parseJSON(String js) throws SoapParseException {
        return Element.parseJSON(js, JSONElement.mFactory);
    }

    public static Element parseJSON(String js, ElementFactory factory) throws SoapParseException {
        try {
            return JSONElement.parseElement(new JSONElement.JSRequest(js), SoapProtocol.SoapJS.getEnvelopeQName(), factory);
        }
        catch (ContainerException ce) {
            SoapParseException spe = new SoapParseException(ce.getMessage(), js);
            spe.initCause(ce);
            throw spe;
        }
    }

    public static Element parseXML(InputStream is) throws DocumentException {
        return Element.parseXML(is, XMLElement.mFactory);
    }

    public static Element parseXML(InputStream is, ElementFactory factory) throws DocumentException {
        return Element.convertDOM(Element.getSAXReader(mDocumentFactory.get()).read(is).getRootElement(), factory);
    }

    public static Element parseXML(String xml) throws DocumentException {
        return Element.parseXML(xml, XMLElement.mFactory);
    }

    public static Element parseXML(String xml, ElementFactory factory) throws DocumentException {
        return Element.convertDOM(Element.getSAXReader(mDocumentFactory.get()).read(new StringReader(xml)).getRootElement(), factory);
    }

    public static SAXReader getSAXReader() {
        return Element.getSAXReader(null);
    }

    public static SAXReader getSAXReader(DocumentFactory fact) {
        SAXReader saxReader = fact != null ? new SAXReader(fact) : new SAXReader();
        EntityResolver nullEntityResolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        };
        saxReader.setEntityResolver(nullEntityResolver);
        return saxReader;
    }

    public static Element convertDOM(org.dom4j.Element d4root) {
        return Element.convertDOM(d4root, XMLElement.mFactory);
    }

    public static Element convertDOM(org.dom4j.Element d4root, ElementFactory factory) {
        Element elt = factory.createElement(d4root.getQName());
        Iterator it = d4root.attributeIterator();
        while (it.hasNext()) {
            org.dom4j.Attribute d4attr = (org.dom4j.Attribute)it.next();
            elt.addAttribute(d4attr.getQualifiedName(), d4attr.getValue());
        }
        String content = null;
        Iterator it2 = d4root.elementIterator();
        while (it2.hasNext()) {
            org.dom4j.Element d4elt = (org.dom4j.Element)it2.next();
            if (XHTML_NS_URI.equalsIgnoreCase(d4elt.getNamespaceURI()) && !d4elt.elements().isEmpty()) {
                content = content == null ? d4elt.asXML() : content + d4elt.asXML();
                continue;
            }
            elt.addElement(Element.convertDOM(d4elt, factory));
        }
        if (content == null) {
            content = d4root.getText();
        }
        if (content != null && !content.trim().equals("")) {
            elt.setText(content);
        }
        return elt;
    }

    public static void main(String[] args) throws ContainerException, SoapParseException {
        System.out.println(Element.parseJSON("{ 'a':'b'}").getAttribute("a", null));
        System.out.println(Element.parseJSON("{ '_attrs' : {'a':'b'}}").getAttribute("a", null));
        System.out.println(Element.parseJSON("{foo:' bar'}").getAttribute("foo", null));
        System.out.println(Element.parseJSON("{foo:'bar'}").getAttribute("foo", null));
        System.out.println(Element.parseJSON("{foo:''}").getAttribute("foo", null));
        System.out.println(Element.parseJSON("{ \"items\" : [ ] }"));
        System.out.println(Element.parseJSON("{ '_attrs' : {'a':[]}}").getAttribute("a", null));
        Namespace bogusNS = Namespace.get("bogus", "");
        QName qm = new QName("m", bogusNS);
        SoapProtocol proto = SoapProtocol.SoapJS;
        Element ctxt = new JSONElement(proto.getHeaderQName()).addUniqueElement("context");
        ctxt.addElement("session").setText("3").addAttribute("id", 3L);
        System.out.println(ctxt.getAttribute("session", null));
        Element env = Element.testMessage(new JSONElement(proto.getEnvelopeQName()), proto, qm);
        System.out.println(env);
        System.out.println(Element.parseJSON(env.toString()));
        proto = SoapProtocol.Soap12;
        env = Element.testMessage(new XMLElement(proto.getEnvelopeQName()), proto, qm);
        System.out.println(env.prettyPrint());
        System.out.println("             name: " + env.getName());
        System.out.println("   qualified name: " + env.getQualifiedName());
        System.out.println("            qname: " + env.getQName());
        Element e = Element.testContacts(new JSONElement(MailConstants.GET_CONTACTS_RESPONSE));
        System.out.println(e);
        System.out.println(e.prettyPrint());
        Element.testKeyValuePairs(e);
        System.out.println(Element.parseJSON(e.toString()));
        Element.testKeyValuePairs(Element.parseJSON(e.toString()));
        System.out.println(Element.parseJSON(e.toString(), XMLElement.mFactory).prettyPrint());
        e = Element.testContacts(new XMLElement(MailConstants.GET_CONTACTS_RESPONSE));
        System.out.println(e.prettyPrint());
        for (Element elt : e.listElements()) {
            System.out.println("  found: id=" + elt.getAttribute("ID", null));
        }
        Element.testKeyValuePairs(e);
        System.out.println(new XMLElement("test").setText("  this\t    is\nthe\rway ").getTextTrim() + "|");
        System.out.println(Element.parseJSON("{part:\"TEXT\",t:null,h:true,i:\"false\",\"ct\":\"\\x25multipart\\u0025\\/mixed\",\\u0073:3718}").toString());
        try {
            Element.parseJSON("{\"wkday\":{\"day\":\"TU\"},\"wkday\":{\"day\":\"WE\"},\"wkday\":{\"day\":\"FR\"}}");
        }
        catch (SoapParseException spe) {
            System.out.println("caught exception (expected): " + spe.getMessage());
        }
    }

    private static Element testMessage(Element env, SoapProtocol proto, QName qm) {
        env.addUniqueElement(proto.getBodyQName()).addUniqueElement(MailConstants.GET_MSG_RESPONSE).addUniqueElement(qm).addAttribute("id", 1115L).addAttribute("f", "aw").addAttribute("t", "64,67").addAttribute("score", 0.953).addAttribute("s", "Subject of the message has a \"\\\" in it", Disposition.CONTENT).addAttribute("mid", "<kashdfgiai67r3wtuwfg@goo.com>", Disposition.CONTENT).addElement("mp").addAttribute("part", "TEXT").addAttribute("ct", "multipart/mixed").addAttribute("s", 3718L);
        String orig = env.toString();
        String clone = env.clone().toString();
        System.out.println("< " + orig);
        System.out.println("> " + clone);
        return env;
    }

    private static Element testContacts(Element parent) {
        parent.addElement("cn");
        Element cn = parent.addElement("cn").addAttribute("id", 256L).addAttribute("md", 1111196674000L).addAttribute("l", 7L).addAttribute("x", false);
        cn.addKeyValuePair("workPhone", "(408) 973-0500 x112", "pm", "name");
        cn.addKeyValuePair("notes", "These are &\nrandom notes", "pm", "name");
        cn.addKeyValuePair("firstName", "Ross \"Killa\"", "pm", "name");
        cn.addKeyValuePair("lastName", "Dargahi", "pm", "name");
        cn.addKeyValuePair("lastName", "Dangerous", "pm", "name");
        cn.addKeyValuePair("image", null, "pm", "name").addAttribute("size", 34102L).addAttribute("ct", "image/png").addAttribute("part", "1");
        cn = parent.addElement("cn").addAttribute("id", 257L).addAttribute("md", 1111196674000L).addAttribute("l", 7L);
        cn.addKeyValuePair("workPhone", "(408) 973-0500 x111");
        cn.addKeyValuePair("jobTitle", "CEO");
        cn.addKeyValuePair("firstName", "Satish");
        cn.addKeyValuePair("lastName", "Dharmaraj");
        cn.addKeyValuePair("foo=bar", "baz=whop");
        if (!parent.toString().equals(parent.clone().toString())) {
            System.out.println("error: clone diverges from parent");
        }
        return parent;
    }

    private static void testKeyValuePairs(Element parent) {
        for (Element cn : parent.listElements()) {
            for (KeyValuePair kvp : cn.listKeyValuePairs("pm", "name")) {
                System.out.print("   " + kvp.getKey() + ": " + kvp.getValue());
            }
        }
        System.out.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XMLElement
    extends Element {
        private String mText;
        private List<Element> mChildren;
        public static final ElementFactory mFactory = new XMLFactory();
        public static final String E_ATTRIBUTE = "a";
        public static final String A_ATTR_NAME = "n";
        private static final String A_NAMESPACE = "xmlns";
        private static final int INDENT_SIZE = 2;

        public XMLElement(String name) throws ContainerException {
            this.mName = this.validateName(name);
        }

        public XMLElement(QName qname) throws ContainerException {
            this.mName = this.validateName(qname.getName());
            String uri = qname.getNamespaceURI();
            if (uri == null || uri.equals("")) {
                return;
            }
            this.mPrefix = qname.getNamespacePrefix();
            this.setNamespace(this.mPrefix, uri);
        }

        @Override
        public ElementFactory getFactory() {
            return mFactory;
        }

        @Override
        public Element addElement(String name) throws ContainerException {
            return this.addElement(new XMLElement(name));
        }

        @Override
        public Element addElement(QName qname) throws ContainerException {
            return this.addElement(new XMLElement(qname));
        }

        @Override
        public Element addElement(Element elt) throws ContainerException {
            if (elt == null || elt.mParent == this) {
                return elt;
            }
            if (elt.mParent != null) {
                throw new ContainerException("element already has a parent");
            }
            if (this.mText != null) {
                throw new ContainerException("cannot add children to element containing text");
            }
            if (this.mChildren == null) {
                this.mChildren = new ArrayList<Element>();
            }
            this.mChildren.add(elt);
            elt.mParent = this;
            return elt.collapseNamespace();
        }

        @Override
        public Element setText(String content) throws ContainerException {
            if (content != null && !content.trim().equals("")) {
                if (this.mChildren != null) {
                    throw new ContainerException("cannot set text on element with children");
                }
            } else {
                content = null;
            }
            this.mText = content;
            return this;
        }

        @Override
        public Element addAttribute(String key, String value, Disposition disp) throws ContainerException {
            this.validateName(key);
            if (value == null) {
                return this;
            }
            if (disp == Disposition.CONTENT) {
                this.addElement(key).setText(value);
            } else {
                if (this.mAttributes == null) {
                    this.mAttributes = new HashMap();
                }
                this.mAttributes.put(key, value);
            }
            return this;
        }

        @Override
        public KeyValuePair addKeyValuePair(String key, String value, String eltname, String attrname) throws ContainerException {
            return new XMLKeyValuePair(key, value, eltname == null ? E_ATTRIBUTE : this.validateName(eltname), attrname == null ? A_ATTR_NAME : this.validateName(attrname));
        }

        private String validateName(String name) throws ContainerException {
            if (name == null || name.equals("")) {
                throw new ContainerException("blank/missing XML attribute name");
            }
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == ':' || c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || i > 0 && (c == '-' || c == '.' || c >= '0' && c <= '9' || c == '\u00b7' || c == '\u203f' || c == '\u2040') || c >= '\u00c0' && c <= '\u1fff' && c != '\u00d7' && c != '\u00f7' && c != '\u037e' && (i > 0 || c < '\u0300' || c > '\u036f') || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd' || c >= '\u10000' && c <= '\ueffff') continue;
                throw new ContainerException("invalid XML attribute name: " + name);
            }
            return name;
        }

        @Override
        protected void detach(Element elt) throws ContainerException {
            super.detach(elt);
            if (this.mChildren != null) {
                this.mChildren.remove(elt);
                if (this.mChildren.size() == 0) {
                    this.mChildren = null;
                }
            }
        }

        @Override
        public Element getOptionalElement(String name) {
            if (this.mChildren != null && name != null) {
                for (Element elt : this.mChildren) {
                    if (!elt.getName().equals(name)) continue;
                    return elt;
                }
            }
            return null;
        }

        @Override
        public Element getOptionalElement(QName qname) {
            if (this.mChildren != null && qname != null) {
                for (Element elt : this.mChildren) {
                    if (!elt.getQName().equals(qname)) continue;
                    return elt;
                }
            }
            return null;
        }

        @Override
        public Set<Attribute> listAttributes() {
            if (this.mAttributes == null || this.mAttributes.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<Attribute> set = new HashSet<Attribute>();
            for (Map.Entry<String, Object> entry : this.mAttributes.entrySet()) {
                set.add(new Attribute(entry, this));
            }
            return set;
        }

        @Override
        public List<Element> listElements(String name) {
            if (this.mChildren == null) {
                return Collections.emptyList();
            }
            ArrayList<Element> list = new ArrayList<Element>();
            if (name == null || name.trim().equals("")) {
                list.addAll(this.mChildren);
            } else {
                for (Element elt : this.mChildren) {
                    if (!elt.getName().equals(name)) continue;
                    list.add(elt);
                }
            }
            return list;
        }

        @Override
        public List<KeyValuePair> listKeyValuePairs(String eltname, String attrname) {
            eltname = eltname == null ? E_ATTRIBUTE : this.validateName(eltname);
            attrname = attrname == null ? A_ATTR_NAME : this.validateName(attrname);
            ArrayList<KeyValuePair> pairs = new ArrayList<KeyValuePair>();
            for (Element elt : this.listElements(eltname)) {
                String key = elt.getAttribute(attrname, null);
                if (key == null) continue;
                pairs.add(new XMLKeyValuePair(key, elt.getText(), eltname, attrname, false));
            }
            return pairs;
        }

        @Override
        public String getText() {
            return this.mText == null ? "" : this.mText;
        }

        @Override
        String getRawText() {
            return this.mText;
        }

        @Override
        public String getAttribute(String key, String defaultValue) {
            String result;
            if (key == null) {
                return defaultValue;
            }
            if (this.mAttributes != null && ((result = (String)this.mAttributes.get(key)) != null || (result = (String)this.mAttributes.get(key.toLowerCase())) != null)) {
                return result;
            }
            if (this.mChildren == null) {
                return defaultValue;
            }
            for (Element elt : this.mChildren) {
                if (elt.getName().equalsIgnoreCase(key)) {
                    return elt.getText();
                }
                if (!elt.getName().equals(E_ATTRIBUTE) || !elt.getAttribute(A_ATTR_NAME, "").equalsIgnoreCase(key)) continue;
                return elt.getText();
            }
            return defaultValue;
        }

        private String xmlEncode(String str, boolean escapeQuotes) {
            int i;
            if (str == null) {
                return "";
            }
            StringBuffer sb = null;
            int last = -1;
            block7: for (i = 0; i < str.length(); ++i) {
                String replacement;
                char c = str.charAt(i);
                switch (c) {
                    case '&': {
                        replacement = "&amp;";
                        break;
                    }
                    case '<': {
                        replacement = "&lt;";
                        break;
                    }
                    case '>': {
                        if (i < 2 || str.charAt(i - 1) != ']' || str.charAt(i - 2) != ']') continue block7;
                        replacement = "&gt;";
                        break;
                    }
                    case '\"': {
                        if (!escapeQuotes) continue block7;
                        replacement = "&quot;";
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        continue block7;
                    }
                    default: {
                        if (c >= ' ' && c != '\ufffe' && c != '\uffff' && (c <= '\ud7ff' || c >= '\ue000')) continue block7;
                        replacement = "?";
                    }
                }
                if (sb == null) {
                    sb = new StringBuffer(str.substring(0, i));
                } else {
                    sb.append(str.substring(last, i));
                }
                sb.append(replacement);
                last = i + 1;
            }
            return sb == null ? str : sb.append(str.substring(last, i)).toString();
        }

        @Override
        public XMLElement clone() {
            XMLElement clone = new XMLElement(this.getQName());
            clone.mText = this.mText;
            if (this.mAttributes != null) {
                clone.mAttributes = new HashMap(this.mAttributes);
            }
            if (this.mNamespaces != null) {
                if (clone.mNamespaces == null) {
                    clone.mNamespaces = new HashMap(this.mNamespaces);
                } else {
                    clone.mNamespaces.putAll(this.mNamespaces);
                }
            }
            if (this.mChildren != null) {
                for (Element child : this.mChildren) {
                    clone.addElement(child.clone());
                }
            }
            return clone;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            try {
                this.toString(sb, -1);
            }
            catch (IOException e) {
                ZimbraLog.soap.error((Object)"Caught IOException: ", e);
            }
            return sb.toString();
        }

        @Override
        public void toString(Appendable out) throws IOException {
            this.toString(out, -1);
        }

        @Override
        public String prettyPrint() {
            StringBuffer sb = new StringBuffer();
            try {
                this.toString(sb, 0);
            }
            catch (IOException e) {
                ZimbraLog.soap.error((Object)"Caught IOException: ", e);
            }
            return sb.toString();
        }

        private void toString(Appendable sb, int indent) throws IOException {
            this.indent(sb, indent, indent > 0);
            String qn = this.getQualifiedName();
            sb.append("<").append(qn);
            if (this.mAttributes != null) {
                for (Map.Entry attr : this.mAttributes.entrySet()) {
                    sb.append(' ').append((CharSequence)attr.getKey()).append("=\"").append(this.xmlEncode((String)attr.getValue(), true)).append('\"');
                }
            }
            if (this.mNamespaces != null) {
                for (Map.Entry ns : this.mNamespaces.entrySet()) {
                    String uri;
                    String prefix = (String)ns.getKey();
                    if (!this.namespaceDeclarationNeeded(prefix, uri = (String)ns.getValue())) continue;
                    sb.append(' ').append(A_NAMESPACE).append(prefix.equals("") ? "" : ":").append(prefix).append("=\"").append(this.xmlEncode(uri, true)).append('\"');
                }
            }
            if (this.mChildren != null || this.mText != null) {
                sb.append('>');
                if (this.mChildren != null) {
                    for (Element child : this.mChildren) {
                        if (child instanceof XMLElement) {
                            ((XMLElement)child).toString(sb, indent < 0 ? -1 : indent + 2);
                            continue;
                        }
                        sb.append(this.xmlEncode(child.toString(), false));
                    }
                    this.indent(sb, indent, true);
                } else {
                    sb.append(this.xmlEncode(this.mText, false));
                }
                sb.append("</").append(qn).append('>');
            } else {
                sb.append("/>");
            }
        }

        private final class XMLKeyValuePair
        implements KeyValuePair {
            private final XMLElement mTarget;
            private final String mAttrName;

            XMLKeyValuePair(String key, String value, String eltname, String attrname) {
                this(key, value, eltname, attrname, true);
            }

            XMLKeyValuePair(String key, String value, String eltname, String attrname, boolean register) {
                this.mTarget = new XMLElement(eltname);
                this.mAttrName = attrname;
                this.mTarget.addAttribute(this.mAttrName, key).setText(value);
                if (register) {
                    XMLElement.this.addElement(this.mTarget);
                }
            }

            public KeyValuePair setValue(String value) throws ContainerException {
                this.mTarget.setText(value);
                return this;
            }

            public KeyValuePair addAttribute(String key, String value) throws ContainerException {
                this.mTarget.addAttribute(key, value);
                return this;
            }

            public KeyValuePair addAttribute(String key, long value) throws ContainerException {
                this.mTarget.addAttribute(key, value);
                return this;
            }

            public KeyValuePair addAttribute(String key, double value) throws ContainerException {
                this.mTarget.addAttribute(key, value);
                return this;
            }

            public KeyValuePair addAttribute(String key, boolean value) throws ContainerException {
                this.mTarget.addAttribute(key, value);
                return this;
            }

            public String getKey() throws ContainerException {
                return this.mTarget.getAttribute(this.mAttrName, null);
            }

            public String getValue() throws ContainerException {
                return this.mTarget.getRawText();
            }

            public String toString() {
                return this.mTarget.toString();
            }
        }

        private static final class XMLFactory
        implements ElementFactory {
            XMLFactory() {
            }

            public Element createElement(String name) {
                return new XMLElement(name);
            }

            public Element createElement(QName qname) {
                return new XMLElement(qname);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JSONElement
    extends Element {
        public static final ElementFactory mFactory = new JSONFactory();
        private static final String E_ATTRS = "_attrs";
        private static final String A_CONTENT = "_content";
        private static final String A_NAMESPACE = "_jsns";
        private static final int INDENT_SIZE = 2;

        public JSONElement(String name) {
            this.mName = name;
            this.mAttributes = new LinkedHashMap();
        }

        public JSONElement(QName qname) {
            this(qname.getName());
            this.setNamespace("", qname.getNamespaceURI());
        }

        @Override
        public ElementFactory getFactory() {
            return mFactory;
        }

        @Override
        public Element addElement(String name) throws ContainerException {
            return this.addElement(new JSONElement(name));
        }

        @Override
        public Element addElement(QName qname) throws ContainerException {
            return this.addElement(new JSONElement(qname));
        }

        @Override
        public Element addElement(Element elt) throws ContainerException {
            if (elt == null || elt.mParent == this) {
                return elt;
            }
            if (elt.mParent != null) {
                throw new ContainerException("element already has a parent");
            }
            String name = elt.getName();
            Object obj = this.mAttributes.get(name);
            if (obj instanceof Element) {
                throw new ContainerException("already stored element as unique: " + name);
            }
            if (obj != null && !(obj instanceof List)) {
                throw new ContainerException("already stored attribute with name: " + name);
            }
            ArrayList<Element> content = (ArrayList<Element>)obj;
            if (content == null) {
                content = new ArrayList<Element>();
                this.mAttributes.put(name, content);
            }
            content.add(elt);
            elt.mParent = this;
            return elt.collapseNamespace();
        }

        @Override
        public Element addUniqueElement(String name) throws ContainerException {
            return this.addUniqueElement(new JSONElement(name));
        }

        @Override
        public Element addUniqueElement(QName qname) throws ContainerException {
            return this.addUniqueElement(new JSONElement(qname));
        }

        @Override
        public Element addUniqueElement(Element elt) throws ContainerException {
            if (elt == null) {
                return null;
            }
            String name = elt.getName();
            Object obj = this.mAttributes.get(name);
            if (obj instanceof List) {
                throw new ContainerException("already stored non-unique element(s) with name: " + name);
            }
            if (obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
                throw new ContainerException("already stored attribute with name: " + name);
            }
            if (obj instanceof Element) {
                if (elt.mAttributes.isEmpty()) {
                    return (Element)obj;
                }
                if (!((Element)obj).mAttributes.isEmpty()) {
                    throw new ContainerException("already stored unique element with name: " + name);
                }
            }
            this.mAttributes.put(name, elt);
            elt.mParent = this;
            return elt;
        }

        @Override
        public Element setText(String content) throws ContainerException {
            return this.addAttribute(A_CONTENT, content);
        }

        @Override
        public Element addAttribute(String key, String value, Disposition disp) throws ContainerException {
            if (value == null) {
                return this;
            }
            this.checkNamingConflict(key);
            this.mAttributes.put(key, value);
            return this;
        }

        @Override
        public Element addAttribute(String key, long value, Disposition disp) throws ContainerException {
            this.checkNamingConflict(key);
            this.mAttributes.put(key, new Long(value));
            return this;
        }

        @Override
        public Element addAttribute(String key, double value, Disposition disp) throws ContainerException {
            this.checkNamingConflict(key);
            this.mAttributes.put(key, new Double(value));
            return this;
        }

        @Override
        public Element addAttribute(String key, boolean value, Disposition disp) throws ContainerException {
            this.checkNamingConflict(key);
            this.mAttributes.put(key, new Boolean(value));
            return this;
        }

        private void checkNamingConflict(String key) throws ContainerException {
            Object obj = this.mAttributes.get(key);
            if (obj instanceof Element || obj instanceof List) {
                throw new ContainerException("already stored element with name: " + key);
            }
        }

        @Override
        public KeyValuePair addKeyValuePair(String key, String value, String eltname, String attrname) {
            JSONElement attrs = (JSONElement)this.addUniqueElement(E_ATTRS);
            Object existing = attrs.mAttributes.get(key);
            JSONKeyValuePair kvp = new JSONKeyValuePair(key, value);
            if (existing == null) {
                attrs.mAttributes.put(key, kvp);
            } else if (existing instanceof KeyValuePair) {
                ArrayList<KeyValuePair> pairs = new ArrayList<KeyValuePair>();
                pairs.add((KeyValuePair)existing);
                pairs.add(kvp);
                attrs.mAttributes.put(key, pairs);
            } else {
                ((List)existing).add(kvp);
            }
            return kvp;
        }

        @Override
        protected void detach(Element elt) throws ContainerException {
            if (elt == null) {
                return;
            }
            super.detach(elt);
            Object obj = this.mAttributes.get(elt.getName());
            if (obj == elt) {
                this.mAttributes.remove(elt.getName());
            } else if (obj instanceof List) {
                ((List)obj).remove(elt);
                if (((List)obj).isEmpty()) {
                    this.mAttributes.remove(elt.getName());
                }
            }
        }

        @Override
        public Element getOptionalElement(String name) {
            Object obj = this.mAttributes.get(name);
            if (obj instanceof Element) {
                return (Element)obj;
            }
            if (obj instanceof List) {
                return (Element)((List)obj).get(0);
            }
            return null;
        }

        @Override
        public Set<Attribute> listAttributes() {
            if (this.mAttributes.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<Attribute> set = new HashSet<Attribute>();
            for (Map.Entry<String, Object> entry : this.mAttributes.entrySet()) {
                Object obj = entry.getValue();
                if (obj == null || ((String)entry.getKey()).equals(A_CONTENT) || obj instanceof Element || obj instanceof List) continue;
                set.add(new Attribute(entry, this));
            }
            return set;
        }

        @Override
        public List<Element> listElements(String name) {
            if (this.mAttributes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Element> list = new ArrayList<Element>();
            for (Map.Entry entry : this.mAttributes.entrySet()) {
                String key = (String)entry.getKey();
                Object obj = entry.getValue();
                if ((name == null || name.equals("a")) && key.equals(E_ATTRS) && obj instanceof JSONElement) {
                    for (Object attr : ((Element)obj).mAttributes.values()) {
                        if (attr instanceof JSONKeyValuePair) {
                            list.add(((JSONKeyValuePair)attr).asElement());
                            continue;
                        }
                        for (JSONKeyValuePair kvp : (List)attr) {
                            list.add(kvp.asElement());
                        }
                    }
                    continue;
                }
                if (name != null && !name.equals(key)) continue;
                if (obj instanceof Element) {
                    list.add((Element)obj);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                list.addAll((List)obj);
            }
            return list;
        }

        @Override
        public List<KeyValuePair> listKeyValuePairs(String eltname, String attrname) {
            Element attrs = this.getOptionalElement(E_ATTRS);
            if (attrs == null || !(attrs instanceof JSONElement)) {
                return Collections.emptyList();
            }
            ArrayList<KeyValuePair> pairs = new ArrayList<KeyValuePair>();
            for (Map.Entry<String, Object> entry : attrs.mAttributes.entrySet()) {
                List<Object> values = entry.getValue() instanceof List ? (List<Object>)entry.getValue() : Arrays.asList(entry.getValue());
                for (Object e : values) {
                    if (e instanceof KeyValuePair) {
                        pairs.add((KeyValuePair)e);
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    pairs.add(new JSONKeyValuePair(entry.getKey(), (String)e));
                }
            }
            return pairs;
        }

        @Override
        public String getText() {
            return this.getAttribute(A_CONTENT, "");
        }

        @Override
        String getRawText() {
            return this.getAttribute(A_CONTENT, null);
        }

        @Override
        public String getAttribute(String key, String defaultValue) {
            Object obj = this.mAttributes.get(key);
            if (obj != null) {
                if (obj instanceof List) {
                    Object v = obj = ((List)obj).isEmpty() ? null : (Object)((List)obj).get(0);
                }
                if (obj instanceof Element) {
                    obj = ((Element)obj).getRawText();
                } else if (obj instanceof KeyValuePair) {
                    obj = ((KeyValuePair)obj).getValue();
                }
            } else {
                Element attrs = this.getOptionalElement(E_ATTRS);
                Object v = obj = attrs == null ? null : attrs.mAttributes.get(key);
            }
            if (obj == null) {
                return defaultValue;
            }
            if (obj instanceof JSONKeyValuePair) {
                return ((JSONKeyValuePair)obj).getValue();
            }
            return obj.toString();
        }

        @Override
        public JSONElement clone() {
            JSONElement clone = new JSONElement(this.getQName());
            if (this.mNamespaces != null) {
                if (clone.mNamespaces == null) {
                    clone.mNamespaces = new HashMap(this.mNamespaces);
                } else {
                    clone.mNamespaces.putAll(this.mNamespaces);
                }
            }
            for (Map.Entry entry : this.mAttributes.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Element) {
                    clone.addUniqueElement(((Element)value).clone());
                    continue;
                }
                if (value instanceof JSONKeyValuePair) {
                    clone.mAttributes.put(key, ((JSONKeyValuePair)value).clone());
                    continue;
                }
                if (value instanceof List) {
                    for (Object child : (List)value) {
                        if (child instanceof Element) {
                            clone.addElement(((Element)child).clone());
                            continue;
                        }
                        Object childclone = child instanceof JSONKeyValuePair ? ((JSONKeyValuePair)child).clone() : child;
                        ArrayList children = (ArrayList)clone.mAttributes.get(key);
                        if (children == null) {
                            children = new ArrayList(((List)value).size());
                            children.add(childclone);
                            clone.mAttributes.put(key, children);
                            continue;
                        }
                        children.add(childclone);
                    }
                    continue;
                }
                clone.mAttributes.put(key, value);
            }
            return clone;
        }

        private static void parseKeyValuePair(JSRequest jsr, String key, Element parent) throws SoapParseException {
            switch (jsr.peekChar()) {
                case '{': {
                    jsr.skipChar();
                    KeyValuePair kvp = parent.addKeyValuePair(key, null);
                    do {
                        String attr = jsr.readString();
                        switch (jsr.readChar()) {
                            case ':': {
                                break;
                            }
                            case '=': {
                                if (jsr.peekChar() != '>') break;
                                jsr.skipChar();
                                break;
                            }
                            default: {
                                throw new SoapParseException("missing expected ':'", jsr.js);
                            }
                        }
                        Object value = jsr.readValue();
                        if (value != null) {
                            if (key.equals(A_CONTENT)) {
                                kvp.setValue(value.toString());
                            } else if (value instanceof Boolean) {
                                kvp.addAttribute(attr, (Boolean)value);
                            } else if (value instanceof Long) {
                                kvp.addAttribute(attr, (Long)value);
                            } else if (value instanceof Double) {
                                kvp.addAttribute(attr, (Double)value);
                            } else {
                                kvp.addAttribute(attr, value.toString());
                            }
                        }
                        switch (jsr.peekChar()) {
                            case '}': {
                                break;
                            }
                            case ',': 
                            case ';': {
                                jsr.skipChar();
                                break;
                            }
                            default: {
                                throw new SoapParseException("missing expected ',' or ']'", jsr.js);
                            }
                        }
                    } while (jsr.peekChar() != '}');
                    jsr.skipChar();
                    break;
                }
                case '[': {
                    jsr.skipChar();
                    block17: while (jsr.peekChar() != ']') {
                        JSONElement.parseKeyValuePair(jsr, key, parent);
                        switch (jsr.peekChar()) {
                            case ']': {
                                continue block17;
                            }
                            case ',': 
                            case ';': {
                                jsr.skipChar();
                                continue block17;
                            }
                        }
                        throw new SoapParseException("missing expected ',' or ']'", jsr.js);
                    }
                    jsr.skipChar();
                    break;
                }
                default: {
                    Object value = jsr.readValue();
                    if (value == null) break;
                    parent.addKeyValuePair(key, value.toString());
                }
            }
        }

        static Element parseElement(JSRequest jsr, QName qname, ElementFactory factory) throws SoapParseException {
            return JSONElement.parseElement(jsr, qname.getName(), factory, null).setNamespace("", qname.getNamespaceURI());
        }

        private static Element parseElement(JSRequest jsr, String name, ElementFactory factory, Element parent) throws SoapParseException {
            boolean isAttrs = parent != null && name.equals(E_ATTRS);
            Element elt = isAttrs ? null : factory.createElement(name);
            jsr.skipChar('{');
            block16: while (jsr.peekChar() != '}') {
                String key = jsr.readString();
                switch (jsr.readChar()) {
                    case ':': {
                        break;
                    }
                    case '=': {
                        if (jsr.peekChar() != '>') break;
                        jsr.skipChar();
                        break;
                    }
                    default: {
                        throw new SoapParseException("missing expected ':'", jsr.js);
                    }
                }
                if (isAttrs) {
                    JSONElement.parseKeyValuePair(jsr, key, parent);
                } else {
                    switch (jsr.peekChar()) {
                        case '{': {
                            elt.addUniqueElement(JSONElement.parseElement(jsr, key, factory, elt));
                            break;
                        }
                        case '[': {
                            jsr.skipChar();
                            block17: while (jsr.peekChar() != ']') {
                                elt.addElement(JSONElement.parseElement(jsr, key, factory, elt));
                                switch (jsr.peekChar()) {
                                    case ']': {
                                        continue block17;
                                    }
                                    case ',': 
                                    case ';': {
                                        jsr.skipChar();
                                        continue block17;
                                    }
                                }
                                throw new SoapParseException("missing expected ',' or ']'", jsr.js);
                            }
                            jsr.skipChar();
                            break;
                        }
                        default: {
                            Object value = jsr.readValue();
                            if (value == null) break;
                            if (key.equals(A_NAMESPACE)) {
                                elt.setNamespace("", value.toString());
                                break;
                            }
                            if (value instanceof Boolean) {
                                elt.addAttribute(key, (Boolean)value);
                                break;
                            }
                            if (value instanceof Long) {
                                elt.addAttribute(key, (Long)value);
                                break;
                            }
                            if (value instanceof Double) {
                                elt.addAttribute(key, (Double)value);
                                break;
                            }
                            elt.addAttribute(key, value.toString());
                        }
                    }
                }
                switch (jsr.peekChar()) {
                    case '}': {
                        continue block16;
                    }
                    case ',': 
                    case ';': {
                        jsr.skipChar();
                        continue block16;
                    }
                }
                throw new SoapParseException("missing expected ',' or '}'", jsr.js);
            }
            jsr.skipChar('}');
            return elt;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            try {
                this.toString(sb, -1);
            }
            catch (IOException e) {
                ZimbraLog.soap.error((Object)"Caught IOException: ", e);
            }
            return sb.toString();
        }

        @Override
        public void toString(Appendable out) throws IOException {
            this.toString(out, -1);
        }

        @Override
        public String prettyPrint() {
            StringBuffer sb = new StringBuffer();
            try {
                this.toString(sb, 0);
            }
            catch (IOException e) {
                ZimbraLog.soap.error((Object)"Caught IOException: ", e);
            }
            return sb.toString();
        }

        private void toString(Appendable sb, int indent) throws IOException {
            indent = indent < 0 ? -1 : indent + 2;
            sb.append('{');
            boolean needNamespace = this.mNamespaces == null ? false : this.namespaceDeclarationNeeded("", ((String)this.mNamespaces.get("")).toString());
            int size = this.mAttributes.size() + (needNamespace ? 1 : 0);
            if (size != 0) {
                int index = 0;
                for (Map.Entry attr : this.mAttributes.entrySet()) {
                    this.indent(sb, indent, true);
                    sb.append('\"').append(StringUtil.jsEncode(attr.getKey())).append(indent >= 0 ? "\": " : "\":");
                    Object value = attr.getValue();
                    if (value instanceof String) {
                        sb.append('\"').append(StringUtil.jsEncode(value)).append('\"');
                    } else if (value instanceof JSONKeyValuePair) {
                        sb.append(value.toString());
                    } else if (value instanceof JSONElement) {
                        ((JSONElement)value).toString(sb, indent);
                    } else if (value instanceof Element) {
                        sb.append('\"').append(StringUtil.jsEncode(value)).append('\"');
                    } else if (!(value instanceof List)) {
                        sb.append(String.valueOf(value));
                    } else {
                        sb.append('[');
                        int lsize = ((List)value).size();
                        if (lsize > 0) {
                            ListIterator lit = ((List)value).listIterator();
                            while (lit.hasNext()) {
                                Object child;
                                int lindent;
                                int n = lindent = indent < 0 ? -1 : indent + 2;
                                if (lsize > 1) {
                                    this.indent(sb, lindent, true);
                                }
                                if ((child = lit.next()) instanceof JSONElement) {
                                    ((JSONElement)child).toString(sb, lindent);
                                } else if (child instanceof JSONKeyValuePair) {
                                    sb.append(child.toString());
                                } else {
                                    sb.append('\"').append(StringUtil.jsEncode(child)).append('\"');
                                }
                                if (lit.nextIndex() == lsize) continue;
                                sb.append(",");
                            }
                        }
                        sb.append(']');
                    }
                    if (index++ >= size - 1) continue;
                    sb.append(",");
                }
                if (needNamespace) {
                    this.indent(sb, indent, true);
                    sb.append('\"').append(A_NAMESPACE).append(indent >= 0 ? "\": \"" : "\":\"").append(StringUtil.jsEncode(this.mNamespaces.get(""))).append('\"');
                }
                this.indent(sb, indent - 2, true);
            }
            sb.append('}');
        }

        private static final class JSRequest {
            String js;
            private int offset;
            private int max;

            JSRequest(String content) {
                this.js = content;
                this.max = this.js.length();
            }

            private char readEscaped() throws SoapParseException {
                int length;
                this.skipChar('\\');
                char c = this.js.charAt(this.offset);
                switch (c) {
                    case 'b': {
                        return '\b';
                    }
                    case 't': {
                        return '\t';
                    }
                    case 'n': {
                        return '\n';
                    }
                    case 'f': {
                        return '\f';
                    }
                    case 'r': {
                        return '\r';
                    }
                    case 'u': {
                        length = 4;
                        break;
                    }
                    case 'x': {
                        length = 2;
                        break;
                    }
                    default: {
                        return c;
                    }
                }
                try {
                    c = (char)Integer.parseInt(this.js.substring(this.offset + 1, this.offset + length + 1), 16);
                    this.offset += length;
                }
                catch (NumberFormatException nfe) {
                    this.error("malformed escape sequence: " + this.js.substring(this.offset - 1, this.offset + length + 1));
                }
                return c;
            }

            private String readQuoted(char quote) throws SoapParseException {
                StringBuffer sb = new StringBuffer();
                char c = this.js.charAt(this.offset);
                while (c != quote) {
                    if (c == '\n' || c == '\t' || this.offset >= this.max - 1) {
                        this.error("unterminated string");
                    } else {
                        sb.append(c == '\\' ? this.readEscaped() : c);
                    }
                    c = this.js.charAt(++this.offset);
                }
                this.skipChar();
                return sb.toString();
            }

            private String readLiteral() throws SoapParseException {
                StringBuffer sb = new StringBuffer();
                char c = this.peekChar();
                while (this.offset < this.max - 1 && c > ' ' && ",:]}/\"[{;=#".indexOf(c) < 0) {
                    if (c != '\\' || this.max - this.offset < 6 || this.js.charAt(this.offset + 1) != 'u') {
                        sb.append(c);
                    } else {
                        sb.append(this.readEscaped());
                    }
                    c = this.js.charAt(++this.offset);
                }
                if (sb.length() == 0) {
                    this.error("zero-length identifier");
                }
                return sb.toString();
            }

            String readString() throws SoapParseException {
                char c = this.peekChar();
                return c == '\"' || c == '\'' ? this.readQuoted(this.readChar()) : this.readLiteral();
            }

            Object readValue() throws SoapParseException {
                char c = this.peekChar();
                if (c == '\"' || c == '\'') {
                    return this.readQuoted(this.readChar());
                }
                String literal = this.readLiteral();
                if (literal.equals("null")) {
                    return null;
                }
                if (literal.equals("true")) {
                    return Boolean.TRUE;
                }
                if (literal.equals("false")) {
                    return Boolean.FALSE;
                }
                if (c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+') {
                    try {
                        return Long.decode(literal);
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            return new Double(literal);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                return literal;
            }

            char peekChar() throws SoapParseException {
                this.skipWhitespace();
                return this.js.charAt(this.offset);
            }

            char readChar() throws SoapParseException {
                this.skipWhitespace();
                return this.js.charAt(this.offset++);
            }

            void skipChar() throws SoapParseException {
                this.readChar();
            }

            void skipChar(char c) throws SoapParseException {
                if (this.readChar() != c) {
                    this.error("expected character: " + c);
                }
            }

            private void skipWhitespace() throws SoapParseException {
                if (this.offset >= this.max) {
                    this.error("unexpected end of JSON input");
                }
                char c = this.js.charAt(this.offset);
                while (this.offset < this.max && (c == '\t' || c >= '\n' && c <= '\r' || c >= '\u001c' && c <= ' ')) {
                    c = this.js.charAt(++this.offset);
                }
            }

            private void error(String cause) throws SoapParseException {
                throw new SoapParseException(cause, this.js);
            }
        }

        private static final class JSONKeyValuePair
        implements KeyValuePair,
        Cloneable {
            private final JSONElement mTarget;

            JSONKeyValuePair(String key, String value) {
                this.mTarget = new JSONElement(key);
                this.mTarget.setText(value);
            }

            public KeyValuePair setValue(String value) throws ContainerException {
                this.mTarget.setText(value);
                return this;
            }

            public KeyValuePair addAttribute(String key, String value) throws ContainerException {
                this.mTarget.addAttribute(key, value);
                return this;
            }

            public KeyValuePair addAttribute(String key, long value) throws ContainerException {
                this.mTarget.addAttribute(key, value);
                return this;
            }

            public KeyValuePair addAttribute(String key, double value) throws ContainerException {
                this.mTarget.addAttribute(key, value);
                return this;
            }

            public KeyValuePair addAttribute(String key, boolean value) throws ContainerException {
                this.mTarget.addAttribute(key, value);
                return this;
            }

            public String getKey() throws ContainerException {
                return this.mTarget.getName();
            }

            public String getValue() throws ContainerException {
                return this.mTarget.getRawText();
            }

            public JSONKeyValuePair clone() {
                JSONKeyValuePair clone = new JSONKeyValuePair(this.getKey(), this.getValue());
                clone.mTarget.mAttributes.putAll(this.mTarget.mAttributes);
                return clone;
            }

            public String toString() {
                if (this.mTarget.mAttributes.isEmpty()) {
                    return "null";
                }
                if (this.mTarget.mAttributes.size() == 1 && this.mTarget.mAttributes.containsKey(JSONElement.A_CONTENT)) {
                    return '\"' + StringUtil.jsEncode(this.mTarget.mAttributes.get(JSONElement.A_CONTENT)) + '\"';
                }
                return this.mTarget.toString();
            }

            Element asElement() {
                Element elt = new JSONElement("a").addAttribute("n", this.mTarget.mName);
                elt.mAttributes.putAll(this.mTarget.mAttributes);
                return elt;
            }
        }

        private static final class JSONFactory
        implements ElementFactory {
            JSONFactory() {
            }

            public Element createElement(String name) {
                return new JSONElement(name);
            }

            public Element createElement(QName qname) {
                return new JSONElement(qname);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attribute {
        private String mKey;
        private Object mValue;
        private Element mParent;

        Attribute(Map.Entry<String, Object> entry, Element parent) {
            this.mKey = entry.getKey();
            this.mValue = entry.getValue();
            this.mParent = parent;
        }

        public String getKey() {
            return this.mKey;
        }

        public String getValue() {
            return this.mValue.toString();
        }

        public void setValue(String value) {
            this.mParent.addAttribute(this.mKey, value);
            this.mValue = value;
        }
    }

    public static interface KeyValuePair {
        public KeyValuePair setValue(String var1) throws ContainerException;

        public KeyValuePair addAttribute(String var1, String var2) throws ContainerException;

        public KeyValuePair addAttribute(String var1, long var2) throws ContainerException;

        public KeyValuePair addAttribute(String var1, double var2) throws ContainerException;

        public KeyValuePair addAttribute(String var1, boolean var2) throws ContainerException;

        public String getKey() throws ContainerException;

        public String getValue() throws ContainerException;
    }

    public static interface ElementFactory {
        public Element createElement(String var1);

        public Element createElement(QName var1);
    }

    public static class ContainerException
    extends RuntimeException {
        private static final long serialVersionUID = -5884422477180821199L;

        public ContainerException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Disposition {
        ATTRIBUTE,
        CONTENT;

    }
}

