/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.service;

import com.zimbra.common.util.HttpUtil;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Hex;

public class ServiceException
extends Exception {
    public static final String FAILURE = "service.FAILURE";
    public static final String INVALID_REQUEST = "service.INVALID_REQUEST";
    public static final String UNKNOWN_DOCUMENT = "service.UNKNOWN_DOCUMENT";
    public static final String PARSE_ERROR = "service.PARSE_ERROR";
    public static final String RESOURCE_UNREACHABLE = "service.RESOURCE_UNREACHABLE";
    public static final String TEMPORARILY_UNAVAILABLE = "service.TEMPORARILY_UNAVAILABLE";
    public static final String PERM_DENIED = "service.PERM_DENIED";
    public static final String AUTH_REQUIRED = "service.AUTH_REQUIRED";
    public static final String AUTH_EXPIRED = "service.AUTH_EXPIRED";
    public static final String WRONG_HOST = "service.WRONG_HOST";
    public static final String NON_READONLY_OPERATION_DENIED = "service.NON_READONLY_OPERATION_DENIED";
    public static final String PROXY_ERROR = "service.PROXY_ERROR";
    public static final String TOO_MANY_HOPS = "service.TOO_MANY_HOPS";
    public static final String ALREADY_IN_PROGRESS = "service.ALREADY_IN_PROGRESS";
    public static final String NOT_IN_PROGRESS = "service.NOT_IN_PROGRESS";
    public static final String INTERRUPTED = "service.INTERRUPTED";
    public static final String NO_SPELL_CHECK_URL = "service.NO_SPELL_CHECK_URL";
    protected String mCode;
    protected Argument[] mArgs = null;
    private String mId;
    public static final String HOST = "host";
    public static final String URL = "url";
    public static final String MAILBOX_ID = "mboxId";
    public static final String ACCOUNT_ID = "acctId";
    public static final String PROXIED_FROM_ACCT = "proxiedFromAcct";
    private static String ID_KEY = null;
    public static final boolean RECEIVERS_FAULT = true;
    public static final boolean SENDERS_FAULT = false;
    private boolean mReceiver;

    public String toString() {
        StringBuilder toRet = new StringBuilder(super.toString());
        toRet.append("\nExceptionId:").append(this.mId);
        toRet.append("\nCode:").append(this.mCode);
        if (this.mArgs != null) {
            for (Argument arg : this.mArgs) {
                toRet.append(" Arg:").append(arg.toString()).append("");
            }
        }
        return toRet.toString();
    }

    public void setArgument(String name, String value, Argument.Type type) {
        if (this.mArgs == null) {
            this.mArgs = new Argument[1];
            this.mArgs[0] = new Argument(name, value, type);
        } else {
            for (Argument arg : this.mArgs) {
                if (!arg.mName.equals(name) || arg.mType != type) continue;
                arg.mValue = value;
                return;
            }
            Argument[] newArgs = new Argument[this.mArgs.length + 1];
            for (int i = this.mArgs.length - 1; i >= 0; --i) {
                newArgs[i] = this.mArgs[i];
            }
            newArgs[this.mArgs.length] = new Argument(name, value, type);
            this.mArgs = newArgs;
        }
    }

    public void setIdLabel(StackTraceElement callSite) {
        String fileName = callSite.getFileName();
        int i = fileName.lastIndexOf(46);
        if (i != -1) {
            fileName = fileName.substring(0, i);
        }
        this.mId = this.mId + ":" + fileName + callSite.getLineNumber();
    }

    private void setId() {
        this.mId = Thread.currentThread().getName() + ":" + System.currentTimeMillis() + ":" + ID_KEY;
    }

    protected void setId(String id) {
        this.mId = id;
    }

    protected ServiceException(String message, String code, boolean isReceiversFault, Throwable cause, Argument ... arguments) {
        super(message, cause);
        this.mCode = code;
        this.mReceiver = isReceiversFault;
        this.mArgs = arguments;
        this.setId();
    }

    protected ServiceException(String message, String code, boolean isReceiversFault, Argument ... arguments) {
        super(message);
        this.mCode = code;
        this.mReceiver = isReceiversFault;
        this.mArgs = arguments;
        this.setId();
    }

    public String getCode() {
        return this.mCode;
    }

    public Argument[] getArgs() {
        return this.mArgs;
    }

    public String getId() {
        return this.mId;
    }

    public boolean isReceiversFault() {
        return this.mReceiver;
    }

    public static ServiceException FAILURE(String message, Throwable cause) {
        return new ServiceException("system failure: " + message, FAILURE, true, cause, new Argument[0]);
    }

    public static ServiceException INVALID_REQUEST(String message, Throwable cause) {
        return new ServiceException("invalid request: " + message, INVALID_REQUEST, false, cause, new Argument[0]);
    }

    public static ServiceException UNKNOWN_DOCUMENT(String message, Throwable cause) {
        return new ServiceException("unknown document: " + message, UNKNOWN_DOCUMENT, false, cause, new Argument[0]);
    }

    public static ServiceException PARSE_ERROR(String message, Throwable cause) {
        return new ServiceException("parse error: " + message, PARSE_ERROR, false, cause, new Argument[0]);
    }

    public static ServiceException RESOURCE_UNREACHABLE(String message, Throwable cause, Argument ... arguments) {
        return new ServiceException("resource unreachable: " + message, RESOURCE_UNREACHABLE, true, cause, arguments);
    }

    public static ServiceException TEMPORARILY_UNAVAILABLE() {
        return new ServiceException("service temporarily unavailable", TEMPORARILY_UNAVAILABLE, true, new Argument[0]);
    }

    public static ServiceException PERM_DENIED(String message) {
        return new ServiceException("permission denied: " + message, PERM_DENIED, false, new Argument[0]);
    }

    public static ServiceException AUTH_EXPIRED() {
        return new ServiceException("auth credentials have expired", AUTH_EXPIRED, false, new Argument[0]);
    }

    public static ServiceException DEFEND_ACCOUNT_HARVEST(String account) {
        return ServiceException.PERM_DENIED("can not access account " + account);
    }

    public static ServiceException AUTH_REQUIRED() {
        return new ServiceException("no valid authtoken present", AUTH_REQUIRED, false, new Argument[0]);
    }

    public static ServiceException WRONG_HOST(String target, Throwable cause) {
        return new ServiceException("operation sent to wrong host (you want '" + target + "')", WRONG_HOST, false, cause, new Argument(HOST, target, Argument.Type.STR));
    }

    public static ServiceException NON_READONLY_OPERATION_DENIED() {
        return new ServiceException("non-readonly operation denied", NON_READONLY_OPERATION_DENIED, false, new Argument[0]);
    }

    public static ServiceException PROXY_ERROR(Throwable cause, String url) {
        return new ServiceException("error while proxying request to target server: " + (cause != null ? cause.getMessage() : "unknown reason"), PROXY_ERROR, true, cause, new InternalArgument(URL, url, Argument.Type.STR));
    }

    public static ServiceException PROXY_ERROR(String statusLine, String url) {
        return new ServiceException("error while proxying request to target server: " + statusLine, PROXY_ERROR, true, new InternalArgument(URL, url, Argument.Type.STR));
    }

    public static ServiceException TOO_MANY_HOPS() {
        return new ServiceException("mountpoint or proxy loop detected", TOO_MANY_HOPS, false, new Argument[0]);
    }

    public static ServiceException TOO_MANY_HOPS(String acctId) {
        return new ServiceException("mountpoint or proxy loop detected", TOO_MANY_HOPS, false, new Argument(ACCOUNT_ID, acctId, Argument.Type.STR));
    }

    public static ServiceException TOO_MANY_PROXIES(String url) {
        return new ServiceException("proxy loop detected", TOO_MANY_HOPS, false, new Argument(URL, HttpUtil.sanitizeURL(url), Argument.Type.STR));
    }

    public static ServiceException ALREADY_IN_PROGRESS(String message) {
        return new ServiceException(message, ALREADY_IN_PROGRESS, false, new Argument[0]);
    }

    public static ServiceException ALREADY_IN_PROGRESS(String mboxId, String action) {
        return new ServiceException("mbox " + mboxId + " is already running action " + action, ALREADY_IN_PROGRESS, false, new Argument(MAILBOX_ID, mboxId, Argument.Type.IID), new Argument("action", action, Argument.Type.STR));
    }

    public static ServiceException NOT_IN_PROGRESS(String mboxId, String action) {
        return new ServiceException("mbox " + mboxId + " is not currently running action " + action, NOT_IN_PROGRESS, false, new Argument(MAILBOX_ID, mboxId, Argument.Type.IID), new Argument("action", action, Argument.Type.STR));
    }

    public static ServiceException INTERRUPTED(String str) {
        return new ServiceException("The operation has been interrupted " + str != null ? str : "", INTERRUPTED, true, new Argument[0]);
    }

    public static ServiceException NO_SPELL_CHECK_URL(String str) {
        return new ServiceException("Spell Checking Not Available " + str != null ? str : "", NO_SPELL_CHECK_URL, true, new Argument[0]);
    }

    static {
        SecureRandom random = new SecureRandom();
        byte[] key = new byte[8];
        random.nextBytes(key);
        ID_KEY = new String(Hex.encodeHex((byte[])key));
    }

    public static class InternalArgument
    extends Argument {
        public InternalArgument(String name, String value, Argument.Type typ) {
            super(name, value, typ);
        }

        public InternalArgument(String name, long value, Argument.Type type) {
            super(name, value, type);
        }

        public boolean externalVisible() {
            return false;
        }
    }

    public static class Argument {
        public String mName;
        public String mValue;
        public Type mType;

        public Argument(String name, String value, Type typ) {
            this.mName = name;
            this.mValue = value;
            this.mType = typ;
        }

        public Argument(String name, long value, Type type) {
            this.mName = name;
            this.mValue = Long.toString(value);
            this.mType = type;
        }

        public boolean externalVisible() {
            return true;
        }

        public String toString() {
            return "(" + this.mName + ", " + this.mType.name() + ", \"" + this.mValue + "\")";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            IID,
            ACCTID,
            STR,
            NUM;

        }
    }
}

