/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.ContentDisposition;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.mime.MimeBodyPart;
import com.zimbra.common.mime.MimeHeader;
import com.zimbra.common.mime.MimeHeaderBlock;
import com.zimbra.common.mime.MimeMessage;
import com.zimbra.common.mime.MimeMultipart;
import com.zimbra.common.util.ByteUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MimePart {
    public static final String PROP_CHARSET_DEFAULT = "charset.default";
    private MimePart mParent;
    private MimeHeaderBlock mMimeHeaders;
    private ContentType mContentType;
    private long mStartOffset = -1L;
    private long mBodyOffset = -1L;
    private long mEndOffset = -1L;
    private PartSource mPartSource;
    private boolean mDirty;

    MimePart(ContentType ctype) {
        this.mContentType = new ContentType(ctype);
        this.checkContentType(this.mContentType);
        this.mMimeHeaders = new MimeHeaderBlock(this instanceof MimeMessage);
        this.setMimeHeader("Content-Type", new MimeHeader("Content-Type", this.mContentType));
        this.mDirty = true;
    }

    MimePart(ContentType ctype, MimePart parent, long start, long body, MimeHeaderBlock headers) {
        this.mParent = parent;
        this.mContentType = ctype;
        this.mMimeHeaders = headers;
        this.mStartOffset = start;
        this.mBodyOffset = body;
    }

    static MimePart parse(ParseState pstate, MimePart parent, String defaultContentType) throws IOException {
        String defaultCharset;
        long start = pstate.getPosition();
        MimeHeaderBlock headers = new MimeHeaderBlock(parent instanceof MimeMessage).parse(pstate, parent == null ? null : parent.getActiveBoundaries());
        ContentType ctype = new ContentType(headers.getHeader("Content-Type", defaultCharset = parent == null ? null : parent.getDefaultCharset()), defaultContentType);
        MimePart mp = ctype.getValue().equals("message/rfc822") ? new MimeMessage(ctype, parent, start, pstate.getPosition(), headers) : (ctype.getPrimaryType().equals("multipart") ? new MimeMultipart(ctype, parent, start, pstate.getPosition(), headers) : new MimeBodyPart(ctype, parent, start, pstate.getPosition(), headers));
        ParseState.BoundaryTerminator bterm = pstate.getBoundaryTerminator();
        if (bterm == null) {
            mp.readContent(pstate);
        } else {
            mp.recordEndpoint(bterm.mBoundaryStart);
        }
        return mp;
    }

    MimePart getParent() {
        return this.mParent;
    }

    void setParent(MimePart mp) {
        this.detach();
        this.mParent = mp;
    }

    public MimePart detach() {
        this.mPartSource = this.getPartSource();
        if (this.mParent != null) {
            this.mParent.removeChild(this);
        }
        return this;
    }

    abstract void removeChild(MimePart var1);

    private PartSource getPartSource() {
        return this.mPartSource != null || this.mParent == null ? this.mPartSource : this.mParent.getPartSource();
    }

    public MimePart getSubpart(String part) {
        return part == null || part.equals("") ? this : null;
    }

    Map<String, MimePart> listMimeParts(Map<String, MimePart> parts, String prefix) {
        return parts;
    }

    long getStartOffset() {
        return this.mStartOffset;
    }

    long getBodyOffset() {
        return this.mBodyOffset;
    }

    long getEndOffset() {
        return this.mEndOffset;
    }

    long getSize() {
        return this.mEndOffset - this.mBodyOffset;
    }

    Properties getProperties() {
        return this.mParent == null ? null : this.mParent.getProperties();
    }

    String getDefaultCharset() {
        Properties props = this.getProperties();
        return props == null ? null : props.getProperty(PROP_CHARSET_DEFAULT);
    }

    List<String> getActiveBoundaries() {
        return this.mParent == null ? null : this.mParent.getActiveBoundaries();
    }

    public String getMimeHeader(String name) {
        return this.mMimeHeaders == null ? null : this.mMimeHeaders.getHeader(name, this.getDefaultCharset());
    }

    public byte[] getRawMimeHeader(String name) {
        return this.mMimeHeaders == null ? null : this.mMimeHeaders.getRawHeader(name);
    }

    public MimePart setMimeHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(new ContentType(value));
        } else {
            this.setMimeHeader(name, value == null ? null : new MimeHeader(name, value));
        }
        return this;
    }

    void setMimeHeader(String name, MimeHeader header) {
        if (this.mMimeHeaders == null) {
            this.mMimeHeaders = new MimeHeaderBlock(false);
        }
        this.mMimeHeaders.setHeader(name, header);
        if (this.mParent != null) {
            this.mParent.markDirty(true);
        }
        this.mStartOffset = -1L;
    }

    void addMimeHeader(String name, MimeHeader header) {
        if (this.mMimeHeaders == null) {
            this.mMimeHeaders = new MimeHeaderBlock(false);
        }
        this.mMimeHeaders.addHeader(name, header);
        if (this.mParent != null) {
            this.mParent.markDirty(true);
        }
        this.mStartOffset = -1L;
    }

    Iterator<MimeHeader> mimeHeaderIterator() {
        if (this.mMimeHeaders == null) {
            this.mMimeHeaders = new MimeHeaderBlock(false);
        }
        return this.mMimeHeaders.iterator();
    }

    public ContentType getContentType() {
        return new ContentType(this.mContentType);
    }

    public void setContentType(ContentType ctype) {
        this.mContentType = new ContentType(ctype);
        this.setMimeHeader("Content-Type", ctype == null ? null : new MimeHeader("Content-Type", ctype));
    }

    abstract void checkContentType(ContentType var1);

    public ContentDisposition getContentDisposition() {
        return new ContentDisposition(this.getMimeHeader("Content-Disposition"));
    }

    public String getFilename() {
        String filename = this.mContentType.getParameter("name");
        if (filename == null || filename.equals("")) {
            filename = this.getContentDisposition().getParameter("filename");
        }
        return filename;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isDirty() && this.mStartOffset >= 0L) {
            return this.getRawContentStream(this.mStartOffset, this.mEndOffset);
        }
        ArrayList<Object> sources = new ArrayList<Object>(2);
        if (this.mStartOffset != -1L && this.getPartSource() != null) {
            sources.add(this.getRawContentStream(this.mStartOffset, this.mBodyOffset));
        } else if (this.mMimeHeaders != null) {
            sources.add(this.mMimeHeaders.toByteArray());
        }
        sources.add(this.getRawContentStream());
        return new VectorInputStream(sources);
    }

    public InputStream getRawContentStream() throws IOException {
        return this.getRawContentStream(this.mBodyOffset, this.mEndOffset);
    }

    private InputStream getRawContentStream(long start, long end) throws IOException {
        PartSource source = this.getPartSource();
        return source == null ? null : source.getContentStream(start, end);
    }

    public byte[] getRawContent() throws IOException {
        if (!this.isDirty()) {
            return this.getPartSource().getContent(this.mBodyOffset, this.mEndOffset);
        }
        InputStream is = this.getRawContentStream();
        return is == null ? null : ByteUtil.getContent(is, (int)(this.mEndOffset - this.mBodyOffset));
    }

    public InputStream getContentStream() throws IOException {
        return this.getRawContentStream();
    }

    public byte[] getContent() throws IOException {
        return this.getRawContent();
    }

    public MimePart setContent(byte[] content) {
        return this.setContent(content, true);
    }

    MimePart setContent(byte[] content, boolean markDirty) {
        if (markDirty && this.mParent != null) {
            this.mParent.markDirty(true);
        }
        this.mPartSource = new PartSource(content);
        this.mStartOffset = -1L;
        this.mBodyOffset = content == null ? -1L : 0L;
        this.mEndOffset = content == null ? -1L : (long)content.length;
        return this;
    }

    public MimePart setContent(File file) {
        return this.setContent(file, true);
    }

    MimePart setContent(File file, boolean markDirty) {
        if (markDirty && this.mParent != null) {
            this.mParent.markDirty(true);
        }
        if (!file.exists()) {
            file = null;
        }
        this.mPartSource = new PartSource(file);
        this.mStartOffset = -1L;
        this.mBodyOffset = file == null ? -1L : 0L;
        this.mEndOffset = file == null ? -1L : file.length();
        return this;
    }

    void markDirty(boolean dirtyBody) {
        if (this.isDirty()) {
            return;
        }
        this.mDirty |= dirtyBody;
        if (this.mParent != null) {
            this.mParent.markDirty(true);
        }
    }

    boolean isDirty() {
        return this.mDirty || this.getPartSource() == null;
    }

    abstract MimePart readContent(ParseState var1) throws IOException;

    protected void recordEndpoint(long position) {
        this.mEndOffset = position;
    }

    static class PeekAheadInputStream
    extends ByteUtil.PositionInputStream {
        PeekAheadInputStream(InputStream is) {
            super(is);
        }

        int peek() throws IOException {
            super.mark(1);
            int peekChar = super.read();
            if (peekChar != -1) {
                super.reset();
            }
            return peekChar;
        }
    }

    static class ParseState {
        private final PeekAheadInputStream mInputStream;
        private BoundaryTerminator mLastBoundary;

        ParseState(PeekAheadInputStream pais) {
            this.mInputStream = pais;
        }

        PeekAheadInputStream getInputStream() {
            return this.mInputStream;
        }

        long getPosition() {
            return this.mInputStream.getPosition();
        }

        void recordBoundary(String boundary, boolean isEndBoundary, long linestart) {
            this.mLastBoundary = new BoundaryTerminator();
            this.mLastBoundary.mBoundary = boundary;
            this.mLastBoundary.mWasEndBoundary = isEndBoundary;
            this.mLastBoundary.mBoundaryStart = linestart;
        }

        void clearBoundary() {
            this.mLastBoundary = null;
        }

        BoundaryTerminator getBoundaryTerminator() {
            return this.mLastBoundary;
        }

        static class BoundaryTerminator {
            String mBoundary;
            boolean mWasEndBoundary;
            long mBoundaryStart = -1L;

            BoundaryTerminator() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VectorInputStream
    extends InputStream {
        private final List<Object> mItems;
        private int mNextIndex;
        private InputStream mCurrentStream;

        VectorInputStream(List<Object> items) throws IOException {
            this.mItems = new ArrayList<Object>(items);
            while (this.mItems.remove(null)) {
            }
            this.getNextStream();
        }

        @Override
        public int read() throws IOException {
            int c;
            int n = c = this.mCurrentStream == null ? -1 : this.mCurrentStream.read();
            while (c == -1 && this.mCurrentStream != null) {
                c = this.getNextStream() == null ? -1 : this.mCurrentStream.read();
            }
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int num;
            int n = num = this.mCurrentStream == null ? -1 : this.mCurrentStream.read(b, off, len);
            while (num == -1 && this.mCurrentStream != null) {
                num = this.getNextStream() == null ? -1 : this.mCurrentStream.read(b, off, len);
            }
            return num;
        }

        @Override
        public long skip(long n) throws IOException {
            long remaining;
            for (remaining = n - (this.mCurrentStream == null ? 0L : this.mCurrentStream.skip(n)); remaining > 0L && this.mCurrentStream != null; remaining -= this.getNextStream() == null ? 0L : this.mCurrentStream.skip(remaining)) {
            }
            return n - remaining;
        }

        @Override
        public void close() {
            InputStream current = this.mCurrentStream;
            this.mCurrentStream = null;
            ByteUtil.closeStream(current);
            while (this.mNextIndex < this.mItems.size()) {
                Object next;
                if (!((next = this.mItems.get(this.mNextIndex++)) instanceof InputStream)) continue;
                ByteUtil.closeStream((InputStream)next);
            }
        }

        private InputStream getNextStream() throws IOException {
            Object next;
            ByteUtil.closeStream(this.mCurrentStream);
            Object object = next = this.mNextIndex >= this.mItems.size() ? null : this.mItems.get(this.mNextIndex);
            this.mCurrentStream = next == null ? null : (next instanceof byte[] ? new ByteArrayInputStream((byte[])next) : (next instanceof InputStream ? (InputStream)next : (next instanceof MimePart ? ((MimePart)next).getInputStream() : new ByteArrayInputStream(next.toString().getBytes()))));
            ++this.mNextIndex;
            return this.mCurrentStream;
        }
    }

    private static class PartSource {
        private final byte[] mBodyContent;
        private final File mBodyFile;

        PartSource(byte[] content) {
            this.mBodyContent = content;
            this.mBodyFile = null;
        }

        PartSource(File file) {
            this.mBodyContent = null;
            this.mBodyFile = file;
        }

        InputStream getContentStream(long start, long end) throws IOException {
            if (this.mBodyContent != null) {
                start = Math.max(0L, Math.min(start, (long)this.mBodyContent.length));
                end = end < 0L ? (long)this.mBodyContent.length : Math.max(start, Math.min(end, (long)this.mBodyContent.length));
                return new ByteArrayInputStream(this.mBodyContent, (int)start, (int)(end - start));
            }
            if (this.mBodyFile != null) {
                if (!this.mBodyFile.exists()) {
                    return null;
                }
                int fileLength = (int)this.mBodyFile.length();
                start = Math.max(0L, Math.min(start, (long)fileLength));
                end = end < 0L ? (long)fileLength : Math.max(start, Math.min(end, (long)fileLength));
                FileInputStream fis = new FileInputStream(this.mBodyFile);
                try {
                    return start == 0L && end == (long)fileLength ? fis : ByteUtil.SegmentInputStream.create(fis, start, end);
                }
                catch (IOException ioe) {
                    ByteUtil.closeStream(fis);
                    throw ioe;
                }
            }
            return null;
        }

        byte[] getContent(long start, long end) throws IOException {
            if (this.mBodyContent != null) {
                int size = (int)((end = end < 0L ? (long)this.mBodyContent.length : Math.max(start, Math.min(end, (long)this.mBodyContent.length))) - (start = Math.max(0L, Math.min(start, (long)this.mBodyContent.length))));
                if (size == this.mBodyContent.length) {
                    return this.mBodyContent;
                }
                byte[] content = new byte[size];
                System.arraycopy(this.mBodyContent, (int)start, content, 0, size);
                return content;
            }
            if (this.mBodyFile != null) {
                RandomAccessFile raf;
                try {
                    raf = new RandomAccessFile(this.mBodyFile, "r");
                }
                catch (FileNotFoundException fnfe) {
                    return null;
                }
                int fileLength = (int)raf.length();
                start = Math.max(0L, Math.min(start, (long)fileLength));
                end = end < 0L ? (long)fileLength : Math.max(start, Math.min(end, (long)fileLength));
                raf.seek(start);
                byte[] content = new byte[(int)(end - start)];
                raf.readFully(content);
                return content;
            }
            return null;
        }
    }
}

