/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.ContentType;
import com.zimbra.common.mime.MimeBodyPart;
import com.zimbra.common.mime.MimeHeaderBlock;
import com.zimbra.common.mime.MimePart;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeMultipart
extends MimePart
implements Iterable<MimePart> {
    static final String UNSET_BOUNDARY = "";
    private String mBoundary;
    private MimePart mPreamble;
    private MimePart mEpilogue;
    private List<MimePart> mChildren = new ArrayList<MimePart>(3);

    public MimeMultipart(String subtype) {
        super(new ContentType("multipart/" + (subtype == null || subtype.trim().equals(UNSET_BOUNDARY) ? "mixed" : subtype) + "; boundary=\"" + MimeMultipart.generateBoundary() + '\"'));
        this.mBoundary = this.getContentType().getParameter("boundary");
    }

    MimeMultipart(ContentType ctype, MimePart parent, long start, long body, MimeHeaderBlock headers) {
        super(ctype, parent, start, body, headers);
        this.mBoundary = ctype.getParameter("boundary");
        if (this.mBoundary == null || this.mBoundary.trim().equals(UNSET_BOUNDARY)) {
            this.mBoundary = UNSET_BOUNDARY;
        }
        while (this.mBoundary.length() > 0 && Character.isWhitespace(this.mBoundary.charAt(this.mBoundary.length() - 1))) {
            this.mBoundary = this.mBoundary.substring(0, this.mBoundary.length() - 1);
        }
    }

    private static String generateBoundary() {
        return "=_" + UUID.randomUUID().toString();
    }

    public int getCount() {
        return this.mChildren.size();
    }

    public MimePart getPreamble() {
        return this.mPreamble;
    }

    public MimePart getEpilogue() {
        return this.mEpilogue;
    }

    public MimePart getSubpart(int index) {
        return index < 1 || index > this.mChildren.size() ? null : this.mChildren.get(index - 1);
    }

    @Override
    public MimePart getSubpart(String part) {
        if (part == null || part.equals(UNSET_BOUNDARY)) {
            return this;
        }
        int dot = part.indexOf(46);
        if (dot == 0 || dot == part.length() - 1) {
            return null;
        }
        MimePart subpart = null;
        try {
            subpart = this.getSubpart(Integer.valueOf(dot == -1 ? part : part.substring(0, dot)));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (dot == -1 || subpart == null) {
            return subpart;
        }
        return subpart.getSubpart(part.substring(dot + 1));
    }

    @Override
    Map<String, MimePart> listMimeParts(Map<String, MimePart> parts, String prefix) {
        if (!prefix.equals(UNSET_BOUNDARY)) {
            prefix = prefix + '.';
        }
        for (int i = 0; i < this.mChildren.size(); ++i) {
            MimePart child = this.mChildren.get(i);
            String childName = prefix + (i + 1);
            parts.put(childName, child);
            child.listMimeParts(parts, childName);
        }
        return parts;
    }

    @Override
    public Iterator<MimePart> iterator() {
        return new ArrayList<MimePart>(this.mChildren).iterator();
    }

    public MimeMultipart addPart(MimePart mp) {
        return this.addPart(mp, this.mChildren.size() + 1);
    }

    public MimeMultipart addPart(MimePart mp, int index) {
        if (mp == null) {
            throw new NullPointerException();
        }
        if (index < 1 || index > this.mChildren.size() + 1) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        mp.setParent(this);
        this.mChildren.add(index - 1, mp);
        return this;
    }

    @Override
    void removeChild(MimePart mp) {
        this.mChildren.remove(mp);
    }

    @Override
    void checkContentType(ContentType ctype) {
        if (ctype == null || !ctype.getPrimaryType().equals("multipart")) {
            throw new UnsupportedOperationException("cannot change a multipart to text");
        }
    }

    @Override
    public void setContentType(ContentType ctype) {
        String newBoundary = ctype.getParameter("boundary");
        if (!this.mBoundary.equals(newBoundary)) {
            this.markDirty(true);
            this.mBoundary = newBoundary;
        }
        super.setContentType(ctype);
    }

    @Override
    public InputStream getRawContentStream() throws IOException {
        if (!this.isDirty()) {
            return super.getRawContentStream();
        }
        byte[] startBoundary = ("\r\n--" + this.mBoundary + "\r\n").getBytes();
        ArrayList<Object> sources = new ArrayList<Object>(this.mChildren.size() * 2 + 3);
        if (this.mPreamble != null) {
            sources.add(this.mPreamble);
        }
        for (MimePart mp : this.mChildren) {
            sources.add(sources.isEmpty() ? ("--" + this.mBoundary + "\r\n").getBytes() : startBoundary);
            sources.add(mp);
        }
        sources.add(("\r\n--" + this.mBoundary + "--\r\n").getBytes());
        if (this.mEpilogue != null) {
            sources.add(this.mEpilogue);
        }
        return new MimePart.VectorInputStream(sources);
    }

    @Override
    List<String> getActiveBoundaries() {
        ArrayList<String> inherited;
        ArrayList<String> arrayList = inherited = this.getParent() == null ? null : this.getParent().getActiveBoundaries();
        if (this.mBoundary != null) {
            inherited = inherited == null ? new ArrayList<String>(4) : inherited;
            inherited.add(0, this.mBoundary);
        }
        return inherited;
    }

    @Override
    MimePart readContent(MimePart.ParseState pstate) throws IOException {
        MimePart preamble = new MimeBodyPart(new ContentType("text/plain"), this, this.getBodyOffset(), pstate.getPosition(), null).readContent(pstate);
        MimePart.ParseState.BoundaryTerminator bterm = pstate.getBoundaryTerminator();
        if (this.mBoundary == UNSET_BOUNDARY && bterm != null && !bterm.mWasEndBoundary && !this.getActiveBoundaries().contains(bterm.mBoundary)) {
            this.mBoundary = bterm.mBoundary;
        }
        if (bterm == null || bterm.mWasEndBoundary || this.mBoundary == null || this.mBoundary.equals(UNSET_BOUNDARY) || !this.mBoundary.equals(bterm.mBoundary)) {
            this.mChildren.add(preamble);
        } else {
            if (preamble.getSize() > 0L) {
                this.mPreamble = preamble;
            }
            String defaultContentType = this.getContentType().getSubType().equals("digest") ? "message/rfc822" : "text/plain";
            do {
                MimePart subpart = MimePart.parse(pstate, this, defaultContentType);
                this.mChildren.add(subpart);
            } while ((bterm = pstate.getBoundaryTerminator()) != null && !bterm.mWasEndBoundary && this.mBoundary.equals(bterm.mBoundary));
            if (bterm != null && bterm.mWasEndBoundary && this.mBoundary.equals(bterm.mBoundary)) {
                MimePart epilogue = new MimeBodyPart(new ContentType("text/plain"), this, pstate.getPosition(), pstate.getPosition(), null).readContent(pstate);
                bterm = pstate.getBoundaryTerminator();
                if (epilogue.getSize() > 0L) {
                    this.mEpilogue = epilogue;
                }
            }
        }
        this.recordEndpoint(bterm == null ? pstate.getPosition() : bterm.mBoundaryStart);
        return this;
    }
}

