/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.common.mime;

import com.zimbra.common.mime.ContentTransferEncoding;
import com.zimbra.common.mime.ContentType;
import com.zimbra.common.mime.MimeBodyPart;
import com.zimbra.common.mime.MimeHeader;
import com.zimbra.common.mime.MimeHeaderBlock;
import com.zimbra.common.mime.MimeMultipart;
import com.zimbra.common.mime.MimePart;
import com.zimbra.common.util.ByteUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeMessage
extends MimePart {
    private Properties mProperties;
    private MimePart mBody;

    public MimeMessage(File file) throws IOException {
        this(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeMessage(File file, Properties props) throws IOException {
        super(new ContentType("message/rfc822"), null, 0L, 0L, null);
        this.mProperties = props;
        this.setContent(file, false);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), 8192);
        try {
            this.readContent(new MimePart.ParseState(new MimePart.PeekAheadInputStream(is)));
        }
        finally {
            ByteUtil.closeStream(is);
        }
    }

    public MimeMessage(byte[] body) {
        this(body, null);
    }

    public MimeMessage(byte[] body, Properties props) {
        super(new ContentType("message/rfc822"), null, 0L, 0L, null);
        this.mProperties = props;
        this.setContent(body, false);
        try {
            this.readContent(new MimePart.ParseState(new MimePart.PeekAheadInputStream(new ByteArrayInputStream(body))));
        }
        catch (IOException ioe) {
            throw new RuntimeException("completely unexpected IOException while reading from byte array", ioe);
        }
    }

    public MimeMessage(InputStream is) throws IOException {
        this(is, null);
    }

    public MimeMessage(InputStream is, Properties props) throws IOException {
        this(ByteUtil.getContent(is, -1), props);
    }

    MimeMessage(ContentType ctype, MimePart parent, long start, long body, MimeHeaderBlock headers) {
        super(ctype, parent, start, body, headers);
    }

    public static MimeMessage readStructure(InputStream is, Properties props) throws IOException {
        MimeMessage mm = new MimeMessage(new ContentType("message/rfc822"), null, 0L, 0L, null);
        mm.mProperties = props;
        if (!is.markSupported()) {
            is = new BufferedInputStream(is, 8192);
        }
        mm.readContent(new MimePart.ParseState(new MimePart.PeekAheadInputStream(is)));
        return mm;
    }

    public MimePart getBodyPart() {
        return this.mBody;
    }

    public void setBodyPart(MimePart body) {
        this.transferMessageHeaders(body);
        this.mBody.detach();
        this.mBody = body;
    }

    @Override
    void removeChild(MimePart mp) {
        if (mp == this.mBody) {
            this.mBody = this.transferMessageHeaders(new MimeBodyPart(null));
        }
    }

    private MimePart transferMessageHeaders(MimePart newBody) {
        Iterator<MimeHeader> it = this.mBody.mimeHeaderIterator();
        while (it.hasNext()) {
            MimeHeader header = it.next();
            if (header.getName().toLowerCase().startsWith("content-")) continue;
            newBody.addMimeHeader(header.getName(), header);
            it.remove();
        }
        return newBody;
    }

    @Override
    Properties getProperties() {
        return this.mProperties != null || this.getParent() == null ? this.mProperties : this.getParent().getProperties();
    }

    @Override
    public MimePart getSubpart(String part) {
        if (part == null || part.equals("")) {
            return this;
        }
        if (this.mBody == null) {
            return null;
        }
        boolean isMultipart = this.mBody instanceof MimeMultipart;
        if (part.equalsIgnoreCase("TEXT")) {
            return isMultipart ? this.mBody : null;
        }
        if (isMultipart) {
            return this.mBody.getSubpart(part);
        }
        int dot = part.indexOf(46);
        if (dot == part.length() - 1 || !"1".equals(dot == -1 ? part : part.substring(0, dot))) {
            return null;
        }
        return this.mBody.getSubpart(dot == -1 ? "" : part.substring(dot + 1));
    }

    public Map<String, MimePart> listMimeParts() {
        LinkedHashMap<String, MimePart> parts = new LinkedHashMap<String, MimePart>(6);
        parts.put("", this);
        return this.listMimeParts(parts, "");
    }

    @Override
    Map<String, MimePart> listMimeParts(Map<String, MimePart> parts, String prefix) {
        boolean isMultipart = this.mBody instanceof MimeMultipart;
        boolean topLevel = prefix.equals("");
        parts.put(prefix + (topLevel ? "" : ".") + (isMultipart ? "TEXT" : "1"), this.mBody);
        return this.mBody.listMimeParts(parts, prefix + (isMultipart ? "" : (topLevel ? "" : ".") + "1"));
    }

    public String getHeader(String name) {
        return this.mBody.getMimeHeader(name);
    }

    public byte[] getRawHeader(String name) {
        return this.mBody.getRawMimeHeader(name);
    }

    public void setHeader(String name, String value) {
        this.mBody.setMimeHeader(name, value);
    }

    @Override
    public void setContentType(ContentType ctype) {
        if (ctype == null) {
            ctype = new ContentType("message/rfc822");
        } else if (!ctype.getValue().equals("message/rfc822")) {
            throw new UnsupportedOperationException("cannot change a message to another type");
        }
        super.setContentType(ctype);
    }

    @Override
    void checkContentType(ContentType ctype) {
        if (ctype == null || !ctype.getValue().equals("message/rfc822")) {
            throw new UnsupportedOperationException("cannot change a message to text");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getParent() != null ? super.getInputStream() : this.mBody.getInputStream();
    }

    @Override
    public InputStream getRawContentStream() throws IOException {
        return this.getParent() != null || this.isDirty() ? this.mBody.getInputStream() : super.getRawContentStream();
    }

    @Override
    MimePart readContent(MimePart.ParseState pstate) throws IOException {
        this.mBody = MimePart.parse(pstate, this, "text/plain");
        this.recordEndpoint(this.mBody.getEndOffset());
        return this;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        MimeMessage mm = new MimeMessage(new File("C:\\Temp\\mail\\24250"));
        mm.setHeader("X-Mailer", "Zimbra 5.0 RC2");
        mm = new MimeMessage(new File("C:\\Temp\\mail\\digest-attachment-16771"));
        mm = new MimeMessage(new File("C:\\Temp\\mail\\bad-ctype-params-11946"));
        ((MimeBodyPart)mm.getSubpart("1")).setTransferEncoding(ContentTransferEncoding.SEVEN_BIT);
        mm = new MimeMessage(new File("C:\\Temp\\blank-base64-ellen"));
        MimeMessage.dumpParts(mm);
        ((MimeMultipart)mm.getBodyPart()).setContentType(((MimeMultipart)mm.getBodyPart()).getContentType().setParameter("boundary", "b*o*u*n*d*a*r*y"));
        mm = new MimeMessage(new File("C:\\Temp\\mail\\partial-multipart-5775"));
        mm = new MimeMessage(new File("C:\\Temp\\mail\\zimbra-accent"));
        ((MimeBodyPart)mm.getSubpart("1")).setContentType(new ContentType("text/plain; format=flowed; charset=iso-8859-2"));
        ((MimeBodyPart)mm.getSubpart("1")).setTransferEncoding(ContentTransferEncoding.BASE64);
        ((MimeMultipart)mm.getBodyPart()).setContentType(((MimeMultipart)mm.getBodyPart()).getContentType().setParameter("boundary", "b*o*u*n*d*a*r*y"));
        MimeBodyPart body = new MimeBodyPart(new ContentType("text/enriched; charset=us-ascii"));
        body.setMimeHeader("Content-Disposition", "attachment; filename=bar.txt");
        body.setText("espionage detected!");
        MimeMultipart multi = new MimeMultipart("mixed");
        multi.addPart(mm.getBodyPart());
        multi.addPart(body);
        mm.setBodyPart(multi);
        mm = MimeMessage.readStructure(new FileInputStream(new File("C:\\Temp\\mail\\report-attachment-6667")), null);
        mm = new MimeMessage(new File("C:\\Temp\\mail\\report-attachment-6667"));
        ((MimeBodyPart)mm.getSubpart("1")).setTransferEncoding(ContentTransferEncoding.QUOTED_PRINTABLE);
    }

    private static void dumpParts(MimeMessage mm) {
        for (Map.Entry<String, MimePart> mpi : mm.listMimeParts().entrySet()) {
            MimePart part = mpi.getValue();
            System.out.println('\"' + mpi.getKey() + "\": " + part.getContentType().getValue() + (part.getFilename() == null ? "" : " [" + part.getFilename() + "]"));
            if (part.getMimeHeader("Content-Description") != null) {
                System.out.println("   {" + part.getMimeHeader("Content-Description") + "}");
            }
            if (mm.getSubpart(mpi.getKey()) == mpi.getValue()) continue;
            System.out.println("  MISMATCH!");
        }
    }
}

